/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.ibm.icu.text.Collator;
import com.iizix.ILog;
import com.iizix.IWebServerCompression;
import com.iizix.Loggers;
import com.iizix.RunMode;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.comm.IServerSettings;
import com.iizix.comm.PortConfig;
import com.iizix.jdbc.JDBCHelper;
import com.iizix.jetty.IExternalBrowserPages;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.IWSUploaderService;
import com.iizix.jetty.IWebServerDirectoryMapper;
import com.iizix.jetty.RunConfigurationWebServer;
import com.iizix.jetty.WSHelper;
import com.iizix.nio.WebSocketAcceptor;
import com.iizix.prop.Atom;
import com.iizix.prop.PropException;
import com.iizix.security.CertificateHelper;
import com.iizix.server.IServer;
import com.iizix.server.ServerShell;
import com.iizix.server.app.AppDefinition;
import com.iizix.server.app.DBApp;
import com.iizix.server.app.SystemApp;
import com.iizix.server.client.ClientEndPointConstructor;
import com.iizix.server.db.DBFunctions;
import com.iizix.server.db.DBUtilities;
import com.iizix.server.devel.ExternalBrowserPagesImpl;
import com.iizix.server.modules.IServerModule;
import com.iizix.server.monitor.VirtualizedMonitorEndPointConstructor;
import com.iizix.server.oauth.OAuthEngine;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.push.PushNotificationInterceptor;
import com.iizix.server.vsviewer.VSViewerEndPointConstructor;
import com.iizix.web.ICommonServletInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JettyRunConfiguration
extends ServerShell {
    private String a;
    private String b;
    private File a;
    private final boolean a;
    private final Map<String, File> a;
    private RunConfigurationWebServer a;
    private final AppDefinition[] a;
    private boolean b;

    public static void main(String[] stringArray) {
        JettyRunConfiguration.main(stringArray, true, JettyRunConfiguration.class);
    }

    protected static void main(String[] stringArray, boolean bl, Class<? extends JettyRunConfiguration> clazz) {
        RunMode.setRunMode((RunMode)(bl ? RunMode.SERVER_DEVELOPMENT : RunMode.SERVER));
        StringBuilder stringBuilder = new StringBuilder("\nIIZI ").append(bl ? "Development " : "Production ").append("Server, Version ").append(SystemConfig.VERSION_BUILD).append('\n');
        stringBuilder.append("-".repeat(stringBuilder.length() - 2)).append("\n\n").append("(C) Copyright Mindus SARL, 2026.\nAll rights reserved.").append('\n');
        if (!SystemConfig.HAS_UNLIMITED_CRYPTO) {
            System.err.println(String.valueOf(stringBuilder) + "\nJava Unlimited Cryptography is missing or cannot be configured!\niiziServer does not function if the Java Unlimited JCE Policy is not installed\nin JRE/JDK lib/security directory.\n\nPlease download it from the Oracle Java site\nand install it before continuing.\n\niiziServer cannot start.\n\n");
            System.exit(9);
        }
        if (stringArray.length == 0) {
            System.out.println(JettyRunConfiguration.addSyntax(bl, stringBuilder));
            System.exit(9);
        }
        System.out.println(stringBuilder);
        ILog.setLogLevel((int)3);
        ArrayList<IServerModule> arrayList = new ArrayList<IServerModule>();
        HashMap<String, File> hashMap = new HashMap<String, File>();
        File file = new File("config.iiziServer").getAbsoluteFile();
        Object object = null;
        ServerShell serverShell = null;
        boolean bl2 = false;
        try {
            AppDefinition[] appDefinitionArray32;
            String string;
            String string2 = null;
            String string3 = null;
            int n = stringArray.length;
            HashMap<Object, String> hashMap2 = new HashMap<Object, String>();
            LinkedHashMap<String, AppDefinition> linkedHashMap = new LinkedHashMap<String, AppDefinition>();
            boolean bl3 = true;
            boolean bl4 = true;
            String string4 = string = "default";
            String string5 = null;
            String string6 = null;
            String string7 = null;
            String string8 = null;
            Integer n2 = null;
            Boolean bl5 = null;
            Boolean bl6 = null;
            boolean bl7 = false;
            int n3 = 0;
            while (n3 < n) {
                block140: {
                    appDefinitionArray32 = stringArray[n3].toLowerCase();
                    boolean bl8 = appDefinitionArray32.startsWith("##");
                    do {
                        if (++n3 >= n) {
                            if (!bl8) {
                                throw new Exception("Illegal option " + (String)appDefinitionArray32 + ": missing parameter");
                            }
                            break block140;
                        }
                        if (bl8) break block140;
                    } while (stringArray[n3].startsWith("##"));
                    String object2 = Utilities.unquotedStringWithSpaces((String)stringArray[n3]);
                    AppDefinition[] appDefinitionArray = appDefinitionArray32;
                    int n4 = -1;
                    switch (appDefinitionArray32.hashCode()) {
                        case -1085570124: {
                            if (appDefinitionArray.equals("-#eclipsecertsdir#")) {
                                n4 = 1;
                            }
                            break;
                        }
                        case -832992349: {
                            if (appDefinitionArray.equals("-jdbcdrivers")) {
                                n4 = 2;
                            }
                            break;
                        }
                        case -535578137: {
                            if (appDefinitionArray.equals("-hotdeploy")) {
                                n4 = 3;
                            }
                            break;
                        }
                        case -229283050: {
                            if (appDefinitionArray.equals("-dbautocreate")) {
                                n4 = 4;
                            }
                            break;
                        }
                        case -128103737: {
                            if (appDefinitionArray.equals("-appjar")) {
                                n4 = 5;
                            }
                            break;
                        }
                        case -71832145: {
                            if (appDefinitionArray.equals("-config")) {
                                n4 = 6;
                            }
                            break;
                        }
                        case -55527665: {
                            if (appDefinitionArray.equals("-dbconf")) {
                                n4 = 7;
                            }
                            break;
                        }
                        case -55378541: {
                            if (appDefinitionArray.equals("-dbhost")) {
                                n4 = 8;
                            }
                            break;
                        }
                        case -55140244: {
                            if (appDefinitionArray.equals("-dbport")) {
                                n4 = 9;
                            }
                            break;
                        }
                        case 1437396: {
                            if (appDefinitionArray.equals("-app")) {
                                n4 = 10;
                            }
                            break;
                        }
                        case 1441184: {
                            if (appDefinitionArray.equals("-env")) {
                                n4 = 11;
                            }
                            break;
                        }
                        case 45064847: {
                            if (appDefinitionArray.equals("-root")) {
                                n4 = 12;
                            }
                            break;
                        }
                        case 214175961: {
                            if (appDefinitionArray.equals("-module")) {
                                n4 = 13;
                            }
                            break;
                        }
                        case 759351377: {
                            if (appDefinitionArray.equals("-serverdescr")) {
                                n4 = 14;
                            }
                            break;
                        }
                        case 807743052: {
                            if (appDefinitionArray.equals("-project")) {
                                n4 = 15;
                            }
                            break;
                        }
                        case 1123587770: {
                            if (appDefinitionArray.equals("-compresshtml")) {
                                n4 = 16;
                            }
                            break;
                        }
                        case 1381214787: {
                            if (appDefinitionArray.equals("-alias")) {
                                n4 = 17;
                            }
                            break;
                        }
                        case 1383682882: {
                            if (appDefinitionArray.equals("-dbdir")) {
                                n4 = 18;
                            }
                            break;
                        }
                        case 1420225273: {
                            if (appDefinitionArray.equals("-defaultenv")) {
                                n4 = 19;
                            }
                            break;
                        }
                        case 1725242104: {
                            if (appDefinitionArray.equals("-extserverurl")) {
                                n4 = 20;
                            }
                            break;
                        }
                        case 1808551688: {
                            if (appDefinitionArray.equals("-dbautostart")) {
                                n4 = 21;
                            }
                            break;
                        }
                    }
                    switch (n4) {
                        case 6: {
                            file = new File(object2).getCanonicalFile();
                            if (file.isFile()) break;
                            throw new FileNotFoundException("Configuration file '" + file.getPath() + "' does not exist");
                        }
                        case 19: {
                            if (object2.isEmpty()) {
                                throw new Exception("Empty default server environment name");
                            }
                            string = string4 = object2;
                            break;
                        }
                        case 14: {
                            if (object2.isEmpty()) {
                                throw new Exception("Empty server description, often a (double-)quoted string");
                            }
                            if (string5 != null) {
                                throw new Exception("Server description is set twice, first time = \"" + string5 + "\"");
                            }
                            string5 = object2;
                            break;
                        }
                        case 16: {
                            boolean bl9;
                            if (bl) {
                                bl9 = object2.equalsIgnoreCase("true");
                                if (!bl9 && !object2.equalsIgnoreCase("false")) {
                                    object = "Set compressHTML flag \"" + object2 + "\" error: must be 'true' or 'false'";
                                    throw new Exception((String)object);
                                }
                                bl2 = bl9;
                                break;
                            }
                            object = "Unknown option " + (String)appDefinitionArray32;
                            throw new Exception((String)object);
                        }
                        case 2: {
                            boolean bl9 = object2.equalsIgnoreCase("privatecopy");
                            object = bl9 || object2.equalsIgnoreCase("private") ? JDBCHelper.setUsePrivateDirectory((boolean)bl9) : "Set jdbcdrivers flag must be \"" + object2 + "\" error: must be 'private' or 'privatecopy'";
                            break;
                        }
                        case 7: {
                            object = "Database configuration directory \"" + Utilities.getCanonicalFile((String)object2).getPath() + "\" error";
                            DBUtilities.setDBConfDir(object2);
                            break;
                        }
                        case 18: {
                            object = "Set database directory \"" + object2 + "\" error";
                            string7 = object2;
                            DBUtilities.setDirectory(object2);
                            break;
                        }
                        case 8: {
                            object = "Set database host \"" + object2 + "\" error";
                            string8 = object2;
                            DBUtilities.setServerHost(object2);
                            break;
                        }
                        case 9: {
                            object = "Set database port \"" + object2 + "\" error";
                            n2 = Integer.parseInt(object2);
                            DBUtilities.setServerPort(n2);
                            break;
                        }
                        case 4: {
                            boolean bl9 = object2.equalsIgnoreCase("true");
                            if (!bl9 && !object2.equalsIgnoreCase("false")) {
                                object = "Set database auto-creation flag \"" + object2 + "\" error: must be 'true' or 'false'";
                                throw new Exception((String)object);
                            }
                            bl5 = bl9;
                            break;
                        }
                        case 21: {
                            boolean bl9 = object2.equalsIgnoreCase("true");
                            if (!bl9 && !object2.equalsIgnoreCase("false")) {
                                object = "Set database server auto-start flag \"" + object2 + "\" error: must be 'true' or 'false'";
                                throw new Exception((String)object);
                            }
                            bl6 = bl9;
                            break;
                        }
                        case 20: {
                            if (object2.isEmpty()) {
                                object = "External server URL is empty";
                                throw new Exception("External server URL is empty");
                            }
                            object = WSHelper.validateExternalHostName((String)object2);
                            if (object != null) {
                                throw new Exception((String)object);
                            }
                            string2 = object2;
                            break;
                        }
                        case 12: {
                            object = "Invalid root: " + object2;
                            File file2 = new File(object2).getCanonicalFile();
                            if (!file2.isDirectory()) {
                                throw new FileNotFoundException("Directory '" + file2.getPath() + "' does not exist");
                            }
                            string3 = file2.getPath();
                            break;
                        }
                        case 17: {
                            String string9 = Utilities.unquotedStringWithSpaces((String)object2);
                            if (n3 + 1 >= n) {
                                throw new Exception("Directory alias '" + string9 + "' does not specify a directory");
                            }
                            File file2 = new File(Utilities.unquotedStringWithSpaces((String)stringArray[++n3]));
                            try {
                                file2 = file2.getCanonicalFile();
                                if (!file2.isDirectory() || !file2.canRead()) {
                                    throw new Exception("Directory alias '" + string9 + "', directory \"" + String.valueOf(file2) + "\" does not exist or cannot be read from");
                                }
                            }
                            catch (IOException iOException) {
                                throw new Exception("Directory alias '" + string9 + "' does not specify a directory: \"" + String.valueOf(file2) + "\"", iOException);
                            }
                            hashMap.put(string9, file2);
                            break;
                        }
                        case 3: {
                            boolean bl9 = Boolean.parseBoolean(object2);
                            if (string6 == null) {
                                bl4 = bl9;
                                break;
                            }
                            bl3 = bl9;
                            break;
                        }
                        case 10: {
                            Object object3;
                            String[] stringArray2 = object2.split(":");
                            if (stringArray2.length == 0 || (string6 = stringArray2[0]).isEmpty()) {
                                throw new Exception("App ID is not specified: " + object2);
                            }
                            if (linkedHashMap.containsKey(stringArray2[0])) {
                                throw new Exception("App ID already specified: " + stringArray2[0]);
                            }
                            String[] stringArray3 = stringArray2;
                            int throwable = stringArray2.length;
                            int n5 = 0;
                            while (n5 < throwable) {
                                object3 = stringArray3[n5];
                                IServer.InvalidAppID invalidAppID = IServer.validateAppID((String)object3);
                                if (invalidAppID != null) {
                                    throw new Exception(invalidAppID.englishText + ": " + (String)object3);
                                }
                                if (hashMap2.putIfAbsent(object3, string6) != null) {
                                    throw new Exception("App (alias) ID '" + (String)object3 + "' already specified: " + object2);
                                }
                                ++n5;
                            }
                            bl7 = false;
                            bl3 = bl4;
                            break;
                        }
                        case 11: {
                            if (object2.isEmpty()) {
                                throw new Exception("Empty server environment name");
                            }
                            string4 = object2;
                            break;
                        }
                        case 15: {
                            if (string6 == null) {
                                throw new Exception("Application ID not specified (-app AppID) prior to project (-project NAME=path)");
                            }
                            if (bl7) {
                                throw new Exception("Projects cannot be mixed with a single Application Jar file in Application ID " + string6);
                            }
                            object = "Invalid project: " + object2;
                            File file2 = new File(object2).getCanonicalFile();
                            if (!file2.isDirectory()) {
                                throw new FileNotFoundException("Directory does not exist");
                            }
                            Object object3 = (AppDefinition)linkedHashMap.get(string6);
                            if (object3 == null) {
                                object3 = new AppDefinition(string6, string4, null, bl3);
                                linkedHashMap.put(string6, (AppDefinition)object3);
                            }
                            ((AppDefinition)object3).addModuleDirectory(file2);
                            break;
                        }
                        case 5: {
                            if (string6 == null) {
                                throw new Exception("Application ID not specified (-app AppID) prior to project (-appjar NAME=path)");
                            }
                            if (bl7) {
                                throw new Exception("A single Application Jar file per Application ID (" + string6 + ") is allowed");
                            }
                            object = "Invalid application jar: " + object2;
                            File file3 = new File(object2).getCanonicalFile();
                            if (!file3.isFile()) {
                                throw new FileNotFoundException("Application jar file does not exist: " + object2);
                            }
                            if (!file3.getName().toLowerCase().endsWith(".jar")) {
                                throw new FileNotFoundException("Application jar file name must end with \".jar\": " + object2);
                            }
                            Object object3 = new AppDefinition(string6, string4, file3, bl3);
                            linkedHashMap.put(string6, (AppDefinition)object3);
                            bl7 = true;
                            break;
                        }
                        case 13: {
                            if (bl) {
                                throw new Exception("Server Modules is only available in Standard iiziServer");
                            }
                            try {
                                IServerModule file5 = (IServerModule)IServerModule.class.cast(Class.forName(object2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                                arrayList.add(file5);
                                break;
                            }
                            catch (Throwable iServerModule) {
                                throw new Exception("Server Module " + object2 + " failed loading", iServerModule);
                            }
                        }
                        case 1: {
                            if (bl) {
                                File file4 = Utilities.getCanonicalFile((File)new File(object2));
                                try {
                                    JettyRunConfiguration.a(file4);
                                    break;
                                }
                                catch (Exception exception) {
                                    object = "Failed loading code signing certificate from \"" + String.valueOf(file4) + "\"";
                                    throw new Exception((String)object, exception);
                                }
                            }
                        }
                        default: {
                            for (IServerModule iServerModule : arrayList) {
                                int n6 = iServerModule.processServerArg(stringArray, object2, n3 + 1);
                                if (n6 <= 0) continue;
                                n3 += n6 - 1;
                                break;
                            }
                            object = "Unknown option " + (String)appDefinitionArray32;
                            throw new Exception((String)object);
                        }
                    }
                }
                ++n3;
            }
            stringBuilder.setLength(0);
            stringBuilder.append("Config file         = ").append(file.getAbsolutePath()).append('\n').append("Environment         = ").append(string4).append('\n');
            if (string2 != null) {
                stringBuilder.append("External server URL = ").append(string2).append('\n');
            }
            if (string5 != null) {
                stringBuilder.append("Server description  = ").append(string5).append('\n');
            }
            stringBuilder.append("Web server root     = ").append(string3).append('\n').append("Hot deploy          = ").append(bl4).append('\n').append("Database directory  = ").append(DBUtilities.getDatabaseDirectory());
            ArrayList arrayList2 = new ArrayList(hashMap.keySet());
            arrayList2.sort(Collator.getInstance((Locale)Locale.ENGLISH));
            for (AppDefinition[] appDefinitionArray32 : arrayList2) {
                stringBuilder.append('\n').append("Web server alias    = /").append((String)appDefinitionArray32).append("~/ ==> ").append(hashMap.get(appDefinitionArray32));
            }
            System.out.println(stringBuilder);
            if (linkedHashMap.isEmpty()) {
                System.out.println("No IIZI Module projects are specified!");
                System.exit(9);
            }
            if (!file.isFile()) {
                System.out.println("Server configuration file '" + file.getAbsolutePath() + "' is not found");
                System.exit(9);
            }
            object = "Failed server creation";
            appDefinitionArray32 = linkedHashMap.values().toArray(new AppDefinition[linkedHashMap.size()]);
            serverShell = clazz.getConstructor(File.class, String.class, String.class, Boolean.TYPE, appDefinitionArray32.getClass(), Map.class, Map.class).newInstance(file, string2, string3, bl4, appDefinitionArray32, hashMap2, hashMap);
            try {
                SystemApp.loadApp(serverShell.getPropertyFactory(), serverShell.getPropertyManager());
            }
            catch (PropException | IOException throwable) {
                throw new IOException("Failed loading System application", throwable);
            }
            ServerSettings serverSettings = serverShell.getServerSettings();
            if (string5 != null) {
                serverSettings.setDescription(string5);
            }
            ((JettyRunConfiguration)serverShell).b = bl2;
            serverShell.loadPluginsAndConfig();
            serverShell.configureSessionMgr();
            for (IServerModule iServerModule : arrayList) {
                serverShell.addModule(iServerModule);
            }
            if (string7 == null) {
                string7 = (String)serverSettings.getPropValue("$dbDirectory", String.class);
            }
            if (string8 == null) {
                string8 = (String)serverSettings.getPropValue("$dbHost", String.class);
            }
            if (n2 == null) {
                n2 = (Integer)serverSettings.getPropValue("$dbPort", Integer.class);
            }
            if (bl5 == null) {
                bl5 = (Boolean)serverSettings.getPropValue("$dbAutoCreate", Boolean.class);
            }
            if (bl6 == null) {
                bl6 = (Boolean)serverSettings.getPropValue("$dbAutoStart", Boolean.class);
            }
            if (string7 != null) {
                object = "Database directory \"" + string7 + "\" configuration parameter error";
                DBUtilities.setDirectory(string7);
            }
            if (string8 != null) {
                object = "Database host \"" + string8 + "\" configuration parameter error";
                DBUtilities.setServerHost(string8);
            }
            if (n2 != null) {
                object = "Database server port number configuration parameter error";
                DBUtilities.setServerPort(n2);
            }
            if (bl5 != null) {
                DBUtilities.setAutoCreate(bl5);
            }
            if (bl6 != null) {
                DBUtilities.setServerAutoStart(bl6);
            }
            object = "Failed starting server";
            serverShell.startServer();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(clazz, object, (Throwable)throwable);
            ILog.SEVERE(clazz, (String)"iiziServer failed to start, exiting with RC = 9");
            Loggers.setRedirector(null);
            if (serverShell != null) {
                serverShell.dispose();
            }
            Throwable throwable2 = null;
            Object var12_16 = null;
            try (PrintStream printStream = Loggers.get_stdout();){
                printStream.println(JettyRunConfiguration.addSyntax(bl, new StringBuilder()));
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            System.exit(9);
        }
    }

    protected static String addSyntax(boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("\nSyntax:\n  ##[anytext]   Any option or parameter prefixed with '##' will automatically discard the option followed by its parameter.\n\nGeneral:\n  -config       {path/config.iiziServer}  Specifies the server configuration file\n  -defaultenv   {envName} config          Sets the default environment name\n  -extserverurl {URL}                     Sets the external URL of the server as e.g. http[s]://hostName[:port]/[path/]\n  -serverDescr  {String}                  Sets the description of the server, overriding the server settings\n");
        if (bl) {
            stringBuilder.append("  -compressHTML {true|false}              Enables compression of e.g. iiziApp.html, iiziVSViewer.html (default true)\n");
        }
        stringBuilder.append("\nWeb server:\n  -root         {directory}               Sets the root directory of the web server (default 'root' under the current directory)\n  -alias        {root-directory-alias} {target-directory}  Sets the alias for a directory somewhere in the web server root,\n                                          to another 'target-directory' enabling e.g. common files or large directories to be shared\n                                          across different web servers\n\nDatabase:\n  -dbconf       {driverspec-URL}          Database configuration directory with JDBC driver Jar, settings, etc\n  -dbdir        {directory}               Sets the database directory for the iiziServer (default 'db')\n  -dbhost       {nameOrIPaddress}         Sets the host name or IP address to the Derby server (default 'localhost')\n  -dbport       {port}                    Sets the port number to the Derby server (default 1527)\n  -dbautostart  {true|false}              Turns on (default) or off automatic database server start\n  -dbautocreate {true|false}              Turns on (default) or off database creation at start\n\nApplication:\n  -hotdeploy    {true|false}              Turns on (default) or off for the application defintions that follows\n  -app          {appID:...:appIDnn}       Begins the definition of the application 'appID' with additional colon-separated aliases\n  -env          {name}                    Defines the name for the application environment (specify '-env' after '-app')\n  -project      {directory}               A module project directory 'dir' (as defined in Eclipse) to the current application\n  -appjar       {iiziApp.jar}             Adds an IIZI Distribution Application 'iiziApp.jar' by Jar file path and name\n\n");
        if (!bl) {
            stringBuilder.append("Modules:\n  -module       {fullyQualifiedclassName} Adds a server module to load and initialize\n\n");
        }
        return stringBuilder.toString();
    }

    private static void a(File file) throws CertificateException, FileNotFoundException, IOException {
        X509Certificate[] x509CertificateArray = CertificateHelper.loadCertificates((File)file);
        CertificateHelper.assignCertificateFromEclipseBundle(clazz -> {
            String string = clazz.getName();
            return string.startsWith("com.iizix.") || string.startsWith("com.iizigo.") ? x509CertificateArray : CertificateHelper.EMPTY_ARRAY;
        });
    }

    public JettyRunConfiguration(File file, String string, String string2, boolean bl, AppDefinition[] appDefinitionArray, Map<String, String> map, Map<String, File> map2) throws IOException, PropException {
        super(file);
        this.a = string;
        this.a = new File(string2).getCanonicalFile();
        this.b = string2;
        this.a = bl;
        this.a = appDefinitionArray;
        this.a = map2;
        this.a(map);
    }

    @Override
    public void onStartServer() throws Throwable {
        Object object;
        if (this.a() == null) {
            throw new Exception("License System is not found");
        }
        ServerSettings serverSettings = this.getServerProperties().getServerSettings();
        if (this.a != null) {
            serverSettings.setExternalHostName(this.a);
        } else {
            this.a = serverSettings.getExternalHostName();
        }
        if (this.b != null) {
            serverSettings.setRootDirectory(this.b);
        } else if (serverSettings.getString(Atom.ROOT) == null) {
            try {
                this.b = new File("/iizi/com.iizix.js/js/root").getCanonicalPath();
            }
            catch (IOException iOException) {
                this.b = new File(".").getAbsolutePath();
            }
            serverSettings.setRootDirectory(this.b);
        } else {
            this.b = serverSettings.getRootDirectory();
        }
        DBUtilities.getPooledConnection().close();
        this.registerEndPointConstructor(new ClientEndPointConstructor());
        if (RunMode.isServerRunDevelopmentMode()) {
            this.registerEndPointConstructor(new VirtualizedMonitorEndPointConstructor());
            this.registerEndPointConstructor(new VSViewerEndPointConstructor());
        }
        this.a = new RunConfigurationWebServer(this.b, (IWSFileProviderServer)this.a, (IWSUploaderService)this.a, (Map)((Object)this.a));
        this.externalBrowserPages = new ExternalBrowserPagesImpl(this);
        ICommonServletInterface[] iCommonServletInterfaceArray = new ICommonServletInterface[]{PushNotificationInterceptor.register(this)};
        PortConfig[] portConfigArray = this.a.startWebServer((IExternalBrowserPages)this.externalBrowserPages, (WebSocketAcceptor)this, (IServerSettings)serverSettings, () -> {
            this.initializeCompressedFiles();
            return null;
        }, iCommonServletInterfaceArray);
        String string = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        PortConfig[] portConfigArray2 = portConfigArray;
        int n3 = portConfigArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = portConfigArray2[n4];
            if (object.isHTTPS) {
                n2 = object.port;
                string = object.bind;
                break;
            }
            if (object.isFrontEndSecured) {
                bl = true;
                string = object.bind;
                break;
            }
            n = object.port;
            string = object.bind;
            ++n4;
        }
        object = WSHelper.getExternalBaseServerURL((String)this.a, string, (int)n, (int)n2, (boolean)bl);
        OAuthEngine.initializeNewInstance((String)object);
        ILog.INFO(this.getClass(), (String)("Web server external server URL is " + (String)object));
    }

    @Override
    public String getRootDirectory() {
        return this.b;
    }

    @Override
    public File getRootCanonicalDirectory() {
        return this.a;
    }

    public final boolean useHotDeploy() {
        return this.a;
    }

    @Override
    public final void loadApplications() throws Throwable {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        AppDefinition[] appDefinitionArray = this.a;
        int n = this.a.length;
        int n2 = 0;
        while (n2 < n) {
            object = appDefinitionArray[n2];
            ((AppDefinition)object).loadApplication(this);
            hashSet.add(((AppDefinition)object).id);
            ++n2;
        }
        object = DBFunctions.getEnabledApps(hashSet);
        DBApp[] dBAppArray = object;
        int n3 = ((DBApp[])object).length;
        n = 0;
        while (n < n3) {
            DBApp dBApp = dBAppArray[n];
            AppDefinition appDefinition = new AppDefinition(dBApp, this.a);
            appDefinition.loadApplication(this);
            ++n;
        }
    }

    @Override
    protected void onDispose() {
        if (this.a != null) {
            this.a.stopWebServer(5000L);
        }
    }

    @Override
    public File getWebServerMapping(String string) {
        return this.a != null ? this.a.getWebServerMapping(string) : null;
    }

    @Override
    public File getWebServerDirectoryAlias(String string) {
        return this.a != null ? this.a.getWebServerDirectoryAlias(string) : null;
    }

    @Override
    public IWebServerCompression getWebServerCompression() {
        return this.a;
    }

    @Override
    public boolean doCompressNormalHTML() {
        return SystemConfig.WEB_COMPRESS || this.b;
    }

    public Proxy getProxy(URL uRL) {
        return Proxy.NO_PROXY;
    }

    public void configureProxy(HttpURLConnection httpURLConnection) {
    }

    @Override
    public final IWebServerDirectoryMapper getWebServerDirectoryMapper() {
        return this.a;
    }
}

