/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;

public class BigIntegerValue
extends NumberValue<BigInteger> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.BigInteger;
    }

    @Override
    public Class<BigInteger> getValueClass() {
        return BigInteger.class;
    }

    @Override
    public String getDescription() {
        return "Arbitrary-precision integer";
    }

    @Override
    public BigInteger createDefault() {
        return BigInteger.ZERO;
    }

    @Override
    public BigInteger parse(String string) throws NumberFormatException {
        return new BigInteger(string);
    }

    @Override
    public BigInteger convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof Number) {
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).toBigInteger();
            }
            if (object instanceof Double) {
                double d2 = Math.round((Double)object);
                return new BigDecimal(d2).toBigInteger();
            }
            if (object instanceof Float) {
                double d3 = Math.round(((Float)object).floatValue());
                return new BigDecimal(d3).toBigInteger();
            }
            return BigInteger.valueOf(((Number)object).longValue());
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return BigInteger.valueOf(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

