/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.NotFoundException;
import com.iizix.api.vs.FullVSRef;
import com.iizix.api.vs.VSRef;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IFocusComp;
import com.iizix.gyro.IMessageBox;
import com.iizix.gyro.IMessageBoxReply;
import com.iizix.prop.Atom;
import com.iizix.prop.ICustomDataProvider;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.vs.IVSComponentListener;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSGroup;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.text.KString;

public interface IVSComponent
extends IFocusComp,
IMessageBox,
ICustomDataProvider,
IVSComponentListener {
    public static final int NONE = -1;
    public static final int INFORMATION = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final Atom ATOM_IGNORE_UI_FOCUS = Atom.get("$ignoreUIFocus");

    default public String getDescription() {
        return this.getString(Atom.DESCR);
    }

    public VirtualSpace getVirtualSpace();

    public IVSComponent getNonVirtualized();

    default public boolean isEnabled() {
        return this.getBool(Atom.ENABLED, true);
    }

    default public boolean isEnabledInParent() {
        if (this.getBool(Atom.ENABLED, true)) {
            if (this instanceof VirtualSpace) {
                return true;
            }
            PropCnr propCnr = this.getParent();
            if (propCnr instanceof IVSComponent) {
                IVSComponent iVSComponent = (IVSComponent)((Object)propCnr);
                return iVSComponent.isEnabledInParent();
            }
        }
        return false;
    }

    default public boolean setEnabled(boolean bl) {
        return this.setEnabled(bl, null);
    }

    default public boolean setEnabled(boolean bl, IGProp<?> iGProp) {
        if (bl == this.getBool(Atom.ENABLED, true)) {
            return false;
        }
        if (bl) {
            this.removeProp2(Atom.ENABLED, iGProp);
        } else {
            this.setBool(Atom.ENABLED, false, true, iGProp);
        }
        return true;
    }

    default public boolean isReadOnly() {
        return this.getBool(Atom.READONLY, false);
    }

    default public boolean isReadOnlyInParent() {
        if (!this.getBool(Atom.READONLY, false)) {
            if (this instanceof VirtualSpace) {
                return false;
            }
            PropCnr propCnr = this.getParent();
            if (propCnr instanceof IVSComponent) {
                IVSComponent iVSComponent = (IVSComponent)((Object)propCnr);
                return iVSComponent.isReadOnlyInParent();
            }
        }
        return true;
    }

    default public boolean setReadOnly(boolean bl) {
        return this.setReadOnly(bl, null);
    }

    default public boolean setReadOnly(boolean bl, IGProp<?> iGProp) {
        if (bl == this.getBool(Atom.READONLY, false)) {
            return false;
        }
        if (bl) {
            this.setBool(Atom.READONLY, true, true, iGProp);
        } else {
            this.removeProp2(Atom.READONLY, iGProp);
        }
        return true;
    }

    default public boolean isVisible() {
        return this.getBool(Atom.VISIBLE, true);
    }

    default public boolean isVisibleInParent() {
        if (this.getBool(Atom.VISIBLE, true)) {
            if (this instanceof VirtualSpace) {
                return true;
            }
            PropCnr propCnr = this.getParent();
            if (propCnr instanceof IVSComponent) {
                IVSComponent iVSComponent = (IVSComponent)((Object)propCnr);
                return iVSComponent.isVisibleInParent();
            }
        }
        return false;
    }

    default public boolean setVisible(boolean bl) {
        return this.setVisible(bl, null);
    }

    default public boolean setVisible(boolean bl, IGProp<?> iGProp) {
        if (bl == this.getBool(Atom.VISIBLE, true)) {
            return false;
        }
        if (bl) {
            this.removeProp2(Atom.VISIBLE, iGProp);
        } else {
            this.setBool(Atom.VISIBLE, false, true, iGProp);
        }
        return true;
    }

    default public boolean isSelected() {
        return this.getBool(Atom.SELECTED, false);
    }

    default public boolean setSelected(boolean bl) {
        return this.setSelected(bl, null);
    }

    default public boolean setSelected(boolean bl, IGProp<?> iGProp) {
        if (bl == this.getBool(Atom.SELECTED, false)) {
            return false;
        }
        if (bl) {
            this.setBool(Atom.SELECTED, true, true, iGProp);
        } else {
            this.removeProp2(Atom.SELECTED, iGProp);
        }
        return true;
    }

    default public boolean shouldIgnoreFocusFromUI() {
        return this.getBool(ATOM_IGNORE_UI_FOCUS);
    }

    default public boolean setIgnoreFocusFromUI(boolean bl) {
        return this.setBool(ATOM_IGNORE_UI_FOCUS, bl);
    }

    default public VSField getField(@VSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSField path: " + string);
        }
        return virtualSpace.getField(string);
    }

    default public VSField getFieldNull(@VSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getFieldNull(string) : null;
    }

    default public VSField getField2(@FullVSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSField reference: " + string);
        }
        return virtualSpace.getField2(string);
    }

    default public VSField getFieldNull2(@FullVSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getFieldNull2(string) : null;
    }

    default public VSTable getTable(@VSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSTable path: " + string);
        }
        return virtualSpace.getTable(string);
    }

    default public VSTable getTableNull(@VSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getTableNull(string) : null;
    }

    default public VSTable getTable2(@FullVSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSTable reference: " + string);
        }
        return virtualSpace.getTable2(string);
    }

    default public VSTable getTableNull2(@FullVSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getTableNull2(string) : null;
    }

    default public VSAction getAction(@VSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSAction path: " + string);
        }
        return virtualSpace.getAction(string);
    }

    default public VSAction getActionNull(@VSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getActionNull(string) : null;
    }

    default public VSAction getAction2(@FullVSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSAction reference: " + string);
        }
        return virtualSpace.getAction2(string);
    }

    default public VSAction getActionNull2(@FullVSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getActionNull2(string) : null;
    }

    default public VSGroup getGroup(@VSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSGroup path: " + string);
        }
        return virtualSpace.getGroup(string);
    }

    default public VSGroup getGroupNull(@VSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getGroupNull(string) : null;
    }

    default public VSGroup getGroup2(@FullVSRef String string) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSGroup reference: " + string);
        }
        return virtualSpace.getGroup2(string);
    }

    default public VSGroup getGroupNull2(@FullVSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? virtualSpace.getGroupNull2(string) : null;
    }

    default public <COMP extends IVSComponent> COMP getVSComponent(@VSRef String string, Class<COMP> clazz) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSComponent " + clazz.getName() + " path: " + string);
        }
        return virtualSpace.getVSComponent(string, clazz);
    }

    default public <COMP extends IVSComponent> COMP getVSComponentNull(@VSRef String string, Class<COMP> clazz) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? (COMP)virtualSpace.getVSComponentNull(string, clazz) : null;
    }

    default public <COMP extends IVSComponent> COMP getVSComponent2(@FullVSRef String string, Class<COMP> clazz) throws NotFoundException {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found, VSComponent " + clazz.getName() + " reference: " + string);
        }
        return virtualSpace.getVSComponent2(string, clazz);
    }

    default public <COMP extends IVSComponent> COMP getVSComponentNull2(@FullVSRef String string, Class<COMP> clazz) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        return virtualSpace != null ? (COMP)virtualSpace.getVSComponentNull2(string, clazz) : null;
    }

    default public VirtualSpace getVirtualizedVirtualSpace(@FullVSRef String string) {
        VirtualSpace virtualSpace = this.getVirtualSpace();
        if (virtualSpace == null) {
            throw new NotFoundException("VirtualSpace is not found");
        }
        return virtualSpace.getVirtualizedVirtualSpace(string);
    }

    default public @VSRef String getVSRef() {
        String string = "";
        PropCnr propCnr = (PropCnr)((Object)this);
        while (!(propCnr instanceof VirtualSpace)) {
            if (!(propCnr instanceof IVSComponent)) {
                throw new IllegalStateException("VS Component tree is invalid, not VS component: " + String.valueOf(propCnr));
            }
            string = string.isEmpty() ? propCnr.getPropName() : propCnr.getPropName() + "/" + string;
            if ((propCnr = propCnr.getParent()) == null) {
                throw new IllegalStateException("VS Component tree is invalid, no parent: " + String.valueOf(propCnr));
            }
            if (!propCnr.isPropFile()) continue;
            throw new IllegalStateException("VS Component tree is invalid, top-level component is not VirtualSpace: " + String.valueOf(propCnr));
        }
        return string;
    }

    default public String setVirtualizeSupportFocus() {
        return this.setVirtualizeSupportFocus(null);
    }

    default public String setVirtualizeSupportFocus(IGProp<?> iGProp) {
        IAppSessionGyro iAppSessionGyro = this.getAppSessionGyro();
        if (iAppSessionGyro == null) {
            return "AppSessionGyro cannot be found";
        }
        return iAppSessionGyro.setVirtualizeSupportFocus(this, iGProp);
    }

    @Override
    default public void messageBox(IMessageBoxReply iMessageBoxReply, IMessageBox.Icon icon, KString kString, KString kString2, KString ... kStringArray) {
        IAppSessionGyro iAppSessionGyro = this.getAppSessionGyro();
        if (iAppSessionGyro == null) {
            throw new IllegalStateException("AppSessionGyro not found");
        }
        iAppSessionGyro.messageBox(iMessageBoxReply, icon, kString, kString2, kStringArray);
    }
}

