/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.value;

import com.iizix.prop.Atom;
import com.iizix.prop.NumberProp;
import com.iizix.prop.ui.value.IUIDoubleValueComponent;

public interface IUIDoubleRangeValueComponent
extends IUIDoubleValueComponent {
    default public boolean setRange(double d2, double d3) throws IllegalArgumentException {
        if (d2 > d3) {
            throw new IllegalArgumentException("minValue (" + d2 + ") is larger than maxValue (" + d3 + ")");
        }
        return this.setNumber("min", d2) | this.setNumber("max", d3);
    }

    default public boolean setValueAndRange(double d2, double d3, double d4) throws IllegalArgumentException {
        if (d3 > d4) {
            throw new IllegalArgumentException("minValue (" + d3 + ") is larger than maxValue (" + d4 + ")");
        }
        if (d2 < d3) {
            throw new IllegalArgumentException("value (" + d2 + ") is smaller than minValue (" + d3 + ")");
        }
        if (d2 > d4) {
            throw new IllegalArgumentException("value (" + d2 + ") is larger than maxValue (" + d4 + ")");
        }
        return this.setNumber("min", d3) | this.setNumber("max", d4) | this.setNumber(Atom.VALUE, d2);
    }

    default public boolean setMinimum(double d2) throws IllegalArgumentException {
        double d3 = this.getMaximum();
        if (d2 > d3) {
            throw new IllegalArgumentException("minValue (" + d2 + ") is larger than maxValue (" + d3 + ")");
        }
        return this.setNumber("min", d2);
    }

    default public boolean setMaximum(double d2) throws IllegalArgumentException {
        double d3 = this.getMinimum();
        if (d2 < d3) {
            throw new IllegalArgumentException("maxValue (" + d2 + ") is smaller than minValue (" + d3 + ")");
        }
        return this.setNumber("max", d2);
    }

    default public double getMinimum() {
        NumberProp numberProp = this.getProp("min", NumberProp.class);
        double d2 = this.getMinimumDefault();
        return numberProp != null ? numberProp.getDouble(d2) : d2;
    }

    default public double getMaximum() {
        NumberProp numberProp = this.getProp("max", NumberProp.class);
        double d2 = this.getMaximumDefault();
        return numberProp != null ? numberProp.getDouble(d2) : d2;
    }

    public double getMinimumDefault();

    public double getMaximumDefault();

    @Override
    default public boolean setValue(double d2) throws IllegalArgumentException {
        double d3 = this.getMinimum();
        double d4 = this.getMaximum();
        if (d2 < d3) {
            throw new IllegalArgumentException("value (" + d2 + ") is smaller than minValue (" + d3 + "): " + String.valueOf(this));
        }
        if (d2 > d4) {
            throw new IllegalArgumentException("value (" + d2 + ") is larger than maxValue (" + d4 + "): " + String.valueOf(this));
        }
        return this.setNumber(Atom.VALUE, d2);
    }
}

