/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.map;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.RunMode;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.event.GEvent;
import com.iizix.event.IPostEventProcessing;
import com.iizix.event.PropCnrEvent;
import com.iizix.event.PropValueEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUILabelForTarget;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIContainer;
import com.iizix.prop.ui.map.MapMarkers;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSFieldReference;
import com.iizix.prop.vs.VSRelativeReference;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class UIMap
extends UIContainer
implements IUILabelForTarget {
    private static final String[] a = new String[]{"mapTypeId", "latitude", "longitude", "zoom"};
    private static final Value.Type[] a = new Value.Type[]{Value.Type.Integer, Value.Type.Double, Value.Type.Double, Value.Type.Double};
    private static final Number[] a = new Number[]{1, 0.0, 0.0, 8.0};
    private static final Set<String> a;

    static {
        a = Set.of(a);
    }

    public UIMap() {
    }

    public UIMap(Atom atom) {
        super(atom);
    }

    public UIMap(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return false;
    }

    @Override
    public boolean isEmptyContainerAllowed() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillY() {
        return true;
    }

    @Override
    public boolean canAlignX() {
        return false;
    }

    @Override
    public boolean canAlignY() {
        return false;
    }

    @Override
    protected GProp<?> convertLoadedProp(GProp<?> numberProp) throws PropException {
        if (numberProp.getPropName().equals("zoom") && numberProp instanceof IntProp) {
            int n2 = ((IntProp)((Object)numberProp)).getInt();
            if (n2 <= 0) {
                n2 = 8;
            }
            numberProp = new NumberProp(numberProp.getPropAtom(), n2);
        }
        return numberProp;
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        String string;
        super.onEventSelf(gEvent);
        if (RunMode.isDesignerRunMode() && this.isPropCommunicating()) {
            return;
        }
        GProp<?> gProp = gEvent.getEventTarget();
        if (gProp.getParent() == this && a.contains(string = gProp.getPropName())) {
            IGProp iGProp = null;
            Number number = null;
            switch (gEvent.getEventID()) {
                case 1: {
                    iGProp = ((PropValueEvent)gEvent).getTrigger();
                    number = (Number)gProp.getPropValue();
                    break;
                }
                case 2: {
                    iGProp = ((PropCnrEvent)gEvent).getTrigger();
                    number = (Number)gProp.getPropValue();
                    break;
                }
                case 3: {
                    iGProp = ((PropCnrEvent)gEvent).getTrigger();
                    break;
                }
                default: {
                    return;
                }
            }
            if (number == null) {
                int n2 = a.length;
                while (--n2 >= 0) {
                    if (!string.equals(a[n2])) continue;
                    number = a[n2];
                    break;
                }
            }
            if (iGProp == null) {
                iGProp = this;
            }
            this.a(string, number, (GProp<?>)iGProp);
        }
    }

    private void a(String string, Number number, GProp<?> gProp) {
        VSField vSField;
        VSFieldReference vSFieldReference = this.getProp("v" + string, VSFieldReference.class);
        if (vSFieldReference != null && (vSField = (VSField)vSFieldReference.getVSTarget()) != null && this.enterVSProcessing(vSField)) {
            try {
                try {
                    vSField.setValue(number, true, gProp);
                }
                catch (ValueConversionException valueConversionException) {
                    ILog.SEVERE(this.getClass(), "Map value failed to be set in VS field", "Value = " + String.valueOf(number), "VSField = " + String.valueOf(vSField), valueConversionException);
                    this.exitVSProcessing();
                }
            }
            finally {
                this.exitVSProcessing();
            }
        }
    }

    @Override
    public Value.Type getBestVSFieldValueType(VSRelativeReference<?> vSRelativeReference) {
        String string = vSRelativeReference.getPropName();
        if (string.startsWith("v")) {
            string = string.substring(1);
            int n2 = a.length;
            while (--n2 >= 0) {
                if (!string.equals(a[n2])) continue;
                return a[n2];
            }
        }
        return null;
    }

    @Override
    public void onResolved(VSRelativeReference<?> vSRelativeReference, VSField vSField) {
        this.setVSFieldToComponent(vSField);
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        this.setVSFieldToComponent(vSField);
    }

    @Override
    public void setVSFieldToComponent(VSField vSField) {
        String[] stringArray = a;
        int n2 = a.length;
        int n3 = 0;
        while (n3 < n2) {
            block22: {
                block21: {
                    String string = stringArray[n3];
                    VSFieldReference vSFieldReference = this.getProp("v" + string, VSFieldReference.class);
                    if (vSFieldReference == null || vSFieldReference.getVSTarget() != vSField) break block22;
                    if (!this.enterVSProcessing(vSField)) break block21;
                    try {
                        try {
                            switch (string) {
                                case "mapTypeId": {
                                    Integer n4 = vSField.get_Integer(true);
                                    this.setInt(string, n4 != null ? n4 : 1);
                                    break;
                                }
                                case "zoom": {
                                    Double d2 = vSField.get_Double();
                                    this.setNumber(string, d2 != null ? d2 : 8.0);
                                    break;
                                }
                                case "latitude": 
                                case "longitude": {
                                    Double d3 = vSField.get_Double(true);
                                    this.setNumber(string, d3 != null && !Double.isNaN(d3) ? d3 : 0.0);
                                }
                            }
                        }
                        catch (ValueConversionException valueConversionException) {
                            ILog.SEVERE(this.getClass(), "Map value failed to be set in VS field", "Value = " + String.valueOf(vSField.getRawValue()), "VSField = " + String.valueOf(vSField), valueConversionException);
                            this.exitVSProcessing();
                        }
                    }
                    finally {
                        this.exitVSProcessing();
                    }
                }
                return;
            }
            ++n3;
        }
    }

    @Override
    public Size getApproximateSize() {
        return new Size(200, 200);
    }

    public MapMarkers getFirstMarkersNull() {
        UIComp[] uICompArray = this.getComponents();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UIComp uIComp = uICompArray[n3];
            if (uIComp instanceof MapMarkers) {
                return (MapMarkers)uIComp;
            }
            ++n3;
        }
        return null;
    }

    public MapMarkers getFirstMarkers() throws NotFoundException {
        UIComp[] uICompArray = this.getComponents();
        int n2 = uICompArray.length;
        int n3 = 0;
        while (n3 < n2) {
            UIComp uIComp = uICompArray[n3];
            if (uIComp instanceof MapMarkers) {
                return (MapMarkers)uIComp;
            }
            ++n3;
        }
        throw new NotFoundException("No map markers groups found");
    }

    public MapMarkers getMarkersNull(String string) {
        return this.getCompsCnr().getProp(string, MapMarkers.class);
    }

    public MapMarkers getMarkers(String string) throws NotFoundException {
        MapMarkers mapMarkers = this.getCompsCnr().getProp(string, MapMarkers.class);
        if (mapMarkers != null) {
            return mapMarkers;
        }
        throw new NotFoundException("Map markers group '" + string + "' not found");
    }
}

