/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.chart.series;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.NumberProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.ui.chart.IChartContainer;
import com.iizix.prop.ui.chart.series.Bubble;
import com.iizix.prop.ui.chart.series.GSeriesValue;
import com.iizix.prop.ui.chart.series.NoValue;
import com.iizix.prop.ui.chart.series.OHLC;
import com.iizix.prop.ui.chart.series.SeriesType;
import com.iizix.prop.ui.chart.series.Simple;
import com.iizix.prop.ui.chart.series.XY;
import java.util.ArrayList;

public class SeriesValue
extends PropCnr
implements IChartContainer {
    public SeriesValue() {
    }

    public SeriesValue(Atom atom) {
        super(atom);
    }

    public SeriesValue(Atom atom, GSeriesValue gSeriesValue) {
        super(atom);
        gSeriesValue.a(this);
    }

    public SeriesType getSeriesType() {
        GProp<?>[] gPropArray = this.getProps();
        if (gPropArray.length == 0) {
            return SeriesType.NO_VALUE;
        }
        boolean bl = false;
        GProp<?>[] gPropArray2 = gPropArray;
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block28: {
                GProp<?> gProp = gPropArray2[n3];
                if (!(gProp instanceof NumberProp)) break block28;
                switch (gProp.getPropName()) {
                    case "v": {
                        return SeriesType.SIMPLE;
                    }
                    case "x": 
                    case "y": {
                        bl = true;
                        break;
                    }
                    case "s": {
                        return SeriesType.BUBBLE;
                    }
                    case "c": 
                    case "h": 
                    case "l": 
                    case "m": 
                    case "o": {
                        return SeriesType.OHLC;
                    }
                }
            }
            ++n3;
        }
        return bl ? SeriesType.X_Y : SeriesType.NO_VALUE;
    }

    @Override
    public final IChartContainer.Type getContainerType() {
        return IChartContainer.Type.SERIES;
    }

    @Override
    public SeriesValue clone() {
        try {
            SeriesValue seriesValue = (SeriesValue)super.clone();
            return seriesValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public GSeriesValue getValue() {
        GProp<?>[] gPropArray = this.getProps();
        if (gPropArray.length == 0) {
            return NoValue.NO_VALUE;
        }
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        double d4 = Double.NaN;
        double d5 = Double.NaN;
        double d6 = Double.NaN;
        double d7 = Double.NaN;
        double d8 = Double.NaN;
        double d9 = Double.NaN;
        GProp<?>[] gPropArray2 = gPropArray;
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block36: {
                GProp<?> gProp = gPropArray2[n3];
                if (!(gProp instanceof NumberProp)) break block36;
                double d10 = ((NumberProp)gProp).getDouble(Double.NaN);
                switch (gProp.getPropName()) {
                    case "v": {
                        return Double.isNaN(d10) ? NoValue.NO_VALUE : new Simple(d10);
                    }
                    case "x": {
                        d2 = d10;
                        break;
                    }
                    case "y": {
                        d3 = d10;
                        break;
                    }
                    case "s": {
                        d4 = d10;
                        break;
                    }
                    case "o": {
                        d5 = d10;
                        break;
                    }
                    case "h": {
                        d6 = d10;
                        break;
                    }
                    case "m": {
                        d7 = d10;
                        break;
                    }
                    case "l": {
                        d8 = d10;
                        break;
                    }
                    case "c": {
                        d9 = d10;
                    }
                }
            }
            ++n3;
        }
        if (!Double.isNaN(d4)) {
            return new Bubble(d2, d3, d4);
        }
        if (!Double.isNaN(d2) || !Double.isNaN(d3)) {
            return new XY(d2, d3);
        }
        if (!(Double.isNaN(d5) && Double.isNaN(d6) && Double.isNaN(d7) && Double.isNaN(d8) && Double.isNaN(d9))) {
            return new OHLC(d5, d6, d7, d8, d9);
        }
        return NoValue.NO_VALUE;
    }

    public void setValue(GSeriesValue gSeriesValue) {
        try {
            this.removeAllProps();
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed removeAllProps", propException);
            throw new InternalError("Should'nt be", propException);
        }
        gSeriesValue.a(this);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        NumberProp numberProp = this.getProp("v", NumberProp.class);
        NumberProp numberProp2 = this.getProp("x", NumberProp.class);
        NumberProp numberProp3 = this.getProp("y", NumberProp.class);
        NumberProp numberProp4 = this.getProp("s", NumberProp.class);
        NumberProp numberProp5 = this.getProp("o", NumberProp.class);
        NumberProp numberProp6 = this.getProp("h", NumberProp.class);
        NumberProp numberProp7 = this.getProp("m", NumberProp.class);
        NumberProp numberProp8 = this.getProp("l", NumberProp.class);
        NumberProp numberProp9 = this.getProp("c", NumberProp.class);
        String string = null;
        ArrayList<NumberProp> arrayList = null;
        if (numberProp != null) {
            if (numberProp2 != null || numberProp3 != null || numberProp4 != null || numberProp5 != null || numberProp7 != null || numberProp8 != null || numberProp9 != null) {
                string = "When Value is specified, this value cannot be specified";
                arrayList = new ArrayList<NumberProp>();
                arrayList.add(numberProp2);
                arrayList.add(numberProp3);
                arrayList.add(numberProp4);
                arrayList.add(numberProp5);
                arrayList.add(numberProp6);
                arrayList.add(numberProp7);
                arrayList.add(numberProp8);
                arrayList.add(numberProp9);
            }
        } else if (!(numberProp2 == null && numberProp3 == null && numberProp4 == null || numberProp5 == null && numberProp6 == null && numberProp7 == null && numberProp8 == null && numberProp9 == null)) {
            string = numberProp4 != null ? "When Bubble value is defined, this value cannot be specified" : "When X/Y value is defined, this value cannot be specified";
            arrayList = new ArrayList();
            arrayList.add(numberProp5);
            arrayList.add(numberProp6);
            arrayList.add(numberProp7);
            arrayList.add(numberProp8);
            arrayList.add(numberProp9);
        }
        if (arrayList != null) {
            for (NumberProp numberProp10 : arrayList) {
                if (numberProp10 == null) continue;
                propVerification.add(new PropVerificationError("spec", PropVerificationError.Severity.WARNING, "Value", numberProp10, string, new String[0]));
            }
        }
        return true;
    }
}

