/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.Value;
import com.iizix.api.ui.UISelectionEvent;
import com.iizix.event.GEvent;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.ClassReference;
import com.iizix.prop.GProp;
import com.iizix.prop.MethodReference;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.IUIFocusComp;
import com.iizix.prop.ui.IUILabelForTarget;
import com.iizix.prop.ui.IUIRadioComponent;
import com.iizix.prop.ui.IUISelectionListener;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.text.IUIHTMLTextComponent;
import com.iizix.prop.vs.VSField;
import java.lang.reflect.Method;
import java.util.List;

public class UIRadioButton
extends UIComp
implements IUIContextMenuOwner,
IUIFocusComp,
IUILabelForTarget,
IUIRadioComponent,
IUIHTMLTextComponent {
    private Method f;
    private GenericListener<IUISelectionListener> a;

    public UIRadioButton() {
    }

    public UIRadioButton(Atom atom) {
        super(atom);
    }

    public UIRadioButton(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public UIRadioButton clone() {
        UIRadioButton uIRadioButton = (UIRadioButton)super.clone();
        uIRadioButton.a = null;
        return uIRadioButton;
    }

    @Override
    public Atom getSelectionPropAtom() {
        return SELECTED_ATOM;
    }

    @Override
    public synchronized GenericListener<IUISelectionListener> getSelectionListenerHandler(boolean bl) {
        if (this.a == null && bl) {
            this.a = new GenericListener<IUISelectionListener>(IUISelectionListener.class);
        }
        return this.a;
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return true;
    }

    @Override
    public boolean canFillX() {
        return false;
    }

    @Override
    public boolean canFillY() {
        return false;
    }

    @Override
    public void onValueChanged(VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        UIRadioButton.onValueChanged(this, vSField, value, iPostEventProcessing);
    }

    @Override
    protected void onSelectionChanged(GEvent gEvent) {
        UIRadioButton.setComponentRadioSelectionToVSField(this);
    }

    public static int setComponentRadioSelectionToVSField(UIComp uIComp) {
        VSField vSField = uIComp.getVSField();
        if (vSField != null && ((IUIRadioComponent)((Object)uIComp)).isSelected() && uIComp.enterVSProcessing(vSField)) {
            try {
                Value value = uIComp.getValue("selValue");
                if (value == null) {
                    ILog.SEVERE(uIComp.getClass(), "Radio component does not have the Selection value defined", (Object)("Component " + uIComp.getReferencePropName() + ": " + String.valueOf(uIComp)));
                    return 0;
                }
                vSField.setValue(value, true, uIComp);
                uIComp.setVSFieldMessageToComponent(vSField, true);
                return 1;
            }
            catch (ValueConversionException valueConversionException) {
                uIComp.setErrorMessage(valueConversionException);
                return -1;
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
        return 0;
    }

    public static void onValueChanged(UIComp uIComp, VSField vSField, Value value, IPostEventProcessing iPostEventProcessing) {
        if (vSField == uIComp.getVSField() && uIComp.enterVSProcessing(vSField)) {
            try {
                boolean bl;
                Value value2 = uIComp.getValue("selValue");
                if (value2 != null && vSField.convertEqualsValue(uIComp, value2) >= 0) {
                    bl = true;
                } else {
                    bl = uIComp.getBool("selNoMatch");
                    if (bl) {
                        iPostEventProcessing.addPostProcessor(gEvent -> {
                            UIComp uIComp2 = ((IUIRadioComponent)((Object)uIComp)).getSelectedRadioComponent();
                            if (uIComp2 == null) {
                                ((IUIRadioComponent)((Object)uIComp)).setSelection(true);
                            }
                        });
                        return;
                    }
                }
                ((IUIRadioComponent)((Object)uIComp)).setSelection(bl);
            }
            finally {
                uIComp.exitVSProcessing();
            }
        }
    }

    @Override
    protected void onPrepare(ClassReference classReference, List<Throwable> list) {
        super.onPrepare(classReference, list);
        MethodReference methodReference = this.getProp("$OnUISelection", MethodReference.class);
        if (methodReference != null) {
            this.f = methodReference.lookupMethod(classReference, list, UISelectionEvent.class);
        }
    }

    @Override
    public Method getOnUISelectionMethod() {
        return this.f;
    }

    @Override
    public Size getApproximateSize() {
        return new Size(24, 24);
    }
}

