/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.push.VAPIDKeys;

public class PushProps
extends PropCnr {
    public static final String FILE_NAME = ".iiziPush";
    public static final Atom ATOM = Atom.get("$push");
    public static final String TTL = "TTL";
    public static final String VAPID_PRIVATE_KEY = "VPrivKey";
    public static final String VAPID_PUBLIC_KEY = "VPubKey";
    public static final String APPLE_APP_ID = "appleID";
    public static final String DEV_APNS = "devAPNs";
    public static final String PROD_APNS = "prodAPNs";

    public PushProps() {
    }

    public PushProps(Atom atom) {
        super(atom);
    }

    @Override
    public PushProps clone() {
        try {
            return (PushProps)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getPublicVAPIDKey() {
        return this.getString(VAPID_PUBLIC_KEY);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        String string;
        if (!super.verify(propVerification)) {
            return false;
        }
        StringProp stringProp = this.getProp(VAPID_PRIVATE_KEY, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, VAPID_PRIVATE_KEY, PropVerificationError.Severity.WARNING, "VAPID Private Key", "VAPID Private Key must be specified", new String[0]));
        } else {
            string = stringProp.getString("");
            if (string.isEmpty()) {
                propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "VAPID Private Key", stringProp, "VAPID Private Key cannot be an empty string", new String[0]));
            } else if ((string = VAPIDKeys.validatePrivateKey(string)) != null) {
                propVerification.add(new PropVerificationError("err", PropVerificationError.Severity.ERROR, "VAPID Private Key", stringProp, "VAPID Private Key is invalid: " + string, new String[0]));
            }
        }
        stringProp = this.getProp(VAPID_PUBLIC_KEY, StringProp.class);
        if (stringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, VAPID_PUBLIC_KEY, PropVerificationError.Severity.WARNING, "VAPID Public Key", "VAPID Public Key must be specified", new String[0]));
        } else {
            string = stringProp.getString("");
            if (string.isEmpty()) {
                propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "VAPID Public Key", stringProp, "VAPID Public Key cannot be an empty string", new String[0]));
            } else if ((string = VAPIDKeys.validatePublicKey(string)) != null) {
                propVerification.add(new PropVerificationError("err", PropVerificationError.Severity.ERROR, "VAPID Public Key", stringProp, "VAPID Public Key is invalid: " + string, new String[0]));
            }
        }
        return true;
    }
}

