/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.GColor;
import java.awt.BasicStroke;
import java.util.StringTokenizer;

public class GStroke
implements Cloneable {
    public static final GStroke DEFAULT = new GStroke(Cap.BUTT, Join.MITER, 4.0f, 1.0f, Style.SOLID, new GColor(0));
    public final Cap cap;
    public final Join join;
    public final float miterLimit;
    public final Style style;
    public final GColor color;
    public final float width;

    public GStroke(Cap cap, Join join, float f2, float f3, Style style, GColor gColor) {
        if (cap == null) {
            throw new NullPointerException("cap is null");
        }
        if (join == null) {
            throw new NullPointerException("join is null");
        }
        if (style == null) {
            throw new NullPointerException("style is null");
        }
        if (gColor == null) {
            throw new NullPointerException("color is null");
        }
        if (join != Join.MITER) {
            f2 = 0.0f;
        } else if ((double)f2 < 1.0) {
            throw new IllegalArgumentException("miterLimit must be at least 1");
        }
        if ((double)f3 <= 0.0) {
            throw new IllegalArgumentException("width must be greater than zero");
        }
        this.cap = cap;
        this.join = join;
        this.miterLimit = f2;
        this.style = style;
        this.width = f3;
        this.color = gColor;
    }

    GStroke(String string) throws IllegalArgumentException, NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.cap = Cap.valueOf(stringTokenizer.nextToken());
        this.join = Join.valueOf(stringTokenizer.nextToken());
        this.miterLimit = Float.parseFloat(stringTokenizer.nextToken());
        this.width = Float.parseFloat(stringTokenizer.nextToken());
        this.style = Style.valueOf(stringTokenizer.nextToken());
        this.color = GColor.createGColor(stringTokenizer.nextToken());
    }

    GStroke(ReadTransaction readTransaction) {
        int n2 = readTransaction.readByte();
        this.cap = Cap.values()[n2 & 3];
        this.join = Join.values()[n2 >> 2 & 3];
        this.width = Float.parseFloat(readTransaction.readString());
        this.style = Style.values()[n2 >> 4];
        this.color = GColor.from(readTransaction);
        this.miterLimit = this.join == Join.MITER ? Float.parseFloat(readTransaction.readString()) : 0.0f;
    }

    public BasicStroke getStroke() {
        return new BasicStroke(this.width, this.cap.ordinal(), this.join.ordinal(), this.miterLimit, this.style.a, 0.0f);
    }

    void a(SendTransaction sendTransaction) {
        sendTransaction.appendByte(this.cap.ordinal() | this.join.ordinal() << 2 | this.style.ordinal() << 4);
        long l2 = (long)this.width;
        sendTransaction.appendString(this.width == (float)l2 ? Long.toString(l2) : Float.toString(this.width));
        this.color.appendColor(sendTransaction);
        if (this.join == Join.MITER) {
            l2 = (long)this.miterLimit;
            sendTransaction.appendString(this.miterLimit == (float)l2 ? Long.toString(l2) : Float.toString(this.miterLimit));
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GStroke && this.equals((GStroke)object);
    }

    public boolean equals(GStroke gStroke) {
        if (gStroke != null && this.cap == gStroke.cap && this.join == gStroke.join && this.style == gStroke.style && this.width == gStroke.width) {
            if (this.join == Join.MITER && this.miterLimit != gStroke.miterLimit) {
                return false;
            }
            return this.color.equals(gStroke.color);
        }
        return false;
    }

    public String getString() {
        return this.a();
    }

    String a() {
        return this.cap.toString() + "," + String.valueOf((Object)this.join) + "," + this.miterLimit + "," + this.width + "," + String.valueOf((Object)this.style) + "," + this.color.getString();
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.a() + "]";
    }

    public static enum Cap {
        BUTT,
        ROUND,
        SQUARE;

    }

    public static enum Join {
        MITER,
        ROUND,
        BEVEL;

    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static enum Style {
        NONE(new float[0]),
        SOLID(new float[0]),
        SHORT_DASH(4.0f, 1.0f),
        SHORT_DOT(1.0f, 1.0f),
        SHORT_DASH_DOT(4.0f, 1.0f, 1.0f, 1.0f),
        SHORT_DASH_DOT_DOT(4.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f),
        DOT(1.0f, 3.0f),
        DASH(4.0f, 3.0f),
        LONG_DASH(8.0f, 3.0f),
        DASH_DOT(4.0f, 3.0f, 1.0f, 3.0f),
        LONG_DASH_DOT(8.0f, 3.0f, 1.0f, 3.0f),
        LONG_DASH_DOT_DOT(8.0f, 3.0f, 1.0f, 3.0f, 1.0f, 3.0f);

        private final float[] a;

        private Style(float ... fArray) {
            this.a = (float[])(fArray.length > 0 ? fArray : null);
        }
    }
}

