/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessGateway;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessGatewayProvider;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessRequester;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessRequesterImpl;
import com.tabnine.eclipse.shared.api.binary.BinaryRun;
import com.tabnine.eclipse.shared.api.binary.ParsedBinaryIO;
import com.tabnine.eclipse.shared.api.binary.VoidBinaryProcessRequester;
import com.tabnine.eclipse.shared.api.services.ConfigService;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BinaryProcessRequesterProvider {
    static Logger logger = LogManager.getLogger(BinaryProcessRequesterProvider.class);
    private final BinaryRun binaryRun;
    private final BinaryProcessGatewayProvider binaryProcessGatewayProvider;
    private final int timeoutsThresholdMillis;
    private Long firstTimeoutTimestamp = null;
    private BinaryProcessRequester binaryProcessRequester;
    private Future<?> binaryInit;
    private long lastRestartTimestamp = 0L;
    private int restartAttemptCounter = 0;
    private ExecutorService executor = Executors.newFixedThreadPool(10);
    public static final int SLEEP_TIME_BETWEEN_FAILURES = 1000;

    private BinaryProcessRequesterProvider(BinaryRun binaryRun, BinaryProcessGatewayProvider binaryProcessGatewayProvider, int n2) {
        this.binaryRun = binaryRun;
        this.binaryProcessGatewayProvider = binaryProcessGatewayProvider;
        this.timeoutsThresholdMillis = n2;
    }

    public static BinaryProcessRequesterProvider create(BinaryRun object, BinaryProcessGatewayProvider binaryProcessGatewayProvider, int n2) {
        object = new BinaryProcessRequesterProvider((BinaryRun)object, binaryProcessGatewayProvider, n2);
        ((BinaryProcessRequesterProvider)object).createNew();
        return object;
    }

    public BinaryProcessRequester get() {
        if (this.isStarting()) {
            logger.info("Can't get completions because Tabnine process is not started yet.");
            return VoidBinaryProcessRequester.instance();
        }
        return this.binaryProcessRequester;
    }

    public void onSuccessfulRequest() {
        this.firstTimeoutTimestamp = null;
        this.restartAttemptCounter = 0;
    }

    public synchronized void onDead(Throwable throwable) {
        long l2 = System.currentTimeMillis() - this.lastRestartTimestamp;
        if (this.isStarting() || l2 < (long)BinaryProcessRequesterProvider.exponentialBackoff(this.restartAttemptCounter)) {
            return;
        }
        this.firstTimeoutTimestamp = null;
        ++this.restartAttemptCounter;
        this.lastRestartTimestamp = System.currentTimeMillis();
        logger.warn("Tabnine is in invalid state, it is being restarted.", (Throwable)new RuntimeException("restartAttemptCounter: " + this.restartAttemptCounter + "\n" + throwable.getMessage()));
        this.createNew();
    }

    public void onTimeout() {
        logger.warn("TabNine's response timed out.");
        long l2 = System.currentTimeMillis();
        if (this.firstTimeoutTimestamp == null) {
            this.firstTimeoutTimestamp = l2;
        }
        if (l2 - this.firstTimeoutTimestamp >= (long)this.timeoutsThresholdMillis) {
            this.onDead(new Exception("Timeout"));
        }
    }

    private boolean isStarting() {
        return this.binaryInit == null || !this.binaryInit.isDone();
    }

    private void createNew() {
        if (this.binaryProcessRequester != null) {
            this.binaryProcessRequester.destroy();
        }
        BinaryProcessGateway binaryProcessGateway = this.binaryProcessGatewayProvider.generateBinaryProcessGateway();
        this.initProcess(binaryProcessGateway);
        this.binaryProcessRequester = new BinaryProcessRequesterImpl(new ParsedBinaryIO(new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create(), binaryProcessGateway));
    }

    private synchronized void initProcess(BinaryProcessGateway binaryProcessGateway) {
        if (this.binaryInit != null) {
            this.binaryInit.cancel(false);
        }
        this.binaryInit = this.executor.submit(() -> {
            try {
                if (!ConfigService.CONFIG.allowBinaryRun()) {
                    return;
                }
                binaryProcessGateway.init(this.binaryRun.generateRunCommand(Collections.singletonMap("ide-restart-counter", this.restartAttemptCounter)));
                return;
            }
            catch (Exception exception) {
                logger.warn("Error starting TabNine.", (Throwable)exception);
                return;
            }
        });
    }

    public static int exponentialBackoff(int n2) {
        return 1000 * (int)Math.pow(2.0, Math.min(n2, 30));
    }
}

