/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.function.Supplier;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.io.Closer;

@Internal
public class IncomingHttpEntity
implements HttpEntity {
    private final InputStream content;
    private final long len;
    private final HttpMessage message;

    public IncomingHttpEntity(InputStream content, long len, HttpMessage message) {
        this.content = content;
        this.len = len;
        this.message = message;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return this.len == -1L;
    }

    @Override
    public long getContentLength() {
        return this.len >= 0L ? this.len : -1L;
    }

    @Override
    public String getContentType() {
        Header h = this.message.getFirstHeader("Content-Type");
        return h != null ? h.getValue() : null;
    }

    @Override
    public String getContentEncoding() {
        Header h = this.message.getFirstHeader("Content-Encoding");
        return h != null ? h.getValue() : null;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.content;
    }

    @Override
    public boolean isStreaming() {
        return this.content != null;
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        AbstractHttpEntity.writeTo(this, outStream);
    }

    @Override
    public Supplier<List<? extends Header>> getTrailers() {
        return null;
    }

    @Override
    public Set<String> getTrailerNames() {
        return Collections.emptySet();
    }

    @Override
    public void close() throws IOException {
        Closer.close(this.content);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append("Content-Type: ");
        sb.append(this.getContentType());
        sb.append(',');
        sb.append("Content-Encoding: ");
        sb.append(this.getContentEncoding());
        sb.append(',');
        long len = this.getContentLength();
        if (len >= 0L) {
            sb.append("Content-Length: ");
            sb.append(len);
            sb.append(',');
        }
        sb.append("Chunked: ");
        sb.append(this.isChunked());
        sb.append(']');
        return sb.toString();
    }
}

