/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAmountValue;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;

public class PeriodValue
extends TermporalAmountValue<Period> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.Period;
    }

    public static Period fromEpochMillis(long l2) {
        long l3 = l2 / 86400000L;
        return Period.ofDays((int)l3);
    }

    @Override
    public Class<Period> getValueClass() {
        return Period.class;
    }

    @Override
    public String getDescription() {
        return "Date-based amount of time in the ISO-8601 calendar system, such as 2 years, 3 months and 4 days";
    }

    @Override
    public Period createDefault() {
        return Period.ZERO;
    }

    @Override
    public Period parse(String string) throws ParseException, IllegalAccessException, Exception {
        try {
            return Period.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public Period convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Period) {
            return (Period)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            return PeriodValue.fromEpochMillis(l3);
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            int n2 = duration.isSet(DatatypeConstants.YEARS) ? duration.getYears() : 0;
            int n3 = duration.isSet(DatatypeConstants.MONTHS) ? duration.getMonths() : 0;
            int n4 = duration.isSet(DatatypeConstants.DAYS) ? duration.getDays() : 0;
            return Period.of(n2, n3, n4);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return PeriodValue.fromEpochMillis(l2);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Period.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(Period period, LocaleInfo localeInfo) {
        try {
            LocalDate localDate = LocalDate.ofEpochDay(0L);
            localDate = (LocalDate)period.addTo(localDate);
            return Math.multiplyExact(localDate.toEpochDay(), 86400000L);
        }
        catch (ArithmeticException arithmeticException) {
            return Long.MIN_VALUE;
        }
    }
}

