/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class OffsetDateTimeValue
extends TermporalAccessorValue<OffsetDateTime> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.OffsetDateTime;
    }

    @Override
    public Class<OffsetDateTime> getValueClass() {
        return OffsetDateTime.class;
    }

    @Override
    public String getDescription() {
        return "Date-time with an offset from UTC/Greenwich in the ISO-8601 calendar system, such as 2007-12-03T10:15:30+01:00";
    }

    @Override
    public OffsetDateTime createDefault() {
        return OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    }

    @Override
    public OffsetDateTime parse(String string) throws ParseException, Exception {
        try {
            return OffsetDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public OffsetDateTime parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return OffsetDateTime.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public OffsetDateTime convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof OffsetDateTime) {
            return (OffsetDateTime)object;
        }
        if (object instanceof Number) {
            Instant instant = Instant.ofEpochMilli(((Number)object).longValue());
            return OffsetDateTime.ofInstant(instant, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return OffsetDateTime.of(localDateTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            return zonedDateTime.toOffsetDateTime();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            LocalDateTime localDateTime = timestamp.toLocalDateTime();
            return OffsetDateTime.of(localDateTime, LocaleInfo.getNonNull(localeInfo, false).getZoneOffset());
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            Instant instant = Instant.ofEpochMilli(date.getTime());
            return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            return ((GregorianCalendar)object).toZonedDateTime().toOffsetDateTime();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            Instant instant = Instant.ofEpochMilli(l2);
            return OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return OffsetDateTime.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(OffsetDateTime offsetDateTime, LocaleInfo localeInfo) {
        return offsetDateTime.toInstant().toEpochMilli();
    }
}

