/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.NumberValue;
import java.text.ParseException;

public class LongValue
extends NumberValue<Long> {
    private static final Long a = 0L;

    @Override
    public final Value.Type getValueType() {
        return Value.Type.Long;
    }

    @Override
    public Class<Long> getValueClass() {
        return Long.class;
    }

    @Override
    public String getDescription() {
        return "Long value (64 bit)";
    }

    @Override
    public Long createDefault() {
        return a;
    }

    @Override
    public Long parse(String string) throws NumberFormatException {
        return Long.valueOf(string);
    }

    @Override
    public Long convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            double d2 = number.doubleValue();
            if (d2 > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
                throw new ArithmeticException("Value out of Long range: " + d2);
            }
            return number.longValue();
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return l2;
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }
}

