/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util;

import com.iizix.Utilities;
import com.iizix.util.FileChangedChecker;
import com.iizix.util.IJarFile;
import com.iizix.util.xjar.Handler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XJarFile
extends JarFile
implements IJarFile {
    private static final HashMap<File, com.iizix.util.a> a = new HashMap();
    private final HashMap<String, JarEntry> b;
    private final HashMap<String, JarEntry> c;
    private final HashMap<String, byte[]> d;
    private final boolean a;
    private final boolean b;
    private final FileChangedChecker a;
    private final Manifest a;
    private final File a;
    private final String a;
    private final Handler a;
    private boolean c;
    private URL a;

    static URL a(String object, String string, URLStreamHandler uRLStreamHandler) throws MalformedURLException, URISyntaxException {
        if (string != null) {
            object = (String)object + Utilities.encodeAnyPath(string);
        }
        return URL.of(new URI((String)object), uRLStreamHandler);
    }

    public static void clearLoadedFilesList() {
        a.clear();
    }

    public static XJarFile getJarFile(String string) throws IOException {
        return XJarFile.getJarFile(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XJarFile getJarFile(File file) throws IOException {
        if (!(file = Utilities.getCanonicalFile(file)).exists()) {
            throw new FileNotFoundException(file.getPath() + " doesn't exist");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getPath() + " is not a file");
        }
        if (!file.canRead()) {
            throw new IOException(file.getPath() + " is not readable");
        }
        com.iizix.util.a a2 = null;
        boolean bl = false;
        Object object = a;
        synchronized (object) {
            a2 = a.get(file);
            if (a2 == null) {
                a2 = new com.iizix.util.a();
                a2.a = true;
                bl = true;
                a.put(file, a2);
            }
        }
        object = null;
        com.iizix.util.a a3 = a2;
        synchronized (a3) {
            HashMap<File, com.iizix.util.a> hashMap;
            Object object2;
            if (!bl) {
                Throwable throwable;
                if (a2.a) {
                    try {
                        a2.wait();
                    }
                    catch (Exception exception) {
                        throw new IOException("Wait for load interrupted", exception);
                    }
                }
                if ((throwable = a2.a) != null) {
                    if (!(throwable instanceof IOException)) throw new IOException("Fatal error loading file " + file.getPath() + ": " + String.valueOf(throwable), throwable);
                    throw new IOException(throwable.getMessage(), throwable);
                }
                if (a2.a != null && (object = (XJarFile)((Reference)((Object)a2.a)).get()) != null && !((XJarFile)object).hasChanged()) {
                    return object;
                }
                a2.a = null;
            }
            try {
                a2.a = true;
                object = new XJarFile(file, true, false, true);
                a2.a = new WeakReference<Object>(object);
                object2 = object;
                a2.a = false;
                a2.notifyAll();
                if (a2.a == null) return object2;
                hashMap = a;
            }
            catch (IOException iOException) {
                try {
                    a2.a = iOException;
                    throw iOException;
                    catch (Error error) {
                        a2.a = error;
                        throw error;
                    }
                }
                catch (Throwable throwable) {
                    a2.a = false;
                    a2.notifyAll();
                    if (a2.a == null) throw throwable;
                    HashMap<File, com.iizix.util.a> hashMap2 = a;
                    synchronized (hashMap2) {
                        a.remove(file);
                        throw throwable;
                    }
                }
            }
            synchronized (hashMap) {
                a.remove(file);
            }
            return object2;
        }
    }

    public XJarFile(String string) throws IOException {
        this(new File(string), true, false, true);
    }

    public XJarFile(File file) throws IOException {
        this(file, true, false, true);
    }

    public XJarFile(String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this(new File(string), bl, bl2, bl3);
    }

    public XJarFile(File file, boolean bl, boolean bl2, boolean bl3) throws IOException {
        file = Utilities.getCanonicalFile(file);
        super(file, bl3);
        this.b = new HashMap();
        this.c = new HashMap();
        this.d = new HashMap();
        this.a = file;
        this.a = "xjar:file:" + file.toURI().toURL().getPath() + "!/";
        this.a = new Handler(this);
        this.a = new FileChangedChecker(file);
        this.a = bl2;
        this.b = bl;
        try {
            if (bl2 || bl) {
                Enumeration<JarEntry> enumeration = super.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string = jarEntry.getName();
                    this.b.put(string, jarEntry);
                    if (bl2) {
                        string = string.toUpperCase();
                        this.c.put(string, jarEntry);
                    }
                    if (jarEntry.isDirectory()) continue;
                    try {
                        Throwable throwable = null;
                        Object var9_11 = null;
                        try (InputStream inputStream = super.getInputStream(jarEntry);){
                            long l2 = jarEntry.getSize();
                            if (l2 > Integer.MAX_VALUE || l2 < 0L) {
                                throw new IOException(this.getName() + "!" + jarEntry.getName() + ": size invalid: " + l2);
                            }
                            int n2 = (int)l2;
                            byte[] byArray = new byte[n2];
                            int n3 = 0;
                            n3 = 0;
                            while (n3 < n2) {
                                int n4 = inputStream.read(byArray, n3, n2 - n3);
                                if (n4 < 0) {
                                    throw new IOException("Error reading Zip entry " + jarEntry.getName() + " from " + this.getName());
                                }
                                n3 += n4;
                            }
                            if (n3 != n2) {
                                throw new IOException("Error reading Zip entry " + jarEntry.getName() + " from " + this.getName() + ": size " + n2 + " but only read " + n3);
                            }
                            this.d.put(string, byArray);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        throw new IOException(Utilities.getStackTrace(throwable), throwable);
                    }
                }
            }
            this.a = super.getManifest();
        }
        finally {
            if (bl) {
                this.close();
            }
        }
    }

    @Override
    public long lastModified() {
        return this.a.lastModified();
    }

    @Override
    public File getJarFile() {
        return this.a;
    }

    @Override
    public Handler getHandler() {
        return this.a;
    }

    @Override
    public URL getURL() {
        if (this.a == null) {
            try {
                this.a = XJarFile.a(this.a, null, this.a);
            }
            catch (MalformedURLException | URISyntaxException exception) {
                throw new InternalError("Shouldn't be", exception);
            }
        }
        return this.a;
    }

    @Override
    public URL getURL(ZipEntry zipEntry) {
        return this.getURL(zipEntry.getName());
    }

    @Override
    public URL getURL(String string) {
        try {
            return XJarFile.a(this.a, string, this.a);
        }
        catch (MalformedURLException | URISyntaxException exception) {
            throw new InternalError("Shouldn't be", exception);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.a.hasChanged();
    }

    @Override
    public Enumeration<JarEntry> entries() {
        if (!this.b) {
            return super.entries();
        }
        return new a();
    }

    @Override
    public Stream<JarEntry> stream() {
        if (!this.b) {
            return super.stream();
        }
        return StreamSupport.stream(Spliterators.spliterator(new a(), (long)this.b.size(), 1297), false);
    }

    @Override
    public JarEntry[] getJarEntries() {
        return this.b.values().toArray(new JarEntry[this.b.size()]);
    }

    @Override
    public synchronized InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        if (!this.b) {
            return super.getInputStream(zipEntry);
        }
        String string = this.a ? zipEntry.getName().toUpperCase().replace('\\', '/') : zipEntry.getName();
        byte[] byArray = this.d.get(string);
        if (byArray == null) {
            throw new FileNotFoundException("Jar entry " + zipEntry.getName() + " is not found!");
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public JarEntry getJarEntry(String string) {
        JarEntry jarEntry;
        String string2;
        String string3 = string2 = this.a ? string.toUpperCase().replace('\\', '/') : string;
        if (this.b) {
            jarEntry = this.a ? this.c.get(string2) : this.b.get(string2);
        } else {
            jarEntry = super.getJarEntry(string);
            if (jarEntry == null && this.a) {
                jarEntry = this.c.get(string2);
            }
        }
        return jarEntry;
    }

    @Override
    public ZipEntry getEntry(String string) {
        ZipEntry zipEntry;
        String string2;
        String string3 = string2 = this.a ? string.toUpperCase().replace('\\', '/') : string;
        if (this.b) {
            zipEntry = this.a ? (ZipEntry)this.c.get(string2) : (ZipEntry)this.b.get(string2);
        } else {
            zipEntry = super.getEntry(string);
            if (zipEntry == null && this.a) {
                zipEntry = this.c.get(string2);
            }
        }
        return zipEntry;
    }

    @Override
    public int size() {
        return this.b ? this.b.size() : super.size();
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.b ? this.a : super.getManifest();
    }

    @Override
    public byte[] getEntryData(String string) {
        return this.getEntryData(this.getEntry(string));
    }

    @Override
    public byte[] getEntryData(ZipEntry zipEntry) {
        if (zipEntry == null || !this.b) {
            return null;
        }
        String string = this.a ? zipEntry.getName().toUpperCase().replace('\\', '/') : zipEntry.getName();
        return this.d.get(string);
    }

    @Override
    public void close() throws IOException {
        if (this.c) {
            return;
        }
        this.c = true;
        try {
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class a
    implements Enumeration<JarEntry>,
    Iterator<JarEntry> {
        private final Iterator<JarEntry> a;

        private a() {
            this.a = XJarFile.this.b.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.a.hasNext();
        }

        @Override
        public boolean hasMoreElements() {
            return this.a.hasNext();
        }

        public JarEntry a() {
            return this.a.next();
        }

        public JarEntry b() {
            return this.a.next();
        }

        @Override
        public /* synthetic */ Object next() {
            return this.a();
        }

        @Override
        public /* synthetic */ Object nextElement() {
            return this.b();
        }
    }
}

