/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn.file;

import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.NSSException;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResourceType;
import com.iizix.urn.file.FileURN;
import com.iizix.urn.file.IFileURNProvider;
import java.util.List;

public final class FileURNFactory
implements IFileURNProvider {
    private static FileURNFactory a;

    public static synchronized void initialize(URNFactory uRNFactory, IFileURNProvider iFileURNProvider) {
        if (a == null) {
            a = new FileURNFactory();
            uRNFactory.register(a);
        }
    }

    public static FileURNFactory getInstance() {
        return a;
    }

    private FileURNFactory() {
    }

    @Override
    public List<URNResourceType> getResourceTypes() {
        return URNResourceType.ALL;
    }

    @Override
    public NID getNID() {
        return NID.FILE;
    }

    @Override
    public FileURN parse(String string, String string2, String string3, String string4, String string5) throws URNException {
        Object object;
        URNResourceType uRNResourceType;
        if (string3 != null) {
            throw new NIDException("File URN should not contain a request part '?+': " + string3, string, NID.URL);
        }
        if (string4 != null) {
            throw new NSSException("Malformed File URN, query is not allowed", string, string2);
        }
        if (string5 != null) {
            throw new NSSException("Malformed File URN, fragment is not allowed", string, string2);
        }
        int n2 = string2.indexOf(58);
        if (n2 < 0) {
            throw new NSSException("Malformed File URN, missing ':' for file type identifier", string, string2);
        }
        int n3 = string2.indexOf(58, n2 + 1);
        if (n2 < 0) {
            throw new NSSException("Malformed File URN, missing ':' for file name", string, string2);
        }
        String string6 = string2.substring(0, n2);
        try {
            uRNResourceType = URNResourceType.valueOf(string6);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Invalid URNResourceType: " + string6);
        }
        String string7 = string2.substring(n2, n3);
        if (string7.isEmpty()) {
            throw new IllegalArgumentException("File URN: empty ID");
        }
        if (uRNResourceType.idClass == String.class) {
            object = string7;
        } else {
            try {
                object = Long.parseLong(string7);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("File URN: invalid ID, should have been a Long: " + string7, numberFormatException);
            }
        }
        String string8 = string2.substring(n3 + 1);
        return new FileURN(string, uRNResourceType, object, string8);
    }
}

