/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.PlainKStringProp;
import com.iizix.prop.PropException;
import com.iizix.prop.ValueConversionException;
import com.iizix.prop.vs.IVSComponent;
import com.iizix.prop.vs.IVSComponentState;
import com.iizix.text.KString;
import com.iizix.text.PlainKString;

public interface IVSMessageComponent
extends IVSComponent {
    default public boolean isValid() {
        PlainKString plainKString;
        PlainKStringProp plainKStringProp = this.getProp(Atom.MSG, PlainKStringProp.class);
        return plainKStringProp == null || (plainKString = plainKStringProp.getPlainKString()).isEmpty();
    }

    default public boolean clearMessage() {
        boolean bl = this.isValid();
        this.removeProp2(Atom.MSG);
        if (!bl) {
            this.getVirtualSpace().a(this, IVSComponentState.State.MESSAGE, true, null);
        }
        return !bl;
    }

    default public PlainKString getMessage() {
        PlainKString plainKString;
        PlainKStringProp plainKStringProp = this.getProp(Atom.MSG, PlainKStringProp.class);
        if (plainKStringProp != null && !(plainKString = plainKStringProp.getPlainKString()).isEmpty()) {
            return plainKString;
        }
        return null;
    }

    default public String getMessageString() {
        PlainKString plainKString;
        PlainKStringProp plainKStringProp = this.getProp(Atom.MSG, PlainKStringProp.class);
        if (plainKStringProp != null && (plainKString = plainKStringProp.getPlainKString()) != null && !plainKString.isEmpty()) {
            return plainKStringProp.getString();
        }
        return null;
    }

    default public int getMessageCategory() {
        return this.isValid() ? -1 : this.getInt(Atom.MCAT, -1);
    }

    default public boolean setMessage(ValueConversionException valueConversionException) {
        return valueConversionException != null ? this.setMessage(KString.newPlainKString(valueConversionException.getMessage()), 2) : this.clearMessage();
    }

    default public boolean setMessage(PlainKString plainKString, int n2) {
        if (plainKString == null || plainKString.isEmpty()) {
            return this.clearMessage();
        }
        if (n2 < -1 || n2 > 2) {
            throw new IllegalArgumentException("category range not -1 to 2: " + n2);
        }
        boolean bl = this.isValid();
        boolean bl2 = this.setInt(Atom.MCAT, n2);
        PlainKStringProp plainKStringProp = this.getProp(Atom.MSG, PlainKStringProp.class);
        try {
            bl2 = plainKStringProp != null ? (bl2 |= plainKStringProp.setPropValue(plainKString)) : (bl2 |= this.setProp2(new PlainKStringProp(Atom.MSG, plainKString)));
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), "Failed setting message", plainKString, this, propException);
        }
        boolean bl3 = plainKString.isEmpty();
        if (bl2 |= bl3 ^ bl) {
            this.getVirtualSpace().a(this, IVSComponentState.State.MESSAGE, bl3, null);
        }
        return bl2;
    }

    default public boolean setErrorMessage(String string) {
        return string == null || string.isEmpty() ? this.clearMessage() : this.setMessage(KString.newPlainKString(string), 2);
    }
}

