/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropError;
import com.iizix.prop.PropException;
import java.util.Arrays;

public interface IComplexOperation {
    public void setPropValue(GProp<?> var1, Object var2);

    public void addProp(PropCnr var1, GProp<?> var2);

    public void insertProp(PropCnr var1, GProp<?> var2, int var3);

    public void removeProp(GProp<?> var1);

    public void renameProp(GProp<?> var1, Atom var2);

    public void setPropError(GProp<?> var1, PropError var2);

    public void addPropError(GProp<?> var1, IPropErrorItem var2);

    public void removePropError(GProp<?> var1, String var2);

    public void moveProp(GProp<?> var1, PropCnr var2, Atom var3, int var4);

    public void reorderProps(PropCnr var1, Atom[] var2);

    public boolean hasPerformedAnOperation();

    public static void setPropValue(IComplexOperation iComplexOperation, IGProp<?> iGProp, Object object) {
        if (iComplexOperation != null) {
            iComplexOperation.setPropValue((GProp)iGProp, object);
        } else {
            try {
                iGProp.setPropValue(object);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed setPropValue", "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), propException);
            }
        }
    }

    public static void addProp(IComplexOperation iComplexOperation, PropCnr propCnr, IGProp<?> iGProp) {
        if (iComplexOperation != null) {
            iComplexOperation.addProp(propCnr, (GProp)iGProp);
        } else {
            try {
                propCnr.addProp(iGProp);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed addProp", "Container: " + propCnr.getReferencePropName() + ": " + String.valueOf(propCnr), "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), propException);
            }
        }
    }

    public static void insertProp(IComplexOperation iComplexOperation, PropCnr propCnr, IGProp<?> iGProp, int n2) {
        if (iComplexOperation != null) {
            iComplexOperation.insertProp(propCnr, (GProp)iGProp, n2);
        } else {
            try {
                propCnr.insertProp(iGProp, n2);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed insertProp", "Container: " + propCnr.getReferencePropName() + ": " + String.valueOf(propCnr), "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), "Index: " + n2, propException);
            }
        }
    }

    public static void removeProp(IComplexOperation iComplexOperation, IGProp<?> iGProp) {
        if (iComplexOperation != null) {
            iComplexOperation.removeProp((GProp)iGProp);
        } else {
            PropCnr propCnr = iGProp.getParent();
            try {
                propCnr.removeProp(iGProp);
            }
            catch (Exception exception) {
                ILog.WARNING(IComplexOperation.class, "Failed removeProp", "Container: " + propCnr.getReferencePropName() + ": " + String.valueOf(propCnr), "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), exception);
            }
        }
    }

    public static void renameProp(IComplexOperation iComplexOperation, IGProp<?> iGProp, Atom atom) {
        if (iComplexOperation != null) {
            iComplexOperation.renameProp((GProp)iGProp, atom);
        } else {
            try {
                iGProp.renameProp(atom);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed renameProp", "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), "New name: " + String.valueOf(atom), propException);
            }
        }
    }

    public static void setPropError(IComplexOperation iComplexOperation, IGProp<?> iGProp, PropError propError) {
        if (iComplexOperation != null) {
            iComplexOperation.setPropError((GProp)iGProp, propError);
        } else {
            iGProp.setPropError(propError);
        }
    }

    public static void addPropError(IComplexOperation iComplexOperation, IGProp<?> iGProp, IPropErrorItem iPropErrorItem) {
        if (iComplexOperation != null) {
            iComplexOperation.addPropError((GProp)iGProp, iPropErrorItem);
        } else {
            iGProp.addPropError(iPropErrorItem);
        }
    }

    public static void removePropError(IComplexOperation iComplexOperation, IGProp<?> iGProp, String string) {
        if (iComplexOperation != null) {
            iComplexOperation.removePropError((GProp)iGProp, string);
        } else {
            iGProp.removePropError(string);
        }
    }

    public static void moveProp(IComplexOperation iComplexOperation, IGProp<?> iGProp, PropCnr propCnr, Atom atom, int n2) {
        if (iComplexOperation != null) {
            iComplexOperation.moveProp((GProp)iGProp, propCnr, atom, n2);
        } else {
            try {
                iGProp.moveProp(propCnr, atom, n2);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed moveProp", "Property: " + iGProp.getReferencePropName() + ": " + String.valueOf(iGProp), "Destination container: " + propCnr.getReferencePropName() + ": " + String.valueOf(propCnr), "New name: " + String.valueOf(atom), "Destination index: " + n2, propException);
            }
        }
    }

    public static void reorderProps(IComplexOperation iComplexOperation, PropCnr propCnr, Atom[] atomArray) {
        if (iComplexOperation != null) {
            iComplexOperation.reorderProps(propCnr, atomArray);
        } else {
            try {
                propCnr.reorderProps(atomArray);
            }
            catch (PropException propException) {
                ILog.WARNING(IComplexOperation.class, "Failed reorderProps", "Container: " + propCnr.getReferencePropName() + ": " + String.valueOf(propCnr), "Order: " + Arrays.toString(atomArray), propException);
            }
        }
    }
}

