/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CharProp
extends GProp<Character> {
    private static final Class<?>[] a = new Class[]{Character.class, Long.class, Integer.class, Short.class, Byte.class, Float.class, Double.class, String.class};
    private static final Character a = Character.valueOf('\u0000');

    protected CharProp() {
    }

    public CharProp(Atom atom) {
        super(atom);
    }

    public CharProp(Atom atom, char c2) {
        super(atom);
        this.setPropValue(c2);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(char c2) {
        try {
            return super.setPropValue(Character.valueOf(c2));
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Character)) {
            throw new PropTypeException(this, "newValue not Character");
        }
    }

    public char getChar() {
        return this.getChar('\u0000');
    }

    public char getChar(char c2) {
        Character c3 = (Character)this.getPropValue();
        return c3 == null ? c2 : c3.charValue();
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Character c2 = (Character)object;
        sendTransaction.appendChar(c2 == null ? (char)'\u0000' : c2.charValue());
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)Character.valueOf(readTransaction.readChar()), propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        int n2 = string.length();
        if (n2 == 0) {
            return a;
        }
        if (n2 != 1) {
            throw new PropException(this, "Invalid character, length != 1");
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public String toElementString(Object object) {
        return a.equals(object) ? "" : object.toString();
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        int n3 = ((Character)object).charValue() & 0xFFFF;
        switch (n2) {
            case 1: {
                return (long)n3;
            }
            case 2: {
                return n3;
            }
            case 3: {
                return (int)((short)n3);
            }
            case 4: {
                if ((n3 & 0xFF) != 0) {
                    throw new IllegalArgumentException("Value out of range");
                }
                return (byte)n3;
            }
            case 5: {
                return Float.valueOf(n3);
            }
            case 6: {
                return (double)n3;
            }
            case 7: {
                return object.toString();
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        char c2;
        switch (n2) {
            case 1: {
                long l2 = (Long)object;
                if (l2 < 0L || l2 > 65535L) {
                    throw new IllegalArgumentException("Value out of range");
                }
                c2 = (char)l2;
                break;
            }
            case 2: {
                int n3 = (Integer)object;
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("Value out of range");
                }
                c2 = (char)n3;
                break;
            }
            case 3: {
                int n4 = ((Short)object).intValue() & 0xFFFF;
                c2 = (char)n4;
                break;
            }
            case 4: {
                int n5 = (Byte)object & 0xFF;
                c2 = (char)n5;
                break;
            }
            case 5: {
                long l3 = ((Float)object).longValue();
                if (l3 < 0L || l3 > 65535L) {
                    throw new IllegalArgumentException("Value out of range");
                }
                c2 = (char)l3;
                break;
            }
            case 6: {
                long l4 = ((Double)object).longValue();
                if (l4 < 0L || l4 > 65535L) {
                    throw new IllegalArgumentException("Value out of range");
                }
                c2 = (char)l4;
                break;
            }
            case 7: {
                return this.fromElementString((String)object);
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return Character.valueOf(c2);
    }
}

