/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.nio;

import com.iizix.Utilities;
import com.iizix.comm.State;
import com.iizix.nio.ISocketComm;
import com.iizix.nio.LoggerNIO;
import com.iizix.nio.SSLCommLayer;
import com.iizix.nio.SocketCommListener;
import com.iizix.nio.WorkerNIO;
import java.io.EOFException;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.net.ssl.SSLEngine;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SocketCommNIO
implements ISocketComm {
    private static long b;
    private static LoggerNIO a;
    public final String host;
    public final int port;
    public final String bindAddress;
    public boolean doResolveHostNames;
    private SSLCommLayer a;
    private State a;
    boolean a;
    boolean b;
    SocketChannel a;
    SelectionKey a;
    final WorkerNIO a;
    final SocketCommListener a;
    final ArrayList<ByteBuffer> a;
    final boolean c;
    final long a;
    private long c;
    private long d;
    private long e;
    private long f;
    private long g;
    private String a = SocketCommNIO.a();

    static synchronized long a() {
        return ++b;
    }

    static void a(String string) {
        LoggerNIO loggerNIO = a;
        if (loggerNIO != null) {
            loggerNIO.logErr(string);
        } else {
            System.err.println(string);
        }
    }

    public static void setLogger(LoggerNIO loggerNIO) {
        a = loggerNIO;
    }

    public SocketCommNIO(String string, int n2, String string2, WorkerNIO workerNIO, SocketCommListener socketCommListener, boolean bl, SSLEngine sSLEngine) {
        this.host = string;
        this.port = n2;
        this.bindAddress = string2;
        this.a = socketCommListener;
        this.c = bl;
        this.a = workerNIO;
        this.a = State.UNINITIALIZED;
        this.a = sSLEngine != null ? new SSLCommLayer(sSLEngine, this) : null;
    }

    protected SocketCommNIO(WorkerNIO workerNIO, SocketChannel socketChannel, SocketCommListener socketCommListener, boolean bl) throws IOException {
        this.port = -1;
        this.host = null;
        this.bindAddress = null;
        this.a = workerNIO;
        this.c = bl;
        this.a = socketChannel;
        this.a = socketCommListener;
        this.a = null;
        socketChannel.configureBlocking(false);
        this.setupSocket();
        try {
            this.a = workerNIO.register(this, socketChannel, 1);
        }
        catch (IOException iOException) {
            try {
                socketChannel.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            socketChannel = null;
            throw iOException;
        }
    }

    void a(State state) {
        if (this.a != state) {
            this.a = state;
            this.a.onCommState(this);
        }
    }

    public boolean isSecure() {
        return this.a != null;
    }

    public SSLCommLayer getSSLCommLayer() {
        return this.a;
    }

    void a() {
        this.a(State.CONNECTED);
        this.a.onCommConnected(this);
    }

    void b(String string) {
        if (this.c) {
            System.out.println(this.getClass().getName() + "[" + this.a + "," + String.format(Locale.ENGLISH, "%1$tH:%1$tM:%1$tS.%1$tL", new Date()) + "]: " + string);
        }
    }

    void a(String string, ByteBuffer byteBuffer) {
        if (this.c) {
            byteBuffer = byteBuffer.duplicate();
            int n2 = byteBuffer.remaining();
            byte[] byArray = new byte[n2];
            byteBuffer.get(byArray);
            StringBuilder stringBuilder = new StringBuilder(string).append(": length = " + n2);
            if (n2 > 0) {
                stringBuilder.append('\n').append(Utilities.toHex(byArray));
            }
            System.out.println(this.getClass().getName() + "[" + this.a + "," + String.format(Locale.ENGLISH, "%1$tH:%1$tM:%1$tS.%1$tL", new Date()) + "]: " + String.valueOf(stringBuilder));
        }
    }

    protected Socket setupSocket() throws SocketException {
        Socket socket = this.a.socket();
        socket.setPerformancePreferences(2, 2, 0);
        socket.setKeepAlive(true);
        socket.setSoLinger(false, 0);
        socket.setTcpNoDelay(true);
        try {
            socket.setTrafficClass(28);
        }
        catch (SocketException socketException) {
            SocketCommNIO.a(" -- socket.setTrafficClass error: " + String.valueOf(socketException));
        }
        return socket;
    }

    public boolean hasBeenOpen() {
        return this.a != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        SocketCommNIO socketCommNIO = this;
        synchronized (socketCommNIO) {
            this.b("open()");
            if (this.a != null) {
                throw new IOException("Already open");
            }
            this.a = SocketChannel.open();
            this.a.configureBlocking(false);
            Socket socket = null;
            try {
                socket = this.setupSocket();
                socket.setReuseAddress(true);
                if (this.bindAddress != null) {
                    socket.bind(new InetSocketAddress(this.bindAddress, 0));
                }
                try {
                    this.a.connect(new InetSocketAddress(this.host, this.port));
                }
                catch (Throwable throwable) {
                    IOException iOException = new IOException("Socket connect error");
                    iOException.initCause(throwable);
                    throw iOException;
                }
                this.a.wakeupSelector();
                this.a = this.a.register(this, this.a, 8);
            }
            catch (IOException iOException) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                try {
                    this.a.close();
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                this.a = null;
                throw iOException;
            }
            this.a(State.CONNECTING);
        }
        this.b("onCommOpen");
        this.a.onCommOpen(this);
    }

    public void enterSecureMode(SSLEngine sSLEngine, ByteBuffer byteBuffer) throws IOException {
        this.a = new SSLCommLayer(sSLEngine, this, byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void process(ByteBuffer var1_1) {
        this.b("process");
        try {
            if (this.a == null || !this.a.isValid()) {
                this.b("process->invalidKey->close()");
                if (!this.b && !this.a) {
                    this.a.onCommError(this, new IOException("Connection refused?"));
                }
                this.close(true);
                return;
            }
            if (this.a.isConnectable()) {
                this.b("process->isConnectable()");
                if (this.a.isConnectionPending()) {
                    if (!this.a.finishConnect()) {
                        return;
                    }
                    this.a.interestOps(5);
                    if (this.a != null) {
                        this.a.a();
                        return;
                    }
                    this.b = true;
                    this.a(State.CONNECTED);
                    this.b("onCommConnected");
                    this.a.onCommConnected(this);
                }
            }
            if (this.a != null) {
                this.a.a(this.a);
                return;
            }
            var2_2 = false;
            while (this.a.isValid() && this.a.isWritable()) {
                var4_9 = this;
                synchronized (var4_9) {
                    if (this.a.isEmpty()) {
                        var2_2 = true;
                        break;
                    }
                    var3_5 = (ByteBuffer)this.a.get(0);
                }
                this.a("process->send", var3_5);
                this.b(var3_5);
                if (var3_5.hasRemaining()) {
                    this.a("process->send: hasRemaining()", var3_5);
                    break;
                }
                this.b("process->send: completed!");
                var4_8 = false;
                var5_11 = this;
                synchronized (var5_11) {
                    this.a.remove(0);
                    if (this.a == State.CLOSING && this.a.isEmpty()) {
                        var4_8 = true;
                    }
                }
                if (!var4_8) continue;
                this.b("process->send->close()");
                this.close(true);
                break;
            }
            if (!var2_2 || !this.a.isValid()) ** GOTO lbl81
            this.b("process->send->remove-OP_WRITE");
            this.a.interestOps(1);
            try {
                if (true) ** GOTO lbl81
                do {
                    this.b("process->read");
                    var1_1.clear();
                    var3_6 = this.a(var1_1);
                    if (var3_6 < 0) {
                        this.b("process->read->EOF");
                        throw new EOFException("Connection closed by peer");
                    }
                    if (var3_6 == 0) return;
                    var1_1.flip();
                    this.a("process->read", var1_1);
                    this.a.onCommData(this, var1_1);
lbl81:
                    // 3 sources

                    if (!this.a.isValid()) return;
                } while (this.a.isReadable());
                return;
            }
            catch (IOException var3_7) {
                if (this.c) {
                    this.b("process->read->close(): " + String.valueOf(var3_7));
                }
                if (!this.a) {
                    if (var3_7 instanceof EOFException) {
                        var4_10 = var3_7;
                    } else {
                        var4_10 = new EOFException("Connection closed by peer");
                        var4_10.initCause(var3_7);
                    }
                    this.a.onCommError(this, var4_10);
                }
                this.close(true);
            }
            return;
        }
        catch (IOException var2_3) {
            if (!this.a) {
                if (this.c) {
                    this.b("process->onCommError->close(): " + String.valueOf(var2_3));
                }
                this.a.onCommError(this, var2_3);
            }
            this.close(true);
            return;
        }
        catch (CancelledKeyException var2_4) {
            if (!this.a) {
                if (this.c) {
                    this.b("process->CancelledKeyException->close(): " + Utilities.getStackTrace(var2_4));
                }
                this.a.onCommError(this, new IOException("Selection Key cancelled"));
            }
            this.close(true);
        }
    }

    public void setNonConnectedReadTimeout(long l2) {
        this.c = l2;
    }

    public long getNonConnectedReadTimeout() {
        return this.c;
    }

    public void setReadTimeout(long l2) {
        this.d = l2;
    }

    public long getReadTimeout() {
        return this.d;
    }

    public void setWriteTimeout(long l2) {
        this.e = l2;
    }

    public long getWriteTimeout() {
        return this.e;
    }

    private boolean a() {
        return !((ArrayList)((Object)this.a)).isEmpty() ? true : this.a != null && this.a.a();
    }

    @Override
    public long getRemainingTimeout(long l2) {
        long l3;
        long l4 = -1L;
        if (this.e > 0L && this.g != 0L && this.a()) {
            l3 = l2 - this.g;
            l4 = Math.max(this.e - l3, 0L);
        }
        long l5 = l3 = this.a != State.CONNECTED ? this.c : this.d;
        if (l3 > 0L && this.f != 0L) {
            long l6 = l2 - this.f;
            long l7 = l4 = l4 < 0L ? Math.max(l3 - l6, 0L) : Math.min(l4, Math.max(l3 - l6, 0L));
        }
        if (this.c) {
            this.b("getRemainingTimeout: time = " + l4);
        }
        return l4;
    }

    @Override
    public void checkTimeout(long l2) {
        long l3;
        if (this.e > 0L && this.g != 0L && this.a() && l2 - this.g >= this.e) {
            this.b("checkTimeout: timeout for write");
            this.g = l2;
            this.a.onCommTimeout(this, false);
        }
        long l4 = l3 = this.a != State.CONNECTED ? this.c : this.d;
        if (l3 > 0L && this.f != 0L && l2 - this.f >= l3) {
            if (this.a == State.CONNECTED) {
                this.b("checkTimeout: timeout for read");
                this.f = l2;
                this.a.onCommTimeout(this, true);
            } else if (this.a == State.PROXY_SETUP) {
                this.b("checkTimeout: Proxy Connect timeout for read: closing...");
                this.f = l2;
                this.a.onCommError(this, new IOException("Proxy Connect negotation timeout, peer non-responsive"));
                this.close(true);
            } else if (this.a == State.SECURING) {
                this.b("checkTimeout: SSL handshake timeout for read: closing...");
                this.f = l2;
                this.a.onCommError(this, new IOException("SSL Handshake timeout, peer non-responsive"));
                this.close(true);
            } else if (this.a == State.CLOSING) {
                this.b("checkTimeout: Closing timeout for read: closing...");
                this.f = l2;
                this.a.onCommError(this, new IOException("Closing timeout, peer non-responsive"));
                this.close(true);
            }
        }
    }

    int a(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.a.read(byteBuffer);
        this.f = System.currentTimeMillis();
        return n2;
    }

    int b(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.a.write(byteBuffer);
        this.g = System.currentTimeMillis();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer byteBuffer) throws IOException {
        try {
            SocketCommNIO socketCommNIO = this;
            synchronized (socketCommNIO) {
                if (this.a != State.CONNECTED) {
                    throw new IOException("Socket not connected but " + String.valueOf((Object)this.a));
                }
                ((ArrayList)((Object)this.a)).add(byteBuffer);
            }
            this.g = System.currentTimeMillis();
            this.a("send->OP_WRITE: wakeup selector", byteBuffer);
            this.a.interestOps(5);
            this.a.selector().wakeup();
        }
        catch (CancelledKeyException cancelledKeyException) {
            if (this.c) {
                this.b("send->CancelledKeyException: " + String.valueOf(cancelledKeyException));
            }
            IOException iOException = new IOException("Selection Key cancelled");
            this.a.onCommError(this, iOException);
            this.close(true);
            throw iOException;
        }
    }

    public synchronized State getState() {
        return this.a;
    }

    public String getRemoteAddr() {
        try {
            InetAddress inetAddress = this.a.socket().getInetAddress();
            if (inetAddress instanceof Inet6Address && ((Inet6Address)inetAddress).isIPv4CompatibleAddress()) {
                byte[] byArray = inetAddress.getAddress();
                int n2 = byArray.length;
                return Integer.toString(byArray[n2 - 4] & 0xFF) + "." + (byArray[n2 - 4] & 0xFF) + "." + (byArray[n2 - 4] & 0xFF) + "." + (byArray[n2 - 4] & 0xFF);
            }
            return inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            return "0.0.0.0";
        }
    }

    public String getRemoteHost() {
        if (this.a != null) {
            return this.a;
        }
        try {
            if (this.doResolveHostNames) {
                this.a = this.a.socket().getInetAddress().getHostName();
                return this.a;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getRemoteAddr();
    }

    public InetSocketAddress getSocketAddress() {
        SocketChannel socketChannel = this.a;
        if (socketChannel == null) {
            return null;
        }
        try {
            return (InetSocketAddress)socketChannel.getRemoteAddress();
        }
        catch (IOException iOException) {
            return null;
        }
        catch (Throwable throwable) {
            Socket socket = socketChannel.socket();
            return socket != null ? (InetSocketAddress)socket.getRemoteSocketAddress() : null;
        }
    }

    public synchronized boolean isClosed() {
        return this.a;
    }

    public boolean close() {
        this.b("close()");
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(boolean bl) {
        if (this.c) {
            this.b("close(now=" + bl + ")");
        }
        SocketCommNIO socketCommNIO = this;
        synchronized (socketCommNIO) {
            block21: {
                block22: {
                    block23: {
                        block20: {
                            block19: {
                                if (!this.a) break block19;
                                return false;
                            }
                            if (this.a != State.UNINITIALIZED) break block20;
                            this.a = true;
                            this.a(State.CLOSED);
                            return true;
                        }
                        if (bl) break block21;
                        if (this.a != State.CLOSING) break block22;
                        if (((ArrayList)((Object)this.a)).isEmpty()) break block23;
                        this.b("close(state=closing)->sendQueue->notEmpty");
                        return true;
                    }
                    if (this.a != null) {
                        this.a.b();
                        return true;
                    }
                    break block21;
                }
                if (this.a != State.CONNECTED) break block21;
                this.a(State.CLOSING);
                if (((ArrayList)((Object)this.a)).isEmpty()) break block21;
                this.b("close(state=connected)->sendQueue->notEmpty");
                return true;
            }
            this.b("close->sendQueue->clear");
            this.a = true;
            this.a(State.CLOSED);
            ((ArrayList)((Object)this.a)).clear();
            if (this.a != null) {
                this.a.c();
            }
            if (this.a != null) {
                try {
                    this.a.interestOps(0);
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
                try {
                    this.a.cancel();
                }
                catch (CancelledKeyException cancelledKeyException) {
                    // empty catch block
                }
            }
            this.a.wakeupSelector();
            if (this.a != null) {
                try {
                    this.a.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.a.wakeupSelector();
        this.b("onCommClosed");
        this.a.onCommClosed(this);
        return true;
    }
}

