/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license.history;

import com.iizix.Utilities;
import com.iizix.license.history.LicensingHistoryEvent;
import java.io.Serializable;

public final class ActivationChange
implements Serializable,
Comparable<ActivationChange> {
    private static final long serialVersionUID = -114751988716562359L;
    protected long time;
    protected LicensingHistoryEvent event;
    protected String msg;
    protected int hashCode;

    public ActivationChange(String string) {
        int n2 = string.indexOf(44);
        int n3 = string.indexOf(44, n2 + 1);
        this.time = Long.parseLong(string.substring(0, n2));
        this.event = LicensingHistoryEvent.from(Integer.parseInt(string.substring(n2 + 1, n3)));
        this.msg = string.substring(n3 + 1);
        if (this.event.equals((Object)LicensingHistoryEvent._UNKNOWN_)) {
            throw new IllegalArgumentException("Invalid string: " + string + " --> " + this.toString());
        }
    }

    public ActivationChange(LicensingHistoryEvent licensingHistoryEvent, String string) {
        this.time = System.currentTimeMillis();
        this.event = licensingHistoryEvent;
        this.msg = string;
    }

    public long getTime() {
        return this.time;
    }

    public LicensingHistoryEvent getEvent() {
        return this.event;
    }

    public String getMessage() {
        return this.msg;
    }

    public String getUnparsedString() {
        return Long.toString(this.time) + "," + this.event.value + "," + this.msg;
    }

    public String toString() {
        return Utilities.formatDate(this.time) + "  [" + this.event.getText() + "]  " + this.msg;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ActivationChange) {
            ActivationChange activationChange = (ActivationChange)object;
            return activationChange.time == this.time && activationChange.event.equals((Object)this.event) && activationChange.msg.equals(this.msg);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = (int)this.time ^ (int)(this.time >> 16) ^ this.msg.hashCode() * 7 ^ this.event.value * 11;
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(ActivationChange activationChange) {
        int n2 = Long.compare(this.time, activationChange.time);
        if (n2 == 0 && (n2 = Integer.compare(this.event.value, activationChange.event.value)) == 0) {
            n2 = Utilities.COLLATOR.compare(this.msg, activationChange.msg);
        }
        return n2;
    }
}

