/*
 * Decompiled with CFR 0.152.
 */
package com.iizix;

import com.iizix.Position;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import java.util.Objects;
import java.util.StringTokenizer;

public class Rect
implements Cloneable {
    public static final Rect[] EMPTY = new Rect[0];
    public int x;
    public int y;
    public int cx;
    public int cy;

    public Rect() {
    }

    public Rect(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.x = Integer.parseInt(stringTokenizer.nextToken());
            this.y = Integer.parseInt(stringTokenizer.nextToken());
            this.cx = Integer.parseInt(stringTokenizer.nextToken());
            this.cy = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid Rect string: " + string, exception);
        }
    }

    public Rect(ReadTransaction readTransaction) {
        this.x = readTransaction.readSigned();
        this.y = readTransaction.readSigned();
        this.cx = readTransaction.readSigned();
        this.cy = readTransaction.readSigned();
    }

    public Rect(int n2, int n3, int n4, int n5) {
        this.x = n2;
        this.y = n3;
        this.cx = n4;
        this.cy = n5;
    }

    public boolean isInside(Position position) {
        return position.x >= this.x && position.x < this.x + this.cx && position.y >= this.y && position.y < this.y + this.cy;
    }

    public void clear() {
        this.x = 0;
        this.y = 0;
        this.cx = 0;
        this.cy = 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Rect) {
            Rect rect = (Rect)object;
            return this.x == rect.x && this.y == rect.y && this.cx == rect.cx && this.cy == rect.cy;
        }
        return false;
    }

    public Rect clone() {
        try {
            return (Rect)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String toString() {
        return new StringBuilder(48).append(this.x).append(',').append(this.y).append(',').append(this.cx).append(',').append(this.cy).toString();
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.cx, this.cy);
    }

    public void append(SendTransaction sendTransaction) {
        sendTransaction.appendSigned(this.x);
        sendTransaction.appendSigned(this.y);
        sendTransaction.appendSigned(this.cx);
        sendTransaction.appendSigned(this.cy);
    }
}

