/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth;

import com.iizix.ILog;
import com.iizix.RunMode;
import com.iizix.comm.oauth.IOAuthCallbackProvider;
import com.iizix.comm.oauth.IOAuthListener;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.server.client.ClientParams;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.oauth.AbstractOAuthService;
import com.iizix.server.oauth.OAuthEngine;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class OAuthSession {
    private final AppSessionGyro a;
    private IOAuthCallbackProvider a;
    private AbstractOAuthService a;
    private IOAuthListener a;
    private String a;
    private IOAuthListener.Code a;
    private String b;
    private String c;
    private String d = "Not authenticated yet";
    private String e;
    private final OAuthEngine a;
    private boolean a = IOAuthListener.Code.INCOMPLETE;

    public OAuthSession(IAppSessionGyro iAppSessionGyro) {
        if (iAppSessionGyro == null) {
            throw new NullPointerException("appGyro is null");
        }
        this.a = OAuthEngine.getCurrentInstance();
        this.a = (AppSessionGyro)iAppSessionGyro;
    }

    public OAuthSession(IOAuthCallbackProvider iOAuthCallbackProvider) {
        if (iOAuthCallbackProvider == null) {
            throw new NullPointerException("callbackProvider is null");
        }
        if (!RunMode.isDesignerRunMode()) {
            throw new IllegalStateException("Not called from Designer");
        }
        this.a = OAuthEngine.getCurrentInstance();
        this.a = null;
        this.a = iOAuthCallbackProvider;
    }

    public boolean isOAuth2() {
        AbstractOAuthService abstractOAuthService = this.a;
        if (abstractOAuthService != null) {
            if (abstractOAuthService.service2 != null) {
                return true;
            }
            if (abstractOAuthService.service1 != null) {
                return false;
            }
        }
        throw new IllegalStateException("Authentication service type is not yet set");
    }

    public String getOAuth1Token() {
        String string;
        AbstractOAuthService abstractOAuthService = this.a;
        if (abstractOAuthService != null && (string = abstractOAuthService.a) != null) {
            return string;
        }
        throw new IllegalStateException("Authentication service type is not yet set or is not of OAuth 1.0a type");
    }

    public AppSessionGyro getAppSessionGyro() {
        return this.a;
    }

    public String getCallbackURL() {
        return this.a.a(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getState() {
        String string = this.a;
        if (string == null) {
            OAuthSession oAuthSession = this;
            synchronized (oAuthSession) {
                string = this.a;
                if (string == null) {
                    string = this.a = UUID.randomUUID().toString();
                }
            }
        }
        return string;
    }

    public IOAuthListener.Code getCompletionCode() {
        return this.a;
    }

    public String getAuthenticationCode() {
        return this.b;
    }

    public String getErrorURI() {
        return this.e;
    }

    public String getErrorCode() {
        return this.c;
    }

    public String getErrorDescription() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(AbstractOAuthService abstractOAuthService, IOAuthListener iOAuthListener) throws IOException, InterruptedException, ExecutionException {
        OAuthSession oAuthSession = this;
        synchronized (oAuthSession) {
            if (this.a != null) {
                throw new IllegalStateException("service.doAuthentication has already been issued");
            }
            this.a = Objects.requireNonNull(abstractOAuthService);
            this.a = Objects.requireNonNull(iOAuthListener);
        }
        if (this.a != null) {
            this.a = this.a.requestOAuthCallbackDisplay(abstractOAuthService);
        }
        this.a.a(this, abstractOAuthService.a(), this.a);
    }

    public final AbstractOAuthService getService() {
        return this.a;
    }

    public void disposeBlocked() {
        this.a(IOAuthListener.Code.DISPOSED_BLOCKED);
    }

    public void disposeUserCancel() {
        this.a(IOAuthListener.Code.DISPOSED_USER_CANCEL);
    }

    public void dispose() {
        this.a(IOAuthListener.Code.DISPOSED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(IOAuthListener.Code code) {
        IOAuthListener iOAuthListener;
        OAuthSession oAuthSession = this;
        synchronized (oAuthSession) {
            if (this.a) {
                return;
            }
            iOAuthListener = this.a;
            this.a = null;
            this.a = code;
            this.a = true;
        }
        this.a.a(this);
        if (iOAuthListener != null) {
            try {
                iOAuthListener.onAuthenticationComplete(code);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)"Failed onAuthenticationComplete", (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(ClientParams clientParams, HttpServletRequest httpServletRequest) throws IOException {
        Object object;
        CharSequence charSequence;
        if (this.a != null && this.a.isDisposed()) {
            String string = "Application session has been disposed of: query = " + httpServletRequest.getQueryString();
            ILog.WARNING(this.getClass(), (String)string, (Object)("Application Session ID = " + this.a.getAppSessionInfo().getConnectionIDString()));
            throw new IOException(string);
        }
        String string = this.a.getServiceName();
        IOAuthListener.Code code = this.a = IOAuthListener.Code.SUCCESS;
        if (this.a.service2 != null) {
            charSequence = clientParams.getParameterValue("state");
            object = this.getState();
            if (!((String)object).equals(charSequence)) {
                code = this.a = IOAuthListener.Code.INVALID_STATE;
                ILog.WARNING(this.getClass(), (String)("Authentication service \"" + string + "\" (OAuth 2.0) returned the state \"" + (String)charSequence + "\" that does not match internal state \"" + (String)object + "\""), (Object[])new Object[]{"Query = " + httpServletRequest.getQueryString(), "Application Session ID = " + (this.a != null ? this.a.getAppSessionInfo().getConnectionIDString() : "n/a")});
            }
            this.d = clientParams.getParameterValue("error_description");
            this.e = clientParams.getParameterValue("error_uri");
            this.b = clientParams.getParameterValue("code");
            if (this.b == null) {
                this.c = clientParams.getParameterValue("error");
                if (code == IOAuthListener.Code.INVALID_STATE) {
                    code = IOAuthListener.Code.fromString((String)this.c);
                    code = code == IOAuthListener.Code.UNKNOWN_ERROR ? IOAuthListener.Code.INVALID_STATE : code;
                    this.a = code;
                } else {
                    code = this.a = IOAuthListener.Code.fromString((String)this.c);
                }
                if (code == IOAuthListener.Code.UNKNOWN_ERROR) {
                    ILog.WARNING(this.getClass(), (String)("Authentication service \"" + string + "\" (OAuth 2.0) with state " + (String)charSequence + " returned an unknown error: " + this.c), (Object[])new Object[]{"Query = " + httpServletRequest.getQueryString(), "Application Session ID = " + (this.a != null ? this.a.getAppSessionInfo().getConnectionIDString() : "n/a")});
                } else {
                    ILog.WARNING(this.getClass(), (String)("Authentication service \"" + string + "\" (OAuth 2.0) with state " + (String)charSequence + " returned error code = " + String.valueOf(code)), (Object[])new Object[]{"Query = " + httpServletRequest.getQueryString(), "Application Session ID = " + (this.a != null ? this.a.getAppSessionInfo().getConnectionIDString() : "n/a")});
                }
            }
        } else {
            this.b = clientParams.getParameterValue("oauth_verifier");
            if (this.b == null) {
                code = this.a = IOAuthListener.Code.ACCESS_DENIED;
                charSequence = new StringBuilder();
                try {
                    object = null;
                    Object var7_11 = null;
                    try (BufferedReader bufferedReader = httpServletRequest.getReader();){
                        int n;
                        while ((n = ((Reader)bufferedReader).read()) >= 0) {
                            ((StringBuilder)charSequence).append((char)n);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (((StringBuilder)charSequence).length() == 0) {
                    ((StringBuilder)charSequence).append("[body is emty]");
                } else {
                    ((StringBuilder)charSequence).insert(0, '\n');
                    ((StringBuilder)charSequence).append('\n');
                }
                ILog.WARNING(this.getClass(), (String)("Authentication service \"" + string + "\" (OAuth 1.0a) with oauth_verifier " + this.b + " did not return the \"oauth_verifier\" parameter"), (Object[])new Object[]{"Query = " + httpServletRequest.getQueryString(), "Content type = " + httpServletRequest.getContentType(), "Character encoding = " + httpServletRequest.getCharacterEncoding(), "Body: " + String.valueOf(charSequence), "Application Session ID = " + (this.a != null ? this.a.getAppSessionInfo().getConnectionIDString() : "n/a")});
            }
        }
        charSequence = this.a;
        object = this;
        synchronized (object) {
            charSequence = this.a;
            this.a = null;
        }
        if (charSequence != null) {
            try {
                charSequence.onAuthenticationComplete(code);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)("Failed onAuthenticationComplete: service = " + string), (Throwable)throwable);
            }
        }
        if (this.a != null) {
            this.a.closeAuthenticationWindows();
        }
    }
}

