/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.gyro;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.IPluginDescriptor;
import com.iizix.LocaleInfo;
import com.iizix.SessionInfo;
import com.iizix.Size;
import com.iizix.Utilities;
import com.iizix.Worker;
import com.iizix.comm.ITransactionCreator;
import com.iizix.comm.ITransactionSender;
import com.iizix.comm.oauth.IOAuthCallbackProvider;
import com.iizix.comm.oauth.IOAuthService;
import com.iizix.geo.ILocationService;
import com.iizix.gyro.FocusEvent;
import com.iizix.gyro.FocusException;
import com.iizix.gyro.FocusVetoException;
import com.iizix.gyro.IAppSessionDisposeListener;
import com.iizix.gyro.IAppSessionFocusProvider;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionConnectionListener;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.gyro.IFocusComp;
import com.iizix.gyro.IFocusEngine;
import com.iizix.gyro.IFocusEngineProvider;
import com.iizix.gyro.ILockState;
import com.iizix.gyro.IMessageBox;
import com.iizix.gyro.IMessageBoxReply;
import com.iizix.gyro.IToaster;
import com.iizix.gyro.IUserAuthenticationUI;
import com.iizix.gyro.ProgressIndicatorDelay;
import com.iizix.gyro.WindowOptions;
import com.iizix.gyro.history.IAppHistory;
import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IPropMgrInfoProvider;
import com.iizix.prop.ModuleApp;
import com.iizix.prop.PreloadClientCacheResource;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.image.RuntimeImageDefinition;
import com.iizix.prop.ui.MessageBox;
import com.iizix.prop.vs.IVSComponent;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.server.ServerShell;
import com.iizix.server.WorkerThread;
import com.iizix.server.app.AppFactory;
import com.iizix.server.app.IRuntimeReferenceLookup;
import com.iizix.server.app.IVirtualizedReferenceLookup;
import com.iizix.server.app.IVirtualsContainer;
import com.iizix.server.app.VirtualizedItem;
import com.iizix.server.app.VirtualsContainer;
import com.iizix.server.app.prop.AppPropCnr;
import com.iizix.server.app.prop.ModuleProjectPropCnr;
import com.iizix.server.client.ClientEndPoint;
import com.iizix.server.client.ClientParams;
import com.iizix.server.client.ClientTransactionProcessor;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.gyro.IGyroFocusEngineOwner;
import com.iizix.server.gyro.b;
import com.iizix.server.gyro.c;
import com.iizix.server.gyro.h;
import com.iizix.server.gyro.j;
import com.iizix.server.prop.ServerConfigEnvProps;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserSessions;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.text.IKStringInfoProvider;
import com.iizix.text.ILocaleString;
import com.iizix.text.KString;
import com.iizix.text.util.PrettyLocaledTexts;
import com.iizix.timeout.ITimeoutTask;
import com.iizix.timeout.ITimerEngine;
import com.iizix.timeout.engine.TimerEngine;
import com.iizix.txp.ITXPCoordinator;
import com.iizix.urn.URNResourceType;
import com.iizix.user.SessionUserIdentifier;
import com.iizix.user.SigninResult;
import com.iizix.user.UserException;
import com.iizix.user.UserIdentifier;
import com.iizix.virtual.ThreadGroupType;
import com.iizix.virtual.VirtualThreadGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AppSessionGyro
implements IAppSessionGyro,
IFocusEngineProvider,
IRuntimeReferenceLookup,
IVirtualizedReferenceLookup,
IGyroFocusEngineOwner {
    private final long a;
    private final ServerShell a;
    private final SessionInfo a;
    private final VirtualThreadGroup a;
    private final Worker a;
    private final String a;
    private final UserSessions a;
    private final SessionUserIdentifier a;
    private final j a;
    private final ServerConfigEnvProps a;
    private final AppFactory a;
    private final AppPropCnr a;
    private final VirtualsContainer<VirtualSpace> a;
    private final HashMap<String, VirtualsContainer<?>> a;
    private final Object a;
    private final ArrayList<ClientSessionGyro> a;
    private ClientSessionGyro[] a;
    private EnvProps a;
    private boolean a;
    private VirtualSpace a;
    private boolean b;
    private int a;
    private KString a;
    private KString b;
    private int b;
    private int c;
    private int d;
    private int e;
    private final IAppSessionFocusProvider a;
    private boolean c;
    private boolean d = -1;
    private IVSComponent a;
    private IGProp<?> a;
    private boolean e = -1;
    private final b a;
    private String b;
    private GenericListener<IAppSessionDisposeListener> a;
    private GenericListener<IClientSessionConnectionListener> b;
    private WSFileProvider a;
    private AuthenticatedUser a;
    private PrettyLocaledTexts a;
    private ITimerEngine a;
    private ITimeoutTask a;
    private final HashMap<String, RuntimeImageDefinition> b;
    private Map<String, Object> a;
    private ArrayList<a> b = -2;
    private final ArrayList<MessageBox> c = -2;
    private c a = new b(this);

    public static AppSessionGyro getSessionInstance() {
        return AppSessionGyro.getSessionInstance(SessionInfo.getSessionInfo());
    }

    public static AppSessionGyro getSessionInstance(SessionInfo sessionInfo) {
        return sessionInfo != null ? (AppSessionGyro)sessionInfo.getPrivateData(STORAGE_NAME, AppSessionGyro.class) : null;
    }

    public AppSessionGyro(ServerShell serverShell, SessionInfo sessionInfo, UserSessions userSessions, ClientParams clientParams, AuthenticatedUser authenticatedUser) throws UserException {
        this.b = new HashMap();
        this.c = (int)new ArrayList();
        String string = clientParams.getParameterValue("env");
        this.a = serverShell.getServerProperties().getServerSettings().getServerConfigEnvironment(string);
        if (this.a == null) {
            throw new UserException((UserIdentifier)clientParams.user, "Server configuration environment '" + string + "' requested is not defined, connection rejected");
        }
        this.a = clientParams.appID;
        this.a = serverShell;
        this.a = sessionInfo;
        this.a = new VirtualThreadGroup(ThreadGroupType.APP_SESSION, this.a, sessionInfo, clientParams.app.getCommonClassLoader());
        this.a = userSessions;
        this.a = clientParams.user;
        this.a = authenticatedUser;
        this.a = clientParams.app;
        this.a = this.a.getAppRoot();
        this.a = new j(this);
        this.a = (long)new VirtualsContainer("vs", Atom.VIRTUALSPACE, VirtualSpace.class, serverShell.getPropertyManager(), this, this, true);
        this.a.a(this.a);
        this.a = this.a.getLockObject();
        sessionInfo.setPrivateData(STORAGE_NAME, (Object)this);
        Worker worker = sessionInfo.getWorker();
        if (worker != null) {
            worker.dispose();
        }
        try {
            this.a = new Worker(sessionInfo);
        }
        catch (IOException iOException) {
            throw new InternalError("Shouldn't be", iOException);
        }
        sessionInfo.setWorker(this.a);
        WorkerThread workerThread = new WorkerThread(this.a, () -> {
            boolean bl = this.dispose();
        });
        this.a.startThread((Runnable)workerThread, "<worker>", 6);
        serverShell.onApplicationSessionStarted(this);
        ModuleProjectPropCnr moduleProjectPropCnr = this.a.getModuleProjects()[0];
        ModuleApp moduleApp = moduleProjectPropCnr.getSettings().getModuleApp();
        this.a = moduleApp.getAppSessionFocusProvider();
        try {
            if (this.a != null) {
                this.a.onInitialized((IAppSessionGyro)this);
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"Failed initializing the IAppSessionFocusProvider", (Throwable)throwable);
        }
    }

    public synchronized boolean addDisposeListener(IAppSessionDisposeListener iAppSessionDisposeListener) {
        if (this.a == null) {
            this.a = (long)new GenericListener(IAppSessionDisposeListener.class);
        }
        return this.a.addListener((Object)iAppSessionDisposeListener);
    }

    public synchronized boolean removeDisposeListener(IAppSessionDisposeListener iAppSessionDisposeListener) {
        return this.a != null ? this.a.removeListener((Object)iAppSessionDisposeListener) : false;
    }

    public synchronized boolean addClientConnectionListener(IClientSessionConnectionListener iClientSessionConnectionListener) {
        if (this.b == null) {
            this.b = new GenericListener(IClientSessionConnectionListener.class);
        }
        return this.b.addListener((Object)iClientSessionConnectionListener);
    }

    public synchronized boolean removeClientConnectionListener(IClientSessionConnectionListener iClientSessionConnectionListener) {
        return this.b != null ? this.b.removeListener((Object)iClientSessionConnectionListener) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose() {
        Object object = this;
        synchronized (object) {
            block20: {
                if (!this.a) break block20;
                return false;
            }
            this.a = true;
        }
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = clientSessionGyroArray[n2];
            ((ClientSessionGyro)object).dispose();
            ++n2;
        }
        object = this.a;
        if (object != null) {
            object.forEach(iAppSessionDisposeListener -> iAppSessionDisposeListener.onDispose((IAppSessionGyro)this));
        }
        this.c();
        this.a.a();
        this.a.dispose();
        this.a.dispose();
        VirtualsContainer[] virtualsContainerArray = null;
        Object object2 = this.a;
        synchronized (object2) {
            if (!this.a.isEmpty()) {
                virtualsContainerArray = this.a.values().toArray(new VirtualsContainer[this.a.size()]);
                this.a.clear();
            }
        }
        if (virtualsContainerArray != null) {
            VirtualsContainer[] virtualsContainerArray2 = virtualsContainerArray;
            int n3 = virtualsContainerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                object2 = virtualsContainerArray2[n4];
                ((VirtualsContainer)object2).dispose();
                ++n4;
            }
        }
        this.a.onDisposed(this);
        if (this.a != null) {
            try {
                this.a.onDisposed((IAppSessionGyro)this);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)"Failed focus provider dispose", (Throwable)throwable);
            }
        }
        if ((object2 = (Object)this.a) != null) {
            object2.dispose();
        }
        this.a.getServerProperties().getServerSettings().onApplicationSessionStopped(this);
        WSFileProvider wSFileProvider = this.a;
        if (wSFileProvider != null) {
            wSFileProvider.disposeNoThrow(true);
        }
        boolean bl = this.b;
        synchronized (bl) {
            this.b.clear();
        }
        return true;
    }

    public boolean isDisposed() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PropCnr> VirtualsContainer<T> getVirtuals(IPluginDescriptor<T> iPluginDescriptor) {
        if (this.a) {
            return null;
        }
        String string = iPluginDescriptor.getServerID();
        if (string == null) {
            throw new NullPointerException("No Server ID for plug-in");
        }
        long l = this.a;
        synchronized (l) {
            VirtualsContainer virtualsContainer = (VirtualsContainer)this.a.get(string);
            if (virtualsContainer != null) {
                String string2 = iPluginDescriptor.getModuleDirectory();
                virtualsContainer = new VirtualsContainer(string2, Atom.get((String)string2), iPluginDescriptor.getPropertyClass(), this.a.getPropertyManager(), null, this, true);
                this.a.put(string, virtualsContainer);
            }
            return virtualsContainer;
        }
    }

    public ServerShell getServer() {
        return this.a;
    }

    public SessionInfo getAppSessionInfo() {
        return this.a;
    }

    public VirtualThreadGroup getAppThreadGroup() {
        return this.a;
    }

    @Override
    public EnvProps getEnvironment() {
        return this.a;
    }

    public ServerConfigEnvProps getServerConfigurationEnvironment() {
        return this.a;
    }

    public IFocusEngine getFocusEngine(IFocusComp iFocusComp) {
        return iFocusComp instanceof IVSComponent ? this.a : null;
    }

    j a() {
        return this.a;
    }

    public long getCreationTime() {
        return this.a;
    }

    public String getAppID() {
        return this.a;
    }

    @Override
    public AppFactory getAppFactory() {
        return this.a;
    }

    public String getCustomAppValue(String string) {
        String string2 = this.a.getCustomAppValue(string);
        return string2 != null ? string2 : this.a.getModuleProjects()[0].getSettings().getCustomAppValue(string);
    }

    public ITXPCoordinator getTransactionCoordinator() {
        return ServerShell.getInstance().getTXPCoordinator();
    }

    public IVirtualsContainer<VirtualSpace> getVirtualSpaceVirtualsContainer() {
        return this.a;
    }

    public SessionUserIdentifier getSessionUserIdentifier() {
        return this.a;
    }

    public AuthenticatedUser getAuthenticatedUser() {
        return this.a;
    }

    public SigninResult changeExternallyAuthenticatedUser(AuthenticatedUser authenticatedUser) {
        if (authenticatedUser == null) {
            throw new NullPointerException("authUser is null");
        }
        this.a = authenticatedUser;
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        if (clientSessionGyroArray.length != 1) {
            ILog.SEVERE(this.getClass(), (String)("changeAuthenticatedUser, new user ID \"" + authenticatedUser.userName + "\" called with ClientSessionGyro.length = " + clientSessionGyroArray.length), (Throwable)new Exception("Stack Trace"));
            this.dispose();
            return SigninResult.USER_DISABLED;
        }
        clientSessionGyroArray[0].a.assignAuthenticatedUser(authenticatedUser.userName, authenticatedUser.getBasicUserInfo().getPasswordHash());
        return SigninResult.SUCCESS;
    }

    public AppPropCnr getAppPropCnr() {
        return this.a;
    }

    @Override
    public GProp<?> getVirtualizedPropFromReference(String string) {
        return this.a.getVirtualizedPropFromReference(string);
    }

    @Override
    public GProp<?> getRuntimePropFromReference(String string) {
        return this.getRuntimePropFromReference(string, false);
    }

    @Override
    public GProp<?> getRuntimePropFromReference(String string, boolean bl) {
        GProp<?> gProp;
        if (!(string.indexOf(":/vs/") <= 0 || (gProp = this.a.getVirtualizedPropFromReference(string)) == null && bl)) {
            return gProp;
        }
        return this.a.getRuntimePropFromReference(string, bl);
    }

    @Override
    public PropCnr getRootFromName(GProp<?> gProp, String string) {
        return this.a.getRootFromName((GProp)gProp, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSessionGyro createClientSessionGyro(ClientEndPoint clientEndPoint, Worker worker, EnvProps envProps) {
        envProps.setString("appSessionID", this.a.getUUIDString());
        SessionInfo sessionInfo = clientEndPoint.getSessionInfo();
        sessionInfo.setPrivateData(STORAGE_NAME, (Object)this);
        ClientSessionGyro clientSessionGyro = null;
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (!this.a) {
                clientSessionGyro = new ClientSessionGyro(clientEndPoint, this, worker, envProps);
                sessionInfo.setPrivateData(IClientSessionGyro.STORAGE_NAME, (Object)clientSessionGyro);
                long l = this.a;
                synchronized (l) {
                    this.a.add(clientSessionGyro);
                    this.a = null;
                }
                if (this.a != null) {
                    this.a.cancel();
                    this.a = null;
                }
            }
        }
        return clientSessionGyro;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(ClientSessionGyro clientSessionGyro) {
        boolean bl;
        long l = this.a;
        synchronized (l) {
            if (!this.a.remove(clientSessionGyro)) {
                ILog.SEVERE(this.getClass(), (String)"Client session gyro removed, but was not found", (Object[])new Object[]{"AppSessionGyro = " + String.valueOf(this), "ClientSessionGyro = " + String.valueOf(clientSessionGyro)});
                return;
            }
            this.a = null;
            bl = this.a.isEmpty();
        }
        this.a.a(clientSessionGyro);
        if (bl) {
            long l2 = this.a.getAppTimeout();
            if (l2 > 0L) {
                AppSessionGyro appSessionGyro = this;
                synchronized (appSessionGyro) {
                    if (this.a != null) {
                        this.a.cancel();
                    }
                    this.a = this.getApplicationTimerEngine().registerTimeout(l2, "App timeout", () -> this.b());
                }
            } else {
                this.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (!this.a.isEmpty()) {
                return;
            }
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientSessionGyro[] getClientSessionGyros() {
        ClientSessionGyro[] clientSessionGyroArray = this.a;
        if (clientSessionGyroArray == null) {
            long l = this.a;
            synchronized (l) {
                clientSessionGyroArray = this.a.toArray(new ClientSessionGyro[this.a.size()]);
                this.a = clientSessionGyroArray;
            }
        }
        return clientSessionGyroArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientSessionsCount() {
        long l = this.a;
        synchronized (l) {
            return this.a.size();
        }
    }

    public String toString() {
        String string = "AppSessionGyro[user=" + String.valueOf(this.a) + ",appID=" + this.a + ",sessionCount=" + this.getClientSessionsCount() + ",created=" + Utilities.formatDate((long)this.a);
        if (this.a) {
            string = string + ",disposed";
        }
        return string;
    }

    public boolean initialize(EnvProps envProps, ClientSessionGyro clientSessionGyro) {
        Object object;
        if (this.a != null) {
            this.b(clientSessionGyro);
            clientSessionGyro.a(true, true);
            if (!this.isUILocked()) {
                clientSessionGyro.setReady();
            }
            this.c(clientSessionGyro);
            return true;
        }
        this.a = envProps;
        IVSComponent iVSComponent = null;
        if (this.a != null) {
            try {
                iVSComponent = this.a.getInitialVSFocus((IAppSessionGyro)this, (IClientSessionGyro)clientSessionGyro);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)"Failed focus provider initial focus retrieval, going for default", (Throwable)throwable);
            }
        }
        if (iVSComponent == null) {
            ModuleProjectPropCnr[] moduleProjectPropCnrArray = this.a.getModuleProjects();
            int n = moduleProjectPropCnrArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = moduleProjectPropCnrArray[n2];
                ModuleApp moduleApp = object.getSettings().getModuleApp();
                if (moduleApp.isSelectorSelected(envProps)) {
                    iVSComponent = moduleApp.getInitialVSComponent();
                    if (iVSComponent != null) break;
                    ILog.SEVERE(this.getClass(), (String)("Selected project '" + object.getPropName() + "' in application '" + this.a + "' for Client does not specify an initial focus"));
                    return false;
                }
                ++n2;
            }
        }
        if (iVSComponent != null) {
            this.b(clientSessionGyro);
            object = this.getVirtualizedVSComponent(iVSComponent);
            this.a.a((IFocusComp)object, null, false, true);
            if (!this.isUILocked()) {
                clientSessionGyro.setReady();
            }
            this.c(clientSessionGyro);
            return true;
        }
        ILog.SEVERE(this.getClass(), (String)("No selected project in application '" + this.a + "' for Client"));
        return false;
    }

    private void b(ClientSessionGyro clientSessionGyro) {
        List<PreloadClientCacheResource> list = this.a.getPreloadClientCacheResources(clientSessionGyro);
        clientSessionGyro.a(list);
        ClientTransactionProcessor clientTransactionProcessor = clientSessionGyro.getClientEndPoint().getTransactionProcessor();
        IPropMgrInfoProvider iPropMgrInfoProvider = clientSessionGyro.getKStringInfoProvider();
        ModuleProjectPropCnr[] moduleProjectPropCnrArray = this.a.getModuleProjects();
        int n = moduleProjectPropCnrArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleProjectPropCnr moduleProjectPropCnr = moduleProjectPropCnrArray[n2];
            moduleProjectPropCnr.getSettings().getModuleApp().sendCustomCSS(iPropMgrInfoProvider, (ITransactionCreator)clientTransactionProcessor, (ITransactionSender)clientTransactionProcessor);
            ++n2;
        }
    }

    IAppSessionFocusProvider a() {
        return this.a;
    }

    public boolean isVirtualized(VirtualSpace virtualSpace) {
        if (virtualSpace.isPropVirtualized()) {
            return true;
        }
        VirtualizedItem<PROPCNR>[] virtualizedItemArray = this.a.getVirtualizedItems();
        int n = virtualizedItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualizedItem virtualizedItem = virtualizedItemArray[n2];
            if (virtualizedItem.originalProperty == virtualSpace) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualSpace getVirtualizedVirtualSpace(VirtualSpace virtualSpace, boolean bl) {
        if (virtualSpace.isPropVirtualized()) {
            return virtualSpace;
        }
        Object object = this.a;
        synchronized (object) {
            Object object2;
            VirtualizedItem<PROPCNR>[] virtualizedItemArray = this.a.getVirtualizedItems();
            int n = virtualizedItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = virtualizedItemArray[n2];
                if (object2.originalProperty == virtualSpace) {
                    return (VirtualSpace)object2.virtualizedProperty;
                }
                ++n2;
            }
            object2 = virtualSpace.virtualize((IAppSessionGyro)this);
            this.a.addVirtualInstance(this, null, virtualSpace, object2, virtualSpace);
            virtualSpace.getParticipantsHolder().onVirtualSpaceVirtualized(object2, (IAppSessionGyro)this);
            return object2;
        }
    }

    public IVSComponent getVirtualizedVSComponent(IVSComponent iVSComponent) {
        if (iVSComponent == null || iVSComponent.isPropVirtualized()) {
            return iVSComponent;
        }
        if (iVSComponent instanceof VirtualSpace) {
            VirtualSpace virtualSpace = (VirtualSpace)iVSComponent;
            return this.getVirtualizedVirtualSpace(virtualSpace, true);
        }
        if (iVSComponent instanceof VSComponent) {
            VSComponent vSComponent = (VSComponent)iVSComponent;
            return this.getVirtualizedVSComponent(vSComponent);
        }
        return null;
    }

    public <VSC extends VSComponent> VSC getVirtualizedVSComponent(VSC VSC) {
        VirtualSpace virtualSpace;
        Atom[] atomArray;
        if (VSC == null || VSC.isPropVirtualized()) {
            return VSC;
        }
        VirtualSpace virtualSpace2 = VSC.getVirtualSpace();
        if (virtualSpace2 != null && !virtualSpace2.isPropVirtualized() && (atomArray = VSC.getAtomPath((PropCnr)virtualSpace2)) != null && (virtualSpace = this.getVirtualizedVirtualSpace(virtualSpace2, true)) != null) {
            GProp gProp = virtualSpace.getProp(atomArray);
            if (VSC.getClass().isInstance(gProp)) {
                return (VSC)((VSComponent)gProp);
            }
        }
        return VSC;
    }

    @Override
    public void onFocusVetoChange(FocusEvent focusEvent) throws FocusVetoException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFocusChanged(IFocusComp iFocusComp, IFocusComp iFocusComp2, IGProp<?> iGProp, boolean bl, boolean bl2) {
        if (iFocusComp instanceof IVSComponent) {
            IVSComponent iVSComponent = (IVSComponent)iFocusComp;
            VirtualSpace virtualSpace = iVSComponent.getVirtualSpace();
            boolean bl3 = false;
            IVirtualizedReferenceLookup iVirtualizedReferenceLookup = this;
            synchronized (iVirtualizedReferenceLookup) {
                if (virtualSpace != this.a) {
                    this.a = virtualSpace;
                    bl3 = true;
                }
                if (this.isUILocked()) {
                    this.c = true;
                    this.a = iVSComponent;
                    this.a = (long)iGProp;
                    this.d |= bl3;
                    return;
                }
            }
            ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
            int n = clientSessionGyroArray.length;
            int n2 = 0;
            while (n2 < n) {
                iVirtualizedReferenceLookup = clientSessionGyroArray[n2];
                ((ClientSessionGyro)iVirtualizedReferenceLookup).a(iVSComponent, bl3, iGProp, false);
                ++n2;
            }
        }
    }

    public IVSComponent getCurrentFocus() {
        IVSComponent iVSComponent = this.a.getCurrentFocusFallback();
        return iVSComponent != null && !iVSComponent.isDisposed() ? iVSComponent : null;
    }

    public String setVirtualizeSupportFocus(IVSComponent iVSComponent) {
        return this.a(iVSComponent, null, false);
    }

    public String setVirtualizeSupportFocus(IVSComponent iVSComponent, IGProp<?> iGProp) {
        return this.a(iVSComponent, iGProp, false);
    }

    String a(IVSComponent iVSComponent, IGProp<?> iGProp, boolean bl) {
        VirtualSpace virtualSpace = iVSComponent.getVirtualSpace();
        if (virtualSpace != null && virtualSpace.isPropVirtualized()) {
            return this.b(iVSComponent, iGProp, bl);
        }
        if (iVSComponent instanceof VirtualSpace) {
            VirtualSpace virtualSpace2 = (VirtualSpace)iVSComponent;
            virtualSpace = this.getVirtualizedVirtualSpace(virtualSpace2, true);
            return this.b((IVSComponent)virtualSpace, iGProp, bl);
        }
        VSComponent vSComponent = this.getVirtualizedVSComponent((VSComponent)iVSComponent);
        if (vSComponent == null) {
            return "Virtualized VS component not found: " + iVSComponent.getReferencePropName();
        }
        return this.b((IVSComponent)vSComponent, null, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String b(IVSComponent iVSComponent, IGProp<?> iGProp, boolean bl) {
        String string = iVSComponent.canRequestFocus();
        if (string != null) {
            return string;
        }
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (this.isUILocked()) {
                this.e = bl;
            }
        }
        try {
            iVSComponent.requestFocusEx();
            return null;
        }
        catch (FocusException focusException) {
            return focusException.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    boolean a(boolean n) {
        boolean bl;
        int n2;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        IVSComponent iVSComponent = null;
        Object var5_5 = null;
        KString kString = null;
        int n4 = -2;
        int n5 = -1;
        boolean bl4 = false;
        IVirtualizedReferenceLookup iVirtualizedReferenceLookup = this;
        synchronized (iVirtualizedReferenceLookup) {
            n3 = this.isUILocked();
            this.b = n;
            int n6 = this.isUILocked();
            n = n6;
            n2 = n6;
            bl = n2 ^ n3;
            if (n2 != 0) {
                boolean bl5 = !(this.a != null ? !this.a.equals((Object)this.b) : this.b != null) || this.b != this.c || this.d != this.e ? false : (bl4 = true);
                if (!bl4 && !bl) {
                    return false;
                }
                kString = this.b = this.a;
                n4 = this.c = this.b;
                n5 = this.e = this.d;
            } else {
                if (!bl) {
                    return false;
                }
                if (this.c) {
                    if (this.c) {
                        iVSComponent = this.a;
                        long l = this.a;
                        bl3 = this.e && iVSComponent != null;
                        bl2 = this.d;
                    }
                    this.a = null;
                    this.a = (long)null;
                    this.e = false;
                    bl2 = false;
                    this.a = null;
                    this.b = null;
                    this.b = -2;
                    this.c = -2;
                    this.d = -1;
                    this.e = -1;
                }
            }
        }
        if (!bl && bl4) {
            ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
            n2 = clientSessionGyroArray.length;
            n3 = 0;
            while (n3 < n2) {
                iVirtualizedReferenceLookup = clientSessionGyroArray[n3];
                ((ClientSessionGyro)iVirtualizedReferenceLookup).a(n != 0, bl3, kString, n4, n5);
                ++n3;
            }
            return true;
        }
        if (bl3) {
            this.a.a();
        }
        try {
            ClientSessionGyro[] clientSessionGyroArray;
            if (iVSComponent != null) {
                clientSessionGyroArray = this.getClientSessionGyros();
                n2 = clientSessionGyroArray.length;
                n3 = 0;
                while (n3 < n2) {
                    void var5_7;
                    iVirtualizedReferenceLookup = clientSessionGyroArray[n3];
                    ((ClientSessionGyro)iVirtualizedReferenceLookup).a(iVSComponent, bl2, (IGProp<?>)var5_7, n != 0);
                    ++n3;
                }
            }
            clientSessionGyroArray = this.getClientSessionGyros();
            n2 = clientSessionGyroArray.length;
            n3 = 0;
            while (n3 < n2) {
                iVirtualizedReferenceLookup = clientSessionGyroArray[n3];
                ((ClientSessionGyro)iVirtualizedReferenceLookup).a(n != 0, bl3, kString, n4, n5);
                ++n3;
            }
        }
        finally {
            if (bl3) {
                this.a.b();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITimerEngine getApplicationTimerEngine() {
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (this.a == null) {
                this.a = TimerEngine.newInstance();
            }
            return this.a;
        }
    }

    public Worker getAppWorker() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getPrivateStorageMap() {
        Object object = this.a;
        if (object == null) {
            AppSessionGyro appSessionGyro = this;
            synchronized (appSessionGyro) {
                object = this.a;
                if (object == null) {
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                    this.a = (long)concurrentHashMap;
                    object = concurrentHashMap;
                }
            }
        }
        return object;
    }

    public ILockState requestUILock() {
        this.incrementUILock();
        return new h(this);
    }

    public boolean isUILocked() {
        return this.b || this.a > 0;
    }

    public boolean lockUI(KString kString, ProgressIndicatorDelay progressIndicatorDelay) {
        return this.lockUI(kString, progressIndicatorDelay.delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockUI(KString kString, int n) {
        if (n < -2 || n > 20000) {
            throw new IllegalArgumentException("Illegal delay (-2 to 20000): " + n);
        }
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            block5: {
                if (this.a <= 0 || this.b != n || !(kString != null ? kString.equals((Object)this.a) : this.a == null)) break block5;
                return false;
            }
            this.a = kString;
            this.b = n;
        }
        return this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unlockUI() {
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            block4: {
                if (this.a <= 0) break block4;
                return false;
            }
        }
        return this.a(false);
    }

    public synchronized int getLockCount() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int incrementUILock() {
        int n;
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            n = ++this.a;
        }
        if (n == 1) {
            this.a(true);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decrementUILock() {
        int n;
        boolean bl;
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            boolean bl2 = bl = this.a > 0;
            if (bl) {
                --this.a;
            }
            n = this.a;
        }
        if (bl) {
            if (n == 0) {
                this.unlockUI();
            }
        } else {
            ILog.WARNING(this.getClass(), (String)"Too many calls made to AppSessionGyro.decrementUILock()", (Throwable)new Exception("Stack"));
        }
        return n;
    }

    public boolean setLockMessage(KString kString) {
        return this.setLockMessage(kString, this.b, this.d);
    }

    public boolean setLockMessage(KString kString, int n) {
        return this.setLockMessage(kString, this.b, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setLockMessage(KString kString, int n, int n2) {
        if (n < -2 || n > 20000) {
            throw new IllegalArgumentException("Illegal delay (-2 to 20000): " + n);
        }
        if (n2 < -1 || n2 > 100) {
            throw new IllegalArgumentException("progress range error (-1 to 100): " + n2);
        }
        IVirtualizedReferenceLookup iVirtualizedReferenceLookup = this;
        synchronized (iVirtualizedReferenceLookup) {
            block7: {
                if (this.isUILocked() && n != this.b && n2 != this.d && !(kString != null ? kString.equals((Object)this.a) : this.a == null)) break block7;
                return false;
            }
            this.d = n2;
            this.a = kString;
            this.b = n;
        }
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n3 = clientSessionGyroArray.length;
        int n4 = 0;
        while (n4 < n3) {
            iVirtualizedReferenceLookup = clientSessionGyroArray[n4];
            ((ClientSessionGyro)iVirtualizedReferenceLookup).a(true, false, kString, n, n2);
            ++n4;
        }
        return true;
    }

    public boolean setLockProgress(int n) {
        return this.setLockMessage(this.a, this.b, n);
    }

    public IAppHistory getAppHistory() {
        return this.a;
    }

    public String getLanguageCode() {
        String string = this.b;
        if (string == null) {
            string = this.a.getLanguageCode();
            if (string == null) {
                string = "en";
            }
            this.b = string;
        }
        return string;
    }

    public IKStringInfoProvider getAppKStringInfoProvider() {
        return this.a;
    }

    public IKStringInfoProvider getKStringInfoProvider() {
        return this.a;
    }

    public LocaleInfo getLocale() {
        return this.a.getLocale();
    }

    public LocaleInfo setLocale(LocaleInfo localeInfo) {
        try {
            LocaleInfo localeInfo2 = this.a.setLocale(localeInfo);
            return localeInfo2;
        }
        catch (PropTypeException propTypeException) {
            ILog.SEVERE(this.getClass(), (String)"Failed setLocale", (Object[])new Object[]{"Locale = " + String.valueOf(localeInfo), propTypeException});
            return localeInfo;
        }
    }

    public KString getLocaleKString(String string, boolean bl) {
        return this.a(string, bl, this.getLanguageCode());
    }

    KString a(String string, boolean bl, String string2) {
        return null;
    }

    public synchronized PrettyLocaledTexts getPrettyLocaledTexts() {
        if (this.a == null) {
            this.a = new PrettyLocaledTexts((ILocaleString)this);
        }
        return this.a;
    }

    public synchronized WSFileProvider getAppSessionFileProvider() throws IOException {
        if (this.a) {
            throw new IllegalStateException("Application session is disposed of");
        }
        if (this.a == null) {
            String string = this.a.getConnectionIDString();
            String string2 = "AppSession ID " + string;
            SessionUserIdentifier sessionUserIdentifier = this.a.user;
            if (sessionUserIdentifier != null) {
                string2 = string2 + ", user ID " + sessionUserIdentifier.getUserID();
            }
            this.a = this.a.getFileProviderEngine().getCreateFileProvider(URNResourceType.APP_SESSION, string2, string, null, false, this.a.getServerSettings());
        }
        return this.a;
    }

    public IOAuthCallbackProvider requestOAuthCallbackDisplay(IOAuthService iOAuthService) {
        a a2 = new a(iOAuthService);
        this.a(a2);
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(a a2) {
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (this.b == null) {
                this.b = new ArrayList();
            }
            this.b.add(a2);
        }
    }

    private void a(IOAuthService iOAuthService, String string) {
        Size size = iOAuthService.getApproximateSize();
        WindowOptions windowOptions = size != null ? new WindowOptions(size.width, size.height) : new WindowOptions();
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            clientSessionGyro.a.triggerRemoteOpenWindow(string, null, windowOptions, bl -> {
                if (bl) {
                    iOAuthService.disposeBlocked();
                } else {
                    iOAuthService.dispose();
                }
            });
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(a a2) {
        AppSessionGyro appSessionGyro = this;
        synchronized (appSessionGyro) {
            if (this.b != null && !this.b.remove(a2)) {
                ILog.WARNING(this.getClass(), (String)"An authentication callback provider was not found to be disposed of");
                return;
            }
        }
        this.closeAuthenticationWindows();
    }

    public void closeAuthenticationWindows() {
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n = clientSessionGyroArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n2];
            clientSessionGyro.a.triggerRemoteCloseWindow(false);
            ++n2;
        }
    }

    void a() {
        this.c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        boolean bl;
        Object object2 = this;
        synchronized (object2) {
            if (this.b == null) {
                return;
            }
            bl = this.b;
            this.b = null;
        }
        for (Object object2 : bl) {
            ((a)object2).a.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeImageDefinition getImage(String string) {
        boolean bl = this.b;
        synchronized (bl) {
            return (RuntimeImageDefinition)this.b.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setImage(RuntimeImageDefinition runtimeImageDefinition) {
        boolean bl = this.b;
        synchronized (bl) {
            RuntimeImageDefinition runtimeImageDefinition2 = this.b.put(runtimeImageDefinition.name, runtimeImageDefinition);
            return runtimeImageDefinition2 != runtimeImageDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeImage(String string) {
        boolean bl = this.b;
        synchronized (bl) {
            RuntimeImageDefinition runtimeImageDefinition = (RuntimeImageDefinition)this.b.remove(string);
            return runtimeImageDefinition != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImageCache() {
        boolean bl = this.b;
        synchronized (bl) {
            this.b.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageBox(IMessageBoxReply iMessageBoxReply, IMessageBox.Icon icon, KString kString, KString kString2, KString ... kStringArray) {
        if (this.a) {
            throw new IllegalStateException("Session is disposed of");
        }
        MessageBox messageBox = new MessageBox();
        IMessageBoxReply iMessageBoxReply2 = n -> this.a(messageBox, iMessageBoxReply, n);
        messageBox.messageBox(iMessageBoxReply2, icon, kString, kString2, kStringArray);
        Object object = this.c;
        synchronized (object) {
            this.c.add(messageBox);
        }
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = clientSessionGyroArray[n3];
            ((ClientSessionGyro)object).b(messageBox);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(MessageBox messageBox, IMessageBoxReply iMessageBoxReply, int n) {
        if (this.isDisposed()) {
            return;
        }
        Object object = this.c;
        synchronized (object) {
            if (!this.c.remove(messageBox)) {
                return;
            }
        }
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = clientSessionGyroArray[n3];
            ((ClientSessionGyro)object).a(messageBox);
            ++n3;
        }
        if (n != -2) {
            this.a.post(() -> {
                if (!this.isDisposed() && iMessageBoxReply != null) {
                    try {
                        iMessageBoxReply.onMessageBoxReply(n);
                    }
                    catch (Throwable throwable) {
                        ILog.SEVERE(ClientSessionGyro.class, (String)"Failed invoking onMessageBoxReply", (Throwable)throwable);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c(ClientSessionGyro clientSessionGyro) {
        MessageBox[] messageBoxArray;
        Object object = this.c;
        synchronized (object) {
            if (this.c.isEmpty()) {
                return;
            }
            messageBoxArray = this.c.toArray(new MessageBox[this.c.size()]);
        }
        MessageBox[] messageBoxArray2 = messageBoxArray;
        int n = messageBoxArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = messageBoxArray2[n2];
            clientSessionGyro.b((MessageBox)object);
            ++n2;
        }
    }

    public void toast(KString kString, IToaster.Position position, IToaster.Direction direction, IToaster.Type type, int n) {
        ClientSessionGyro[] clientSessionGyroArray = this.getClientSessionGyros();
        int n2 = clientSessionGyroArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
            clientSessionGyro.toast(kString, position, direction, type, n);
            ++n3;
        }
    }

    public synchronized ILocationService getLocationService() {
        if (this.a == null) {
            this.a = new c(this);
        }
        return this.a;
    }

    public String getAuthenticatedUserUUID() {
        AuthenticatedUser authenticatedUser = this.a;
        if (authenticatedUser == null || authenticatedUser.isUndefined()) {
            return null;
        }
        return authenticatedUser.getBasicUserInfo().id + "-" + authenticatedUser.getBasicUserInfo().getUUID();
    }

    public IUserAuthenticationUI getUserAuthenticationUI() {
        return this.a.getUserAuthenticationUI();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private class a
    implements IOAuthCallbackProvider {
        private final IOAuthService a;
        private String a;

        private a(IOAuthService iOAuthService) {
            this.a = iOAuthService;
        }

        public void display(IOAuthService iOAuthService, String string) {
            this.a = string;
            AppSessionGyro.this.a(iOAuthService, string);
        }

        public void dispose() {
            this.a = null;
            AppSessionGyro.this.b(this);
        }
    }
}

