/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.client;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.SessionInfo;
import com.iizix.Worker;
import com.iizix.comm.IClientTransactionProcessor;
import com.iizix.comm.session.SessionTransMgr;
import com.iizix.prop.ClientProps;
import com.iizix.prop.EnvProps;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.ui.UIContextMenu;
import com.iizix.server.Messages;
import com.iizix.server.ServerShell;
import com.iizix.server.WorkerThread;
import com.iizix.server.app.RuntimeApp;
import com.iizix.server.client.ClientEndPoint;
import com.iizix.server.client.ClientParams;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.prop.IRootPropTransactionSender;
import com.iizix.server.prop.RootPropTransactionSender;
import com.iizix.text.HTMLUtilities;
import com.iizix.text.ILocaleString;
import com.iizix.user.SigninResult;
import com.iizix.user.UserException;
import com.iizix.virtual.ThreadGroupType;
import com.iizix.virtual.VirtualThreadGroup;
import java.io.IOException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ClientTransactionProcessor
implements IClientTransactionProcessor,
IRootPropTransactionSender {
    private ClientEndPoint a;
    private final ClientParams a;
    private SessionTransMgr a;
    private WorkerThread a;
    private Worker a;
    private PropMgr a;
    private AppSessionGyro a;
    private RuntimeApp a;
    private ClientSessionGyro a;
    private ClientProps a;
    private RootPropTransactionSender a;
    private VirtualThreadGroup a;
    private SessionInfo a;
    private int a;
    private static volatile /* synthetic */ int[] a;

    ClientTransactionProcessor(ClientParams clientParams) {
        this.a = clientParams;
    }

    public ClientParams getClientParams() {
        return this.a;
    }

    void a(ClientEndPoint clientEndPoint, SessionTransMgr sessionTransMgr) {
        this.a = clientEndPoint;
        this.a = sessionTransMgr;
        if (this.a == null) {
            this.a = this.a.app.createPropMgr(clientEndPoint.getServer());
        }
    }

    private void a() throws IOException {
        assert (this.a == null) : "Worker is already defined!";
        SessionInfo sessionInfo = this.a.getSessionInfo();
        this.a = new Worker(sessionInfo);
        sessionInfo.setWorker(this.a);
        this.a = new WorkerThread(this.a, () -> this.a.dispose(true));
        ServerShell serverShell = this.a.getServer();
        AppSessionGyro appSessionGyro = serverShell.getActiveUserSessions().getAppSessionGyro(serverShell, this.a);
        if (appSessionGyro != null) {
            this.a = appSessionGyro.getAppThreadGroup();
            this.a = appSessionGyro.getAppSessionInfo();
        } else {
            this.a = new SessionInfo(null);
            this.a.user = this.a.user;
            this.a = new VirtualThreadGroup(ThreadGroupType.APP_SESSION, "iiziApp-Session-" + this.a.appID, this.a);
            this.a.setMaximumThreadPriority(7);
        }
        VirtualThreadGroup virtualThreadGroup = new VirtualThreadGroup(ThreadGroupType.CLIENT_SESSION, "iiziApp-JS-" + this.a.getServerSessionID(), sessionInfo, this.a.app.getCommonClassLoader());
        virtualThreadGroup.startThread((Runnable)this.a, "<worker>", 6);
        this.showMessageInClient(-1, "Starting App", "Configuring your device...");
    }

    public void onConnection(SessionTransMgr sessionTransMgr) {
        this.a = sessionTransMgr;
        try {
            this.a();
        }
        catch (IOException iOException) {
            ILog.SEVERE(this.getClass(), (String)"Failed creation of client end point", (Throwable)iOException);
            sessionTransMgr.dispose(true);
        }
    }

    public void onPause(SessionTransMgr sessionTransMgr) {
    }

    public void onReconnected(SessionTransMgr sessionTransMgr) {
        if (this.a != null) {
            this.a.postPropertiesUpdateEvent();
        }
    }

    public void onDisposed(SessionTransMgr sessionTransMgr) {
        ClientProps clientProps;
        if (this.a != null) {
            this.a.dispose();
        }
        if (this.a != null) {
            this.a.dispose();
        }
        if ((clientProps = this.a) != null) {
            clientProps.dispose();
        }
        if (this.a != null) {
            this.a.dispose();
        }
        if (this.a != null) {
            this.a.awaitExit();
        }
        this.a.dispose();
    }

    public void processTransaction(SessionTransMgr sessionTransMgr, ReadTransaction readTransaction) {
        int n = readTransaction.readByte();
        switch (n) {
            case 0: {
                this.a.readPropMgrData(readTransaction);
                break;
            }
            case 1: {
                ILog.log((int)ILog.mapJSLogLevelToJava((int)readTransaction.readByte()), (String)"<iiziApp-JS>", (String)readTransaction.readString());
                break;
            }
            case 3: {
                if (this.a == null) {
                    this.a(readTransaction);
                    break;
                }
                this.a.processUpdateTrans((PropCnr)this.a, readTransaction);
                break;
            }
            case 6: {
                this.a.processRemoveEvent(readTransaction);
                break;
            }
            case 9: {
                if (readTransaction.readBoolean()) {
                    this.a.enterClientLock(true);
                    break;
                }
                this.a.exitClientLock();
                break;
            }
            default: {
                ILog.SEVERE(this.getClass(), (String)("Invalid transaction code received. Code = " + n + "."));
            }
        }
    }

    private void a(ReadTransaction readTransaction) {
        SessionInfo sessionInfo = this.a.getSessionInfo();
        try {
            this.a = this.a.getServer().getActiveUserSessions().addUser(this.a.getServer(), this.a, this.a);
        }
        catch (UserException userException) {
            ILog.WARNING(this.getClass(), (String)("User was denied access to application, cause: " + userException.getMessage()), (Object[])new Object[]{"Client parameters = " + String.valueOf(this.a), "Session = " + String.valueOf(sessionInfo), userException});
            SigninResult signinResult = userException.getAuthenticationResult();
            String string = null;
            if (signinResult != null) {
                switch (ClientTransactionProcessor.a()[signinResult.ordinal()]) {
                    case 1: 
                    case 3: {
                        throw new InternalError("Shouldn't be", userException);
                    }
                    case 4: 
                    case 9: {
                        string = SigninResult.INVALID_USER_OR_PASSWORD.asString((ILocaleString)this.a);
                        break;
                    }
                    default: {
                        string = signinResult.englishMessage;
                    }
                }
                this.a.closeClientAuthenticationInfo(string);
                ClientProps clientProps = this.a;
                if (clientProps != null) {
                    clientProps.dispose();
                }
                return;
            }
            string = userException.getMessage();
            this.closeClient(HTMLUtilities.escapeTagValueString((String)string));
            return;
        }
        this.a = this.a.createRootContainer(readTransaction, this.a.app.getAppRoot().getModuleProjectPropProvider());
        this.a = new RootPropTransactionSender(this.a, (PropCnr)this.a, this.a, this);
        EnvProps envProps = this.a.getEnvironment();
        try {
            envProps.getServerEnv().addSystemProperties();
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), (String)"Failed to update environment", (Throwable)propException);
        }
        this.a = this.a.createClientSessionGyro(this.a, this.a, envProps);
        if (this.a == null) {
            this.closeClient(Messages.ClientAppSessionDisposed.asString((ILocaleString)this.a));
            return;
        }
        this.a = new RuntimeApp(sessionInfo, this.a.app, this.a, this.a, this.a, this.a.getVirtualSpaceVirtualsContainer());
        this.a.setApplication(this.a);
        this.a.flushUpdates();
        if (!this.a.initialize(envProps, this.a)) {
            this.closeClient(Messages.ClientUnsupportedDevice.asString((ILocaleString)this.a));
        }
    }

    public ClientProps getClientProps() {
        return this.a;
    }

    public SendTransaction createTransaction() {
        return this.a.createTransaction();
    }

    @Override
    public void sendTransaction(SendTransaction sendTransaction) {
        this.a.sendTransaction(sendTransaction);
    }

    public void postClientUpdate() {
        if (this.a != null) {
            this.a.postPropertiesUpdateEvent();
        }
    }

    @Override
    public boolean isConnected() {
        return this.a.isConnected();
    }

    public void restartRemoteClient() {
        SendTransaction sendTransaction = new SendTransaction();
        sendTransaction.appendByte(12);
        this.sendTransaction(sendTransaction);
    }

    public void showMessageInClient(int n, String string, String string2) {
        SendTransaction sendTransaction = new SendTransaction();
        sendTransaction.appendByte(126);
        sendTransaction.appendByte(n);
        sendTransaction.appendString(string);
        sendTransaction.appendString(string2);
        this.a.sendTransaction(sendTransaction);
    }

    public void closeClient(String string) {
        this.a.closeClient(string);
        ClientProps clientProps = this.a;
        if (clientProps != null) {
            clientProps.dispose();
        }
    }

    public void setBusy(boolean bl) {
        this.setBusy(bl, null, -2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(boolean bl, String string, int n, int n2) {
        int n3;
        ClientTransactionProcessor clientTransactionProcessor = this;
        synchronized (clientTransactionProcessor) {
            n3 = this.a = this.a + 1 & 0xFFFF;
        }
        clientTransactionProcessor = new SendTransaction();
        clientTransactionProcessor.appendByte(10);
        clientTransactionProcessor.appendUShort(n3);
        clientTransactionProcessor.appendBoolean(bl);
        if (bl) {
            clientTransactionProcessor.appendString(string != null ? string : "");
            clientTransactionProcessor.appendSigned(n);
            clientTransactionProcessor.appendByte(n2 + 1);
        }
        this.a.sendTransaction((SendTransaction)clientTransactionProcessor);
    }

    public synchronized int getLockSerial() {
        return this.a;
    }

    @Override
    public String getClientContextMenuReference(UIContextMenu uIContextMenu) {
        return this.a.getClientContextMenuReference(uIContextMenu);
    }

    public void appendPublicKey(SendTransaction sendTransaction) {
        this.a.appendPublicKey(sendTransaction);
    }

    public void updateAuthentication(ReadTransaction readTransaction) throws Exception {
        this.a.updatePassword(readTransaction);
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[SigninResult.values().length];
        try {
            nArray[SigninResult.APP_DISABLED.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.APP_ID_NOT_FOUND.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.INVALID_PASSWORD.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.INVALID_PASSWORD_NEXT_ATTEMPT_WILL_DISABLE.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.INVALID_USER.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.INVALID_USER_OR_PASSWORD.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SERVER_LOGIN_DISABLED.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SERVER_NOT_STARTED.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SERVER_STARTING.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SERVER_STOPPED.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SERVER_STOPPING.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SUCCESS_CHANGE_PASSWORD.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SUCCESS_NOT_SIGNED_IN.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.SYSTEM_FAILURE.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.TOO_MANY_INVALID_LOGINS_RETRY_LATER.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.TOO_MANY_INVALID_LOGINS_RETRY_LATER_NEXT_TIME_DISABLE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.USER_DISABLED.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SigninResult.USER_NAME_TAKEN.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

