/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop;

import com.iizigo.project.ProjectRootPropCnr;
import com.iizigo.quickfix.QuickFixer;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropErrorItem;
import com.iizix.prop.PropErrorItemOrigin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.PlatformUI;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PropMarker
implements Runnable {
    public static final String MARKER_ID_PROPERTY = "com.iizigo.moduleproblem.property";
    public static final String MARKER_ATTRIBUTE_PROPERTY_REFERENCE = "com.iizigo.propref";
    public static final String MARKER_ATTRIBUTE_CHILD_NAME = "com.iizigo.childName";
    public static final String MARKER_ATTRIBUTE_PROPERTY_INDEX = "com.iizigo.propref.index";
    private static b a = new ArrayList();
    private static final ArrayList<Runnable> a;
    private static final HashMap<String, Boolean> a;
    public final String markerID;
    public final int severity;
    public final String message;
    public final String location;
    public final String reference;
    public final int index;
    public final int start;
    public final int length;
    public final String[] quickFixIDs;
    public final String childError;
    private boolean a;
    private boolean b;
    private IResource a;
    private Long a;

    static {
        a = new HashMap();
        PropMarker.registerMarker("com.iizigo.moduleproblem.resourcename", true);
        PropMarker.registerMarker("com.iizigo.moduleproblem.loadfile", false);
        PropMarker.registerMarker(MARKER_ID_PROPERTY, false);
    }

    public static GProp<?> getProperty(IMarker iMarker) {
        IResource iResource = iMarker.getResource();
        String string = iMarker.getAttribute(MARKER_ATTRIBUTE_PROPERTY_REFERENCE, null);
        if (string == null) {
            ILog.SEVERE(PropMarker.class, (String)("Resource '" + iResource.getName() + "' marker does not have the attribute 'com.iizigo.propref' set"));
            return null;
        }
        return ProjectRootPropCnr.getAnyPropFromReference(iResource, string);
    }

    public static void registerMarker(String string, boolean bl) {
        ((HashMap)((Object)a)).put(string, bl);
    }

    private static boolean a(String string) {
        Boolean bl = (Boolean)((HashMap)((Object)a)).get(string);
        return bl != null && bl != false;
    }

    public static void deleteMarkers(IResource iResource, String string) throws CoreException {
        if (string != null) {
            iResource.deleteMarkers(string, false, 0);
        } else {
            for (String string2 : ((HashMap)((Object)a)).keySet()) {
                iResource.deleteMarkers(string2, false, 0);
            }
        }
    }

    public static void deleteAllMarkers(IResource iResource) {
        PropMarker.deleteAllMarkers(iResource, null, true, 0, null);
    }

    public static void deleteAllMarkers(IResource iResource, String string, boolean bl, int n2, Runnable runnable) {
        IMarker[] iMarkerArray = null;
        if (iResource.isAccessible()) {
            try {
                iMarkerArray = iResource.findMarkers(string, bl, n2);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (iMarkerArray != null && iMarkerArray.length > 0) {
            try {
                iResource.deleteMarkers(string, bl, n2);
                if (runnable != null) {
                    runnable.run();
                }
            }
            catch (CoreException coreException) {
                PropMarker.a(() -> {
                    try {
                        iResource.deleteMarkers(string, bl, n2);
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                    catch (CoreException coreException) {
                        ILog.SEVERE(PropMarker.class, (String)("Failed deleting markers for resource " + String.valueOf(iResource.getFullPath())), (Object[])new Object[]{"type=" + string, "includeSubtypes=" + bl, "depth=" + n2, coreException});
                    }
                });
            }
        }
    }

    private static synchronized void a(Runnable runnable) {
        ((ArrayList)((Object)a)).add(runnable);
        if (a == null) {
            a = new b();
            a.schedule(1000L);
        }
    }

    private static synchronized void b(Runnable runnable) {
        ((ArrayList)((Object)a)).remove(runnable);
        if (((ArrayList)((Object)a)).isEmpty()) {
            if (a != null) {
                a.cancel();
            }
            a = null;
        }
    }

    private static synchronized Runnable a() {
        if (((ArrayList)((Object)a)).isEmpty()) {
            a = null;
            return null;
        }
        return (Runnable)((ArrayList)((Object)a)).remove(0);
    }

    private static synchronized void a() {
        a = null;
    }

    public PropMarker(String string, boolean bl, String string2, String string3, String ... stringArray) {
        this.markerID = string;
        this.severity = bl ? 2 : 1;
        this.message = string2;
        this.location = string3;
        this.quickFixIDs = stringArray;
        this.childError = null;
        this.reference = null;
        this.index = -1;
        this.length = -1;
        this.start = -1;
    }

    public PropMarker(String string, boolean bl, String string2, int n2, int n3, String ... stringArray) {
        this.markerID = string;
        this.severity = bl ? 2 : 1;
        this.message = string2;
        this.start = n2;
        this.length = n3;
        this.quickFixIDs = stringArray;
        this.reference = null;
        this.index = -1;
        this.location = null;
        this.childError = null;
        this.b = true;
    }

    public PropMarker(PropErrorItemOrigin propErrorItemOrigin) {
        IPropErrorItem iPropErrorItem = propErrorItemOrigin.errorItem;
        this.markerID = MARKER_ID_PROPERTY;
        this.severity = iPropErrorItem.getSeverity();
        this.message = iPropErrorItem.getMessage();
        this.index = iPropErrorItem.getIndex();
        this.reference = propErrorItemOrigin.reference;
        this.childError = iPropErrorItem.getChildPropName();
        this.location = iPropErrorItem.getLocationOrName();
        this.quickFixIDs = iPropErrorItem.getQuickFixes();
        this.length = -1;
        this.start = -1;
        this.b = true;
    }

    public synchronized boolean createMarker(IResource iResource) {
        block5: {
            try {
                if (iResource != null && iResource.isAccessible()) break block5;
                return false;
            }
            catch (CoreException coreException) {
                ILog.SEVERE(PropMarker.class, (String)("Failed getting markers for resource " + String.valueOf(iResource.getFullPath())), (Throwable)coreException);
                return false;
            }
        }
        this.a = iResource;
        if (this.b) {
            return this.a();
        }
        IMarker[] iMarkerArray = iResource.findMarkers(this.markerID, false, 0);
        if (iMarkerArray.length == 0) {
            return this.a();
        }
        this.a = iMarkerArray[0].getId();
        return true;
    }

    private boolean a() {
        try {
            this.a(true);
            return true;
        }
        catch (CoreException coreException) {
            PropMarker.a(this);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            PropMarker propMarker = this;
            synchronized (propMarker) {
                if (!this.a && this.a.isAccessible()) {
                    this.a(false);
                }
            }
        }
        catch (CoreException coreException) {
            ILog.WARNING(PropMarker.class, (String)("Failed creating marker to resource " + String.valueOf(this.a.getFullPath())), (Throwable)coreException);
        }
    }

    private void a(boolean bl) throws CoreException {
        String string;
        IMarker iMarker = this.a.createMarker(this.markerID);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("message", this.message);
        hashMap.put("severity", this.severity);
        if (!PropMarker.a(this.markerID)) {
            hashMap.put("transient", Boolean.TRUE);
        }
        if (this.location != null) {
            hashMap.put("location", this.location);
        }
        if (this.start >= 0) {
            hashMap.put("lineNumber", 0);
            hashMap.put("charStart", this.start);
            hashMap.put("charEnd", this.start + this.length);
        }
        if (this.reference != null) {
            hashMap.put(MARKER_ATTRIBUTE_PROPERTY_REFERENCE, this.reference);
            if (this.index >= 0) {
                hashMap.put(MARKER_ATTRIBUTE_PROPERTY_INDEX, this.index);
            }
            if (this.childError != null) {
                hashMap.put(MARKER_ATTRIBUTE_CHILD_NAME, this.childError);
            }
        }
        if (this.quickFixIDs != null && this.quickFixIDs.length > 0 && (string = QuickFixer.getMarkerAttribute(this.quickFixIDs)) != null) {
            hashMap.put(QuickFixer.ID, string);
        }
        iMarker.setAttributes(hashMap);
        this.a = iMarker.getId();
    }

    public synchronized void dispose(IResource iResource) {
        this.a = true;
        PropMarker.b(this);
        Long l2 = this.a;
        this.a = null;
        if (l2 != null && iResource != null && iResource.isAccessible()) {
            try {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                IMarker iMarker = iResource.findMarker(l2.longValue());
                if (iMarker != null) {
                    try {
                        iMarker.delete();
                        return;
                    }
                    catch (CoreException coreException) {
                        PropMarker.a(new a(iMarker));
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        String string = "@" + this.getClass().getName() + "[markerID=" + this.markerID + ",id=" + String.valueOf(this.a) + ",severity=" + this.severity + ",message=" + this.message + ",location=" + this.location + ",reference=" + this.reference + ",start=" + this.start + ",length=" + this.length;
        if (this.quickFixIDs != null && this.quickFixIDs.length > 0) {
            string = string + ",quickFixIDs=" + Arrays.toString(this.quickFixIDs).replace(" ", "");
        }
        return string + "]";
    }

    private static class a
    implements Runnable {
        private IMarker a;

        private a(IMarker iMarker) {
            this.a = iMarker;
        }

        @Override
        public void run() {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            try {
                if (this.a.exists() && this.a.getResource().isAccessible()) {
                    this.a.delete();
                }
            }
            catch (CoreException coreException) {
                ILog.SEVERE(PropMarker.class, (String)("Failed deleting marker " + String.valueOf(this.a.getResource().getFullPath())), (Throwable)coreException);
            }
        }
    }

    private static class b
    extends Job {
        private b() {
            super("Update resource markers");
            this.setPriority(10);
            this.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            while (true) {
                if (iProgressMonitor.isCanceled() || PlatformUI.getWorkbench().isClosing()) {
                    PropMarker.a();
                    return Status.CANCEL_STATUS;
                }
                Runnable runnable = PropMarker.a();
                if (runnable == null) {
                    return Status.OK_STATUS;
                }
                runnable.run();
            }
        }
    }
}

