/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.SessionInfo;
import com.iizix.Utilities;
import com.iizix.Worker;
import com.iizix.comm.TransactionComm;
import com.iizix.comm.TransactionCommListener;
import com.iizix.comm.client.IClientInstanceListener;
import com.iizix.event.EventListener;
import com.iizix.jetty.WebSocketClientEndPoint;
import com.iizix.jetty.d;
import com.iizix.prop.ClientProps;
import com.iizix.prop.IPropMgrOwner;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.virtual.VirtualThreads;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class JettyClientWebSocketInstance {
    private final IClientInstanceListener a;
    private final PropFactory a;
    private final String a;
    private final int a;
    private final boolean a;
    private final String b;
    private final URI a;
    private final SessionInfo a;
    private final Worker a;
    private boolean b;
    private int b = 8;
    private int c;
    private int d;
    private TransactionComm a;
    private PropMgr a;
    private ClientProps a;
    private boolean c = 80;
    private boolean d = 700;
    private WebSocketClientEndPoint a;
    private final TransactionCommListener a;
    private final Runnable a;
    private final EventListener a = gEvent -> {
        if (!gEvent.isRemoteInduced()) {
            this.b();
        }
    };
    private boolean e;

    public JettyClientWebSocketInstance(PropFactory propFactory, String string, int n, boolean bl, String string2, boolean bl2, IClientInstanceListener iClientInstanceListener) throws IOException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, CertificateException, KeyStoreException, NoSuchProviderException, IllegalArgumentException {
        if (propFactory == null) {
            throw new NullPointerException("propFactory is null");
        }
        this.b = bl2;
        this.a = propFactory;
        this.a = string;
        this.a = n;
        this.a = bl;
        this.b = string2;
        this.a = iClientInstanceListener;
        String string3 = bl ? "wss://" : "ws://";
        this.a = URI.create(string3 + string + ":" + n + string2);
        InetAddress inetAddress = InetAddress.getByName(string);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n);
        this.a = new SessionInfo((SocketAddress)inetSocketAddress);
        this.a.assignServerSessionID(SessionInfo.getNextID());
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            this.a.assignRemoteAddress((SocketAddress)inetSocketAddress, string.substring(n2 + 1), string.substring(0, n2), n, bl);
        } else {
            this.a.assignRemoteAddress((SocketAddress)inetSocketAddress, string, string, n, bl);
        }
        this.a = new Worker(this.a);
        this.a.setVerbose(bl2);
        VirtualThreads.getVirtualThreads().startThread(() -> this.a.process(), "Worker-" + String.valueOf(this.a));
    }

    public boolean isVerbose() {
        return this.b;
    }

    public void setVerbose(boolean bl) {
        this.b = bl;
        this.a.setVerbose(bl);
    }

    public void setWriteCacheParams(int n, int n2, int n3) {
        if (n3 == 0) {
            n = 0;
            n2 = 0;
        } else if (n2 <= n || n < 7 || n2 > 1024 || n3 < 10 || n3 > 2048) {
            throw new IllegalArgumentException("Arguments not valid");
        }
        this.b = n;
        this.c = n2;
        this.d = n3;
    }

    public boolean isConnected() {
        TransactionComm transactionComm = this.a;
        return transactionComm != null && transactionComm.isConnected();
    }

    public boolean isDisconnected() {
        return this.a == null;
    }

    public String getState() {
        TransactionComm transactionComm = this.a;
        if (transactionComm == null) {
            return "Disconnected";
        }
        if (transactionComm.isConnected()) {
            return "Connected";
        }
        if (this.c) {
            return "Disconnecting";
        }
        return "Connecting";
    }

    public void connect() throws IOException {
        this.connect(false);
    }

    public void connect(boolean bl) throws IOException {
        int n;
        TransactionComm transactionComm = this.a;
        if (transactionComm != null) {
            throw new IllegalStateException("Already connected");
        }
        if (this.b) {
            System.err.println("Connect " + String.valueOf(this) + " " + this.b + " @" + Utilities.formatCurrentDate());
        }
        this.a = this.a.createPropertyManager(n, (n = this.a.getProgramType()) == 1 ? null : (n == 0 ? this.a.createClientClassNameMap(false) : this.a.createEditorServerClassNameMap()));
        this.a.setOwner((IPropMgrOwner)new d(this));
        if (this.b) {
            System.err.println("Opened " + String.valueOf(this) + " " + this.b + " @" + Utilities.formatCurrentDate());
        }
        this.a = transactionComm = new TransactionComm(this.a, this.d, this.b, this.c, this.b);
        this.a = new WebSocketClientEndPoint(this.a, this.a, this.b, this.a, this.b, transactionComm);
        this.a.a(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispose() {
        JettyClientWebSocketInstance jettyClientWebSocketInstance = this;
        synchronized (jettyClientWebSocketInstance) {
            block5: {
                if (!this.d) break block5;
                return false;
            }
            this.d = true;
        }
        jettyClientWebSocketInstance = this.a;
        if (jettyClientWebSocketInstance != null) {
            jettyClientWebSocketInstance.close(1000, "Normal close");
        }
        this.a();
        return true;
    }

    private void a() {
        ClientProps clientProps = this.a;
        if (clientProps != null) {
            clientProps.removePropListener(this.a);
            clientProps.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        JettyClientWebSocketInstance jettyClientWebSocketInstance = this;
        synchronized (jettyClientWebSocketInstance) {
            if (this.e) {
                return;
            }
            this.e = true;
        }
        this.a.post(this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendBinaryData(int n, String string, byte[] byArray) throws IOException {
        TransactionComm transactionComm;
        JettyClientWebSocketInstance jettyClientWebSocketInstance = this;
        synchronized (jettyClientWebSocketInstance) {
            if (this.d) {
                throw new EOFException("Communication with License System is disposed of");
            }
            transactionComm = this.a;
            if (transactionComm == null) {
                throw new EOFException("Connection is closed");
            }
        }
        jettyClientWebSocketInstance = new SendTransaction();
        jettyClientWebSocketInstance.appendByte(11);
        jettyClientWebSocketInstance.appendLong(byArray.length);
        jettyClientWebSocketInstance.appendUnsigned(n);
        jettyClientWebSocketInstance.appendString(string);
        jettyClientWebSocketInstance.append(byArray);
        return transactionComm.send((SendTransaction)jettyClientWebSocketInstance, this.a.useWebSocketBinaryFrameCompression());
    }

    private void a(ReadTransaction readTransaction) {
        ReadTransaction readTransaction2;
        while ((readTransaction2 = readTransaction.readTransaction()) != null) {
            int n;
            int n2 = readTransaction2.readByte();
            if (this.b) {
                System.err.println("processTransaction: transaction code = " + n2 + " - " + this.getInfoString() + " @" + Utilities.formatCurrentDate());
            }
            switch (n2) {
                case 0: {
                    this.a.readPropMgrData(readTransaction2);
                    break;
                }
                case 3: {
                    this.a.processUpdateTrans((PropCnr)this.a, readTransaction2);
                    break;
                }
                case 6: {
                    this.a.processRemoveEvent(readTransaction2);
                    break;
                }
                case 11: {
                    n = readTransaction2.readLong();
                    int n3 = readTransaction2.readUnsigned();
                    String string = readTransaction2.readString();
                    byte[] byArray = readTransaction2.readBytes(n);
                    this.a.onBinaryData(n3, string, byArray);
                    break;
                }
                default: {
                    if (this.a.processTransaction(n2, readTransaction)) break;
                    ILog.SEVERE(this.getClass(), (String)("Unknown transaction code " + n2 + " - " + this.getInfoString()));
                }
            }
            if ((n = readTransaction2.getRemainingReadSize()) <= 0) continue;
            ILog.SEVERE(this.getClass(), (String)("Unread data size " + n + " in inbound transaction"));
        }
    }

    public SessionInfo getSessionInfo() {
        return this.a;
    }

    public String getInfoString() {
        return SessionInfo.getConnectionIDString((SessionInfo)this.a);
    }

    public String toString() {
        return SessionInfo.getConnectionIDString((SessionInfo)this.a);
    }
}

