/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Map;
import javax.crypto.spec.PBEKeySpec;
import org.eclipse.equinox.internal.security.auth.AuthPlugin;
import org.eclipse.equinox.internal.security.linux.GError;
import org.eclipse.equinox.internal.security.linux.GList;
import org.eclipse.equinox.internal.security.linux.LinuxPasswordProviderMessages;
import org.eclipse.equinox.internal.security.linux.SecretSchema;
import org.eclipse.equinox.internal.security.linux.SecretSchemaAttribute;
import org.eclipse.equinox.internal.security.linux.SecretSchemaFlags;
import org.eclipse.equinox.internal.security.storage.Base64;
import org.eclipse.equinox.internal.security.storage.provider.IValidatingPasswordProvider;
import org.eclipse.equinox.security.storage.provider.IPreferencesContainer;
import org.eclipse.equinox.security.storage.provider.PasswordProvider;

public class LinuxPasswordProvider
extends PasswordProvider
implements IValidatingPasswordProvider {
    private static final int PASSWORD_LENGTH = 64;
    private static final String SECRET_COLLECTION_DEFAULT = "default";
    private static final Map<String, Object> LIB_LOAD_OPTIONS = Map.of("open-flags", 4353);
    private final SecretSchema fEquinoxSchema = new SecretSchema("org.eclipse.equinox", SecretSchemaFlags.SECRET_SCHEMA_NONE, new SecretSchemaAttribute(null, 0));
    private LibSecret fLibSecret;
    private LibGio fLibGio;

    private void unlockSecretService() {
        this.fLibGio = (LibGio)Native.load((String)"gio-2.0", LibGio.class, LIB_LOAD_OPTIONS);
        PointerByReference gerror = new PointerByReference();
        gerror.setValue(Pointer.NULL);
        this.fLibGio.g_bus_get_sync(2, Pointer.NULL, gerror);
        this.requireNoError(gerror, "Unable to get DBus session bus: ");
        this.fLibSecret = (LibSecret)Native.load((String)"secret-1", LibSecret.class, LIB_LOAD_OPTIONS);
        Pointer secretService = this.fLibSecret.secret_service_get_sync(4, Pointer.NULL, gerror);
        this.requireNoError(gerror, "Unable to get secret service: ");
        Pointer defaultCollection = this.fLibSecret.secret_collection_for_alias_sync(secretService, SECRET_COLLECTION_DEFAULT, 0, Pointer.NULL, gerror);
        this.requireNoError(gerror, "Unable to get secret collection: ");
        if (defaultCollection == Pointer.NULL) {
            throw new SecurityException("Unable to find default secret collection");
        }
        if (this.fLibSecret.secret_collection_get_locked(defaultCollection)) {
            this.fLibSecret.secret_collection_get_label(defaultCollection);
            GList list = this.fLibGio.g_list_append(null, defaultCollection);
            PointerByReference unlocked = new PointerByReference();
            this.fLibSecret.secret_service_unlock_sync(secretService, list, Pointer.NULL, unlocked, gerror);
            this.fLibGio.g_error_free(unlocked.getValue());
            this.fLibGio.g_error_free(list.getPointer());
            this.requireNoError(gerror, "Unable to unlock: ");
        }
    }

    private String getMasterPassword() throws SecurityException {
        this.unlockSecretService();
        PointerByReference gerror = new PointerByReference();
        String password = this.fLibSecret.secret_password_lookup_sync(this.fEquinoxSchema, Pointer.NULL, gerror, Pointer.NULL);
        this.requireNoError(gerror, "");
        if (password == null) {
            throw new SecurityException("Unable to find password");
        }
        return new String(password.getBytes(), StandardCharsets.UTF_8);
    }

    private void saveMasterPassword(String password) throws SecurityException {
        this.unlockSecretService();
        PointerByReference gerror = new PointerByReference();
        String passwordUTF8 = new String(password.getBytes(), StandardCharsets.UTF_8);
        this.fLibSecret.secret_password_store_sync(this.fEquinoxSchema, SECRET_COLLECTION_DEFAULT, "Equinox master password", passwordUTF8, Pointer.NULL, gerror, Pointer.NULL);
        this.requireNoError(gerror, "");
    }

    private void requireNoError(PointerByReference gerror, String details) {
        if (gerror.getValue() != Pointer.NULL) {
            GError error = new GError(gerror.getValue());
            String message = error.message;
            this.fLibGio.g_error_free(gerror.getValue());
            throw new SecurityException(details + message);
        }
    }

    public PBEKeySpec getPassword(IPreferencesContainer container, int passwordType) {
        boolean passwordChange;
        boolean newPassword = (passwordType & 1) != 0;
        boolean bl = passwordChange = (passwordType & 2) != 0;
        if (!newPassword && !passwordChange) {
            try {
                return new PBEKeySpec(this.getMasterPassword().toCharArray());
            }
            catch (SecurityException e) {
                AuthPlugin.getDefault().logError(LinuxPasswordProviderMessages.getMasterPasswordError, (Throwable)e);
                return null;
            }
        }
        byte[] rawPassword = new byte[64];
        new SecureRandom().nextBytes(rawPassword);
        String newPasswordString = Base64.encode((byte[])rawPassword);
        AuthPlugin.getDefault().logMessage(LinuxPasswordProviderMessages.newMasterPasswordGenerated);
        try {
            this.saveMasterPassword(newPasswordString);
            return new PBEKeySpec(newPasswordString.toCharArray());
        }
        catch (SecurityException e) {
            AuthPlugin.getDefault().logError(LinuxPasswordProviderMessages.saveMasterPasswordError, (Throwable)e);
            return null;
        }
    }

    public boolean isValid() {
        try {
            this.unlockSecretService();
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static interface LibGio
    extends Library {
        public Pointer g_bus_get_sync(int var1, Pointer var2, PointerByReference var3);

        public void g_error_free(Pointer var1);

        public GList g_list_append(GList var1, Pointer var2);
    }

    private static interface LibSecret
    extends Library {
        public Pointer secret_service_get_sync(int var1, Pointer var2, PointerByReference var3);

        public Pointer secret_collection_for_alias_sync(Pointer var1, String var2, int var3, Pointer var4, PointerByReference var5);

        public boolean secret_collection_get_locked(Pointer var1);

        public String secret_collection_get_label(Pointer var1);

        public int secret_service_unlock_sync(Pointer var1, GList var2, Pointer var3, PointerByReference var4, PointerByReference var5);

        public String secret_password_lookup_sync(SecretSchema var1, Pointer var2, PointerByReference var3, Object ... var4);

        public boolean secret_password_store_sync(SecretSchema var1, String var2, String var3, String var4, Pointer var5, PointerByReference var6, Object ... var7);
    }
}

