/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.app.builder;

import com.iizix.ILog;
import com.iizix.IPluginDescriptor;
import com.iizix.SystemConfig;
import com.iizix.XMLUtilities;
import com.iizix.app.CancelException;
import com.iizix.app.builder.IIDirectory;
import com.iizix.app.builder.IIFile;
import com.iizix.app.builder.IOperation;
import com.iizix.app.builder.JavaDirectory;
import com.iizix.app.builder.JavaFile;
import com.iizix.app.builder.a;
import com.iizix.app.builder.b;
import com.iizix.license.IAppBuilderLicenseSystem;
import com.iizix.license.ILicenseCallback;
import com.iizix.license.LicenseSystem;
import com.iizix.prop.Atom;
import com.iizix.prop.ClasspathEntry;
import com.iizix.prop.EnvProps;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.FolderURIPropCnr;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.ModuleProjectSettings;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropErrorItemOrigin;
import com.iizix.prop.PropException;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PushProps;
import com.iizix.server.IAppLoader;
import com.iizix.server.PluginLoader;
import com.iizix.server.ServerShell;
import com.iizix.server.app.prop.AppPropCnr;
import com.iizix.server.app.prop.ModuleProjectPropCnr;
import com.iizix.server.app.prop.ServerAppDistributionProps;
import com.iizix.server.devel.ModuleProject;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ApplicationDistributor
implements IAppLoader,
Serializable {
    private static final long serialVersionUID = 6401495405578254211L;
    public static final String FILENAME = ".iiziApp";
    public static final String CREATED_BY = SystemConfig.VERSION + "." + SystemConfig.BUILD + " (com.iizigo)";
    private final boolean a;
    private final ExecutorService a;
    protected ServerAppDistributionProps dist;
    private final ArrayList<IOperation> a;
    protected AppPropCnr appCnr;
    protected ModuleProjectPropCnr[] modules;
    protected final PropFactory propFactory;
    private final PropMgr a;
    private final PluginLoader a;
    private IAppBuilderLicenseSystem a = new ArrayList();
    private static volatile /* synthetic */ int[] a;

    public ApplicationDistributor(PropFactory propFactory, PropMgr propMgr, PluginLoader pluginLoader, ExecutorService executorService, boolean bl) {
        this.appCnr = new AppPropCnr(Atom.APPS);
        this.propFactory = propFactory;
        this.a = propMgr;
        this.a = pluginLoader;
        this.a = executorService;
        this.a = bl;
        this.appCnr.initialize(null, new EnvProps(Atom.ENV));
        this.appCnr.initialize(propMgr);
    }

    public String initializeLicenseSystem() {
        return this.initializeLicenseSystem(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String initializeLicenseSystem(ILicenseCallback iLicenseCallback) {
        if (iLicenseCallback == null) {
            iLicenseCallback = string -> {
                ILog.log((int)1, (String)"<License System>", (String)("The license system must shut down the iiziApp Distribution product, reason: " + string));
                System.exit(9);
            };
        }
        Object object = null;
        if (this.a == null) {
            ApplicationDistributor applicationDistributor = this;
            synchronized (applicationDistributor) {
                if (this.a == null) {
                    ServerShell.updateWebServerRoot(null);
                    LicenseSystem licenseSystem = LicenseSystem.getInstance();
                    try {
                        licenseSystem.prepare((Object)this);
                        this.a = (IAppBuilderLicenseSystem)licenseSystem.getInstanceImplementation((Object)licenseSystem, IAppBuilderLicenseSystem.class);
                        this.a.assignCallback(iLicenseCallback);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        object = "Failed loading license system, the IIZI Application Distributor product cannot start: the license implementation \"" + classNotFoundException.getMessage() + "\" is not found";
                    }
                    catch (Throwable throwable) {
                        object = "Failed loading license system, the IIZI Application Distributor product cannot start: " + String.valueOf(throwable);
                    }
                }
            }
        }
        if (this.a == null && object == null) {
            object = "Failed loading license system, the IIZI Application Distributor product cannot start";
        }
        if (object != null) {
            ILog.SEVERE(this.getClass(), (String)object);
        }
        return object;
    }

    public void dispose() {
        try {
            this.appCnr.removeAllProps();
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
        this.appCnr.dispose();
        this.appCnr = null;
        IAppBuilderLicenseSystem iAppBuilderLicenseSystem = this.a;
        if (iAppBuilderLicenseSystem != null) {
            iAppBuilderLicenseSystem.dispose();
        }
    }

    public PropMgr getPropertyManager() {
        return this.a;
    }

    public void loadApplicationDefinition(File file) throws IOException, PropException, CancelException {
        Object object;
        Object object2;
        long l = System.nanoTime();
        JavaFile javaFile = new JavaFile(new File(file, FILENAME));
        this.dist = this.loadFile(javaFile, ServerAppDistributionProps.class, null);
        File file2 = this.getDestinationJar(file);
        if (file2 == null) {
            throw new IOException("Destination Jar is undefined");
        }
        File file3 = file2.getParentFile();
        if (file3 == null || !file3.isDirectory()) {
            throw new IOException("Destination directory for Jar file name '" + file2.getPath() + "' does not exist");
        }
        if (this.a) {
            System.out.println(" - Loading Module project '" + file.getName() + "' from '" + file.getPath() + "'");
        }
        this.loadModule(new JavaDirectory(file));
        String[] stringArray = this.dist.getOtherModules();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = stringArray[n2];
            object2 = ((String)object2).trim();
            object = new File(file.getParentFile(), (String)object2);
            if (this.a) {
                System.out.println(" - Loading other Module project '" + (String)object2 + "' from '" + ((File)object).getPath() + "'");
            }
            if (!((File)object).isDirectory()) {
                throw new FileNotFoundException("Module project '" + (String)object2 + "' is not found in '" + ((File)object).getPath() + "'");
            }
            this.loadModule(new JavaDirectory((File)object));
            ++n2;
        }
        this.modules = this.appCnr.getModuleProjects();
        object2 = "";
        object = this.modules;
        int n3 = this.modules.length;
        n = 0;
        while (n < n3) {
            Object object3 = object[n];
            if (!((String)object2).isEmpty()) {
                object2 = (String)object2 + ", ";
            }
            object2 = (String)object2 + object3.getPropName();
            ++n;
        }
        if (this.a) {
            System.out.println(" - Completed loading required Module project" + (this.modules.length > 1 ? "s" : "") + " " + (String)object2 + ": @" + (double)((System.nanoTime() - l) / 1000000L) / 1000.0 + "s");
        }
    }

    public File getDestinationJar(File file) {
        String string = this.dist.getDestinationJar();
        try {
            return string != null && !string.isEmpty() ? file.getAbsoluteFile().toPath().resolve(string).toFile() : null;
        }
        catch (InvalidPathException invalidPathException) {
            ILog.SEVERE(this.getClass(), (String)("Destination Jar \"" + string + "\": " + invalidPathException.getMessage()));
            return null;
        }
    }

    public void resolveReferences(List<String> list, List<String> list2) {
        this.appCnr.resolveReferences(false);
        ArrayList arrayList = new ArrayList();
        this.appCnr.getErroredPropItems(arrayList, true);
        for (PropErrorItemOrigin propErrorItemOrigin : arrayList) {
            String string = propErrorItemOrigin.property.getReferencePropName() + "\t" + propErrorItemOrigin.errorItem.getMessage();
            int n = propErrorItemOrigin.errorItem.getSeverity();
            if (n == 2) {
                list2.add(string);
                continue;
            }
            if (n != 1) continue;
            list.add(string);
        }
    }

    public String verifyModules() {
        ModuleProjectPropCnr[] moduleProjectPropCnrArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleProjectPropCnr moduleProjectPropCnr = moduleProjectPropCnrArray[n2];
            ClasspathEntry[] classpathEntryArray = moduleProjectPropCnr.getSettings().getClasspathEntries();
            int n3 = classpathEntryArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ClasspathEntry classpathEntry = classpathEntryArray[n4];
                if (classpathEntry.type == ClasspathEntry.Type.PROJECT && this.appCnr.getProp(classpathEntry.path, ModuleProjectPropCnr.class) == null) {
                    return "Classpath dependency in project '" + moduleProjectPropCnr.getPropName() + "' to project '" + classpathEntry.path + "' is not resolved: add the project '" + classpathEntry.path + "' to the Modules to include when building the distribution";
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private static void a(PropCnr propCnr) {
        propCnr.setPropReadOnly(false);
        GProp[] gPropArray = propCnr.getProps();
        int n = gPropArray.length;
        int n2 = 0;
        while (n2 < n) {
            GProp gProp = gPropArray[n2];
            if (gProp instanceof FileURIPropCnr) {
                FileURIPropCnr fileURIPropCnr = (FileURIPropCnr)gProp;
                fileURIPropCnr.setPropReadOnly(false);
                GProp[] gPropArray2 = fileURIPropCnr.getProps();
                int n3 = gPropArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    var6_6 = gPropArray2[n4];
                    System.err.println("Removing property in assets: " + String.valueOf(var6_6));
                    var6_6.setPropReadOnly(false);
                    fileURIPropCnr.removeProp2((IGProp)var6_6);
                    ++n4;
                }
                fileURIPropCnr.setPropReadOnly(true);
            } else if (gProp instanceof FolderURIPropCnr) {
                var6_6 = (FolderURIPropCnr)gProp;
                ApplicationDistributor.a((PropCnr)var6_6);
            } else {
                System.err.println("Removing property in assets: " + String.valueOf(gProp));
                gProp.setPropReadOnly(false);
                propCnr.removeProp2((IGProp)gProp);
            }
            ++n2;
        }
        propCnr.setPropReadOnly(true);
    }

    public int createResourceOperations(Object object) throws IOException, CancelException {
        LinkedHashMap<File, String> linkedHashMap = new LinkedHashMap<File, String>();
        Object object2 = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleProjectPropCnr object3 = object2[n2];
            String string = object3.getPropName();
            this.addOperation(new a(string));
            PropCnr propCnr = (PropCnr)object3.getProp("assets", PropCnr.class);
            if (propCnr == null) {
                throw new FileNotFoundException("Assets folder not found for Module '" + object3.getPropName() + "'");
            }
            this.a(propCnr, string);
            ApplicationDistributor.a(propCnr);
            this.a(object3, linkedHashMap, object);
            ++n2;
        }
        if (!linkedHashMap.isEmpty()) {
            this.addOperation(new a("$ext"));
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                File file = (File)entry.getKey();
                if (file.isDirectory()) {
                    object2 = new a(new JavaDirectory(file), (String)entry.getValue());
                    this.addOperation((IOperation)object2);
                    ((a)object2).a(this, object);
                    continue;
                }
                this.addOperation(new b(new JavaFile(file), (String)entry.getValue()));
            }
        }
        return this.a.size();
    }

    private void a(PropCnr propCnr, String string) throws IOException, CancelException {
        FolderURIPropCnr folderURIPropCnr;
        String string2 = propCnr.getPropName();
        string = string != null ? string + "/" + string2 : string2;
        this.addOperation(new a(string));
        FolderURIPropCnr[] folderURIPropCnrArray = (FolderURIPropCnr[])propCnr.getProps(FolderURIPropCnr.class);
        int n = folderURIPropCnrArray.length;
        int n2 = 0;
        while (n2 < n) {
            folderURIPropCnr = folderURIPropCnrArray[n2];
            this.a((PropCnr)folderURIPropCnr, string);
            ++n2;
        }
        try {
            folderURIPropCnrArray = (FileURIPropCnr[])propCnr.getProps(FileURIPropCnr.class);
            n = folderURIPropCnrArray.length;
            n2 = 0;
            while (n2 < n) {
                folderURIPropCnr = folderURIPropCnrArray[n2];
                this.addOperation(new b(new JavaFile(new File(folderURIPropCnr.getURL().toURI())), string + "/" + folderURIPropCnr.getPropName()));
                ++n2;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Resource error", uRISyntaxException);
        }
    }

    private void a(ModuleProjectPropCnr moduleProjectPropCnr, LinkedHashMap<File, String> linkedHashMap, Object object) throws IOException, CancelException {
        ModuleProjectSettings moduleProjectSettings = moduleProjectPropCnr.getSettings();
        ArrayList<ClasspathEntry> arrayList = new ArrayList<ClasspathEntry>();
        boolean bl = this.dist.doIncludeExternals();
        boolean bl2 = this.dist.doIncludeAppSource();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        String string = moduleProjectPropCnr.getPropName() + "/classpath";
        this.addOperation(new a(string));
        hashSet2.add(string);
        ClasspathEntry[] classpathEntryArray = moduleProjectSettings.getClasspathEntries();
        int n = classpathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathEntry classpathEntry = classpathEntryArray[n2];
            Object object2 = classpathEntry.path;
            switch (ApplicationDistributor.a()[classpathEntry.type.ordinal()]) {
                case 1: {
                    if (!bl2) break;
                    File file = new File((String)object2);
                    if (!file.isDirectory()) {
                        throw new FileNotFoundException("Classpath entry with source directory '" + (String)object2 + "' is not found in Module '" + moduleProjectPropCnr.getPropName() + "'");
                    }
                    Object object3 = ((String)object2).isEmpty() ? string : string + "/" + (String)object2;
                    Object object4 = new a(new JavaDirectory(file), (String)object3);
                    this.addOperation((IOperation)object4);
                    ((a)object4).a(this, object);
                    break;
                }
                case 5: {
                    File file = new File((String)object2);
                    if (!file.isDirectory()) {
                        throw new FileNotFoundException("Classpath entry with external library '" + (String)object2 + "' is not found in Module '" + moduleProjectPropCnr.getPropName() + "'");
                    }
                    if (bl) {
                        object2 = "$ext/" + this.a(file, "extdir", linkedHashMap);
                        arrayList.add(new ClasspathEntry(ClasspathEntry.Type.PROJECT_DIRECTORY, (String)object2));
                        break;
                    }
                    arrayList.add(classpathEntry);
                    break;
                }
                case 4: {
                    Object object3 = new File((String)object2);
                    if (!((File)object3).isFile()) {
                        throw new FileNotFoundException("Classpath entry with external library '" + (String)object2 + "' is not found in Module '" + moduleProjectPropCnr.getPropName() + "'");
                    }
                    if (bl) {
                        object2 = "$ext/" + this.a((File)object3, "extlib", linkedHashMap);
                        arrayList.add(new ClasspathEntry(ClasspathEntry.Type.PROJECT_LIBRARY, (String)object2));
                        break;
                    }
                    arrayList.add(classpathEntry);
                    break;
                }
                case 6: {
                    arrayList.add(classpathEntry);
                    break;
                }
                case 2: {
                    if (!hashSet.add((String)object2)) break;
                    Object object4 = new File(moduleProjectPropCnr.getDevelopmentDirectory(), (String)object2);
                    if (!((File)object4).isDirectory()) {
                        throw new FileNotFoundException("Classpath entry with project directory '" + (String)object2 + "' is not found in Module '" + moduleProjectPropCnr.getPropName() + "'");
                    }
                    this.a((String)object2, string, hashSet2);
                    String string2 = ((String)object2).isEmpty() ? string : string + "/" + (String)object2;
                    a a2 = new a(new JavaDirectory((File)object4), string2);
                    this.addOperation(a2);
                    a2.a(this, object);
                    arrayList.add(classpathEntry);
                    break;
                }
                case 3: {
                    if (!hashSet.add((String)object2)) break;
                    Object object4 = new File(moduleProjectPropCnr.getDevelopmentDirectory(), (String)object2);
                    if (!((File)object4).isFile()) {
                        throw new FileNotFoundException("Classpath entry with project library '" + (String)object2 + "' is not found in Module '" + moduleProjectPropCnr.getPropName() + "'");
                    }
                    this.a((String)object2, string, hashSet2);
                    String string2 = string + "/" + (String)object2;
                    this.addOperation(new b(new JavaFile((File)object4), string2));
                    arrayList.add(classpathEntry);
                    break;
                }
                case 7: {
                    arrayList.add(classpathEntry);
                }
            }
            ++n2;
        }
        moduleProjectSettings.setClasspath(arrayList);
    }

    private void a(String string, String string2, HashSet<String> hashSet) {
        String[] stringArray = string.split("/");
        Object object = string2;
        int n = stringArray.length - 1;
        int n2 = 0;
        while (n2 < n) {
            if (hashSet.add((String)(object = (String)object + "/" + stringArray[n2]))) {
                this.addOperation(new a((String)object));
            }
            ++n2;
        }
    }

    private String a(File file, String string, LinkedHashMap<File, String> linkedHashMap) {
        Object object = linkedHashMap.get(file);
        if (object != null) {
            return object;
        }
        object = file.getName();
        int n = 0;
        String string2 = object;
        while (linkedHashMap.containsValue(object)) {
            Object object2 = object = n++ == 0 ? string + "_" + string2 : string + "_" + n + "_" + string2;
        }
        linkedHashMap.put(file, (String)object);
        return object;
    }

    public ExecutorService getExecutorService() {
        return this.a;
    }

    public PropCnr loadFile(String string, InputStream inputStream) throws IOException, PropException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            return this.propFactory.loadPropTree(this.getPropertyManager(), string, (InputStream)bufferedInputStream, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public PropCnr loadFile(File file) throws IOException, PropException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            return this.propFactory.loadPropTree(this.getPropertyManager(), file.getAbsolutePath(), (InputStream)bufferedInputStream, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public List<IPluginDescriptor<?>> loadPlugins(String string) throws IOException {
        if (this.a != null) {
            return this.a.loadPlugins(string.replace("com.iizigo.", "com.iizix."));
        }
        return null;
    }

    protected <PC extends PropCnr> PC loadFile(IIFile iIFile, Class<PC> clazz, Object object) throws IOException, PropException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(iIFile.openInputStream(object));){
            PropCnr propCnr = this.propFactory.loadPropTree(this.getPropertyManager(), iIFile.getFullPath(), (InputStream)bufferedInputStream, true);
            if (clazz.isInstance(propCnr)) {
                return (PC)propCnr;
            }
            throw new PropException((GProp)propCnr, "File '" + iIFile.getFullPath() + "' contained a property of class '" + propCnr.getClass().getCanonicalName() + "' but '" + clazz.getCanonicalName() + "' was expected");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void addOperation(IOperation iOperation) {
        this.a.add(iOperation);
    }

    protected void loadModule(IIDirectory iIDirectory) throws IOException, PropException {
        File file = iIDirectory.getFile(null);
        ModuleProjectPropCnr moduleProjectPropCnr = ModuleProject.loadModuleProject((IAppLoader)this, (File)file, null, (boolean)this.a);
        moduleProjectPropCnr.renameProp(Atom.get((String)file.getName()));
        this.appCnr.addProp((IGProp)moduleProjectPropCnr);
        moduleProjectPropCnr.getSettings().getMainPropCnr().setPropReadOnly(false);
        PushProps pushProps = moduleProjectPropCnr.getPushProps();
        if (pushProps != null) {
            pushProps.setPropReadOnly(false);
        }
        if ((pushProps = moduleProjectPropCnr.getPWAProps()) != null) {
            pushProps.setPropReadOnly(false);
        }
        this.b((PropCnr)moduleProjectPropCnr);
    }

    private void b(PropCnr propCnr) throws PropException {
        propCnr.setPropError(null);
        GProp[] gPropArray = propCnr.getProps();
        int n = gPropArray.length;
        int n2 = 0;
        while (n2 < n) {
            GProp gProp = gPropArray[n2];
            if (gProp.isPropForEditor()) {
                propCnr.removeProp((IGProp)gProp);
            } else {
                if (gProp instanceof PropCnr) {
                    this.b((PropCnr)gProp);
                }
                gProp.setPropError(null);
            }
            ++n2;
        }
    }

    public File createJar(Object object) throws IOException {
        File file;
        block69: {
            String string;
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.putValue("Created-By", CREATED_BY);
            attributes.putValue("Application-Name", "iiziApp");
            attributes.putValue("iiziApp-File", "iiziApp.xml");
            attributes.putValue("IIZI-Plugins", this.a());
            attributes.putValue("Codebase", "*");
            attributes.putValue("Permissions", "all-permissions");
            attributes.putValue("Trusted-only", "true");
            if (this.dist.doJarSeal()) {
                attributes.putValue("Sealed", "true");
            }
            if ((string = this.dist.getName()) != null && !string.isEmpty()) {
                attributes.putValue("iiziApp-Name", string);
            }
            if ((string = this.dist.getDescription()) != null && !string.isEmpty()) {
                attributes.putValue("iiziApp-Description", string);
            }
            file = File.createTempFile("iizi-dist", ".jar");
            if (this.a) {
                System.out.println("\nJAR:");
            }
            Throwable throwable = null;
            Object var7_8 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
                boolean bl = this.dist.doJarCompression();
                jarOutputStream.setLevel(bl ? 9 : 0);
                CRC32 cRC32 = bl ? null : new CRC32();
                byte[] byArray = this.a();
                JarEntry jarEntry = new JarEntry("iiziApp.xml");
                jarEntry.setSize(byArray.length);
                jarEntry.setTime(System.currentTimeMillis());
                if (cRC32 == null) {
                    jarEntry.setMethod(8);
                } else {
                    cRC32.update(byArray);
                    jarEntry.setMethod(0);
                    jarEntry.setCompressedSize(byArray.length);
                    jarEntry.setCrc(cRC32.getValue());
                }
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                byArray = new byte[8192];
                jarOutputStream.closeEntry();
                if (this.a) {
                    System.out.println(" F - iiziApp.xml (" + byArray.length + ")");
                }
                try {
                    try {
                        for (IOperation iOperation : this.a) {
                            block68: {
                                IOperation iOperation2;
                                this.checkCanceled(object);
                                if (iOperation instanceof b) {
                                    int n;
                                    BufferedInputStream bufferedInputStream;
                                    Object var19_24;
                                    Throwable throwable2;
                                    iOperation2 = (b)iOperation;
                                    if (cRC32 != null) {
                                        cRC32.reset();
                                        throwable2 = null;
                                        var19_24 = null;
                                        try {
                                            bufferedInputStream = new BufferedInputStream(iOperation2.a.openInputStream(object));
                                            try {
                                                while ((n = bufferedInputStream.read(byArray)) >= 0) {
                                                    cRC32.update(byArray, 0, n);
                                                }
                                            }
                                            finally {
                                                if (bufferedInputStream != null) {
                                                    bufferedInputStream.close();
                                                }
                                            }
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    throwable2 = null;
                                    var19_24 = null;
                                    try {
                                        bufferedInputStream = new BufferedInputStream(iOperation2.a.openInputStream(object));
                                        try {
                                            jarEntry = new JarEntry(iOperation2.a);
                                            long l = iOperation2.a.getFileSize();
                                            long l2 = iOperation2.a.getLastModified();
                                            jarEntry.setSize(l);
                                            if (l2 > 0L) {
                                                jarEntry.setTime(l2);
                                            }
                                            if (cRC32 == null) {
                                                jarEntry.setMethod(8);
                                            } else {
                                                jarEntry.setMethod(0);
                                                jarEntry.setCompressedSize(l);
                                                jarEntry.setCrc(cRC32.getValue());
                                            }
                                            jarOutputStream.putNextEntry(jarEntry);
                                            if (this.a) {
                                                System.out.println(" F - " + iOperation2.a + " (" + l + ")");
                                            }
                                            long l3 = 0L;
                                            try {
                                                while ((n = bufferedInputStream.read(byArray)) >= 0) {
                                                    jarOutputStream.write(byArray, 0, n);
                                                    l3 += (long)n;
                                                }
                                            }
                                            finally {
                                                jarOutputStream.closeEntry();
                                            }
                                            if (l3 != l) {
                                                throw new IOException("Different byte count written " + l3 + ", should be " + l + ", file " + iOperation2.a.getFullPath());
                                            }
                                            break block68;
                                        }
                                        finally {
                                            if (bufferedInputStream != null) {
                                                bufferedInputStream.close();
                                            }
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable4;
                                        } else if (throwable2 != throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        throw throwable2;
                                    }
                                }
                                iOperation2 = (a)iOperation;
                                jarEntry = new JarEntry(((a)iOperation2).a + "/");
                                jarOutputStream.putNextEntry(jarEntry);
                                jarOutputStream.closeEntry();
                                if (this.a) {
                                    System.out.println(" D - " + ((a)iOperation2).a + "/");
                                }
                            }
                            this.worked(object, 1);
                        }
                        jarOutputStream.finish();
                        jarOutputStream.close();
                        jarOutputStream = null;
                    }
                    catch (IOException iOException) {
                        jarOutputStream.finish();
                        jarOutputStream.close();
                        jarOutputStream = null;
                        if (jarOutputStream == null) break block69;
                        try {
                            jarOutputStream.finish();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            jarOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (jarOutputStream != null) {
                        try {
                            jarOutputStream.finish();
                        }
                        catch (Exception exception) {}
                        try {
                            jarOutputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        return file;
    }

    private byte[] a() throws IOException {
        Object object2;
        ArrayList arrayList = new ArrayList();
        this.appCnr.getErroredPropItems(arrayList, true);
        int n = arrayList.size();
        for (Object object2 : arrayList) {
            ((PropErrorItemOrigin)object2).property.setPropError(null);
        }
        if (n > 0) {
            arrayList.clear();
            this.appCnr.getErroredPropItems(arrayList, true);
            n = arrayList.size();
            if (n > 0) {
                throw new IOException("Cloned property tree still contains " + n + " errors");
            }
        }
        ModuleProjectPropCnr[] moduleProjectPropCnrArray = this.appCnr.getModuleProjects();
        int n2 = moduleProjectPropCnrArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object2 = moduleProjectPropCnrArray[n3];
            PushProps pushProps = object2.getPushProps();
            if (pushProps != null) {
                pushProps.setPropReadOnly(true);
            }
            if ((pushProps = object2.getPWAProps()) != null) {
                pushProps.setPropReadOnly(true);
            }
            ++n3;
        }
        object2 = new ByteArrayOutputStream();
        try {
            XMLUtilities.saveXMLDocument((Document)this.propFactory.createDocument((PropCnr)this.appCnr), (OutputStream)object2);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Failed creating application XML", transformerException);
        }
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    private String a() {
        StringBuilder stringBuilder;
        HashSet<String> hashSet = new HashSet<String>();
        ModuleProjectPropCnr[] moduleProjectPropCnrArray = this.modules;
        int n = this.modules.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuilder = moduleProjectPropCnrArray[n2];
            String string = stringBuilder.getSettings().getPlugins();
            if (string != null) {
                hashSet.addAll(List.of(string.split(",")));
            }
            ++n2;
        }
        stringBuilder = new StringBuilder();
        for (String string : hashSet) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string.replace("com.iizigo.", "com.iizix."));
        }
        return stringBuilder.toString();
    }

    protected void checkCanceled(Object object) throws CancelException {
    }

    protected void worked(Object object, int n) {
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[ClasspathEntry.Type.values().length];
        try {
            nArray[ClasspathEntry.Type.CONTAINER.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.EXTERNAL_DIRECTORY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.EXTERNAL_LIBRARY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.PROJECT.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.PROJECT_DIRECTORY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.PROJECT_LIBRARY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ClasspathEntry.Type.SOURCE_DIRECTORY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

