/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server.monitor;

import com.iizigo.Activator;
import com.iizigo.ApplicationUI;
import com.iizigo.prop.IPropCnrEditorProperties;
import com.iizigo.prop.PropCnrEditorProperties;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizigo.server.monitor.EditorInfoPropCnr;
import com.iizix.Utilities;
import com.iizix.prop.PropCnr;
import com.iizix.server.IEndPoint;
import java.util.List;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class EditorEndPointPropCnr
extends EditorInfoPropCnr {
    private static final List<TooltipItem> a = List.of(TooltipItem.HEADER_IMAGE_DESCR_TYPE, TooltipItem.SEPARATOR, TooltipItem.newNormal("Type", "type", (propCnr, gProp, object) -> {
        IEndPoint.Type[] typeArray = IEndPoint.Type.values();
        int n2 = propCnr.getInt("type");
        return n2 >= 0 && n2 < typeArray.length ? typeArray[n2].getDescription() : "Unknown type " + n2;
    }), TooltipItem.newNormal("Name", "name"), TooltipItem.SEPARATOR, TooltipItem.newNormal("Session ID", "id"), TooltipItem.newNormal("Host name", "host"), TooltipItem.newNormal("Host address", "addr"), TooltipItem.newNormal("Created", "crt", (propCnr, gProp, object) -> {
        long l2 = propCnr.getLong("crt", -1L);
        return l2 < 0L ? "n/a" : Utilities.formatDate((long)l2);
    }), TooltipItem.SEPARATOR, TooltipItem.newNormal("Session start", "start", (propCnr, gProp, object) -> {
        long l2 = propCnr.getLong("start", -1L);
        return l2 < 0L ? "n/a" : Utilities.formatDate((long)l2);
    }), TooltipItem.newNormal("User ID", "user"), TooltipItem.newNormal("Application ID", "app"), TooltipItem.newNormal("Session count", "count"), TooltipItem.SEPARATOR, TooltipItem.newNormal("Uses default locale", "def"), TooltipItem.SEPARATOR, TooltipItem.newNormal("Language", "lang"), TooltipItem.newNormal("Locale", "locale"), TooltipItem.newNormal("Time zone ID", "zone"), TooltipItem.newNormal("Time offset", "offset"));

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }

    @Override
    public int getCNCategory() {
        return switch (this.getInt("type", -1)) {
            case 0 -> 1;
            case 1 -> 2;
            case 2 -> 6;
            case 3 -> 7;
            case 4 -> 5;
            case 5 -> 4;
            case 6 -> 3;
            default -> 0;
        };
    }

    @Override
    public Image getCNImage() {
        String string;
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        switch (this.getInt("type", -1)) {
            case 0: {
                string = "iizi_standalone_server.png";
                break;
            }
            case 1: {
                return applicationUI.imageEditPen;
            }
            case 2: {
                string = "device_desktop.gif";
                break;
            }
            case 3: {
                return applicationUI.imageDeviceLandscape;
            }
            case 4: {
                return applicationUI.imageVirtualSpace;
            }
            case 5: {
                string = "keystore.gif";
                break;
            }
            case 6: {
                string = "iizi_monitor.png";
                break;
            }
            default: {
                string = "message_warning.gif";
            }
        }
        return applicationUI.getImage(string);
    }

    @Override
    public String getCNText() {
        IEndPoint.Type[] typeArray = IEndPoint.Type.values();
        int n2 = this.getInt("type");
        return n2 >= 0 && n2 < typeArray.length ? typeArray[n2].getDescription() : "Unknown type " + n2;
    }

    @Override
    public StyledString getCNStyledText() {
        String string;
        StyledString styledString = new StyledString(this.getCNText());
        int n2 = this.getInt("count", 0);
        if (n2 > 0) {
            styledString.append("   (" + n2 + ")", StyledString.COUNTER_STYLER);
        }
        if ((string = this.getString("user")) != null) {
            styledString.append("  " + string, StyledString.QUALIFIER_STYLER);
        }
        if ((string = this.getString("host")) != null) {
            styledString.append("  " + string, StyledString.DECORATIONS_STYLER);
        }
        return styledString;
    }

    @Override
    public String getCNDescriptionType() {
        String string = this.getString("type");
        return string != null ? string : "End-point";
    }

    @Override
    public boolean canEditProperties() {
        return false;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class Setup
    implements IPropCnrEditorProperties {
        private static final Object[] a = new Object[0];
        private static final PropCnrEditorProperties a = new PropCnrEditorProperties(Activator.setupServerMonitor, a);

        @Override
        public PropCnrEditorProperties getEditProperties(PropCnr propCnr) {
            return a;
        }
    }
}

