/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.server;

import com.iizigo.Activator;
import com.iizigo.ImageRegistry;
import com.iizigo.server.ServerConfigComposite;
import com.iizigo.server.ServerConfigFile;
import com.iizigo.server.ServerConfigView;
import com.iizigo.server.b;
import com.iizigo.server.config.EditorServerConfigEnvProps;
import com.iizigo.server.config.EditorServerSettings;
import com.iizigo.server.config.EditorWebServerPortConfig;
import com.iizix.prop.Atom;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class NewServerConfigWizard
extends Wizard
implements INewWizard {
    private b a;
    private ServerConfigComposite a;
    private String a;

    public NewServerConfigWizard() {
        this.setWindowTitle("Server Configuration");
        this.setDefaultPageImageDescriptor(ImageRegistry.getInstance().get("large/server_config.png"));
        this.setNeedsProgressMonitor(false);
    }

    public void setServerConfigComposite(ServerConfigComposite serverConfigComposite) {
        this.a = serverConfigComposite;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        this.a = new b();
        this.addPage((IWizardPage)this.a);
        Activator.checkEnabledOrStarting(this.getShell(), (IWizard)this);
    }

    public boolean performFinish() {
        Object object;
        File file;
        String string;
        block8: {
            string = "to verify name of";
            file = new File(this.a.a.getText());
            file = file.getCanonicalFile();
            this.a = file.getPath();
            if (file.isFile()) {
                string = "to load";
                object = Activator.loadPropertiesFile(file);
                if (!(object instanceof EditorServerSettings)) {
                    throw new IOException("File is not a Server Settings property file");
                }
                break block8;
            }
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)"New Server Configuration", (String)("Do you wish to create a new Server configuration in file '" + this.a + "'?"))) {
                string = "to create";
                NewServerConfigWizard.createDefault(file);
                break block8;
            }
            return false;
        }
        try {
            if (this.a != null) {
                object = ServerConfigFile.open(file.getPath());
                this.a.setServerConfigFile((ServerConfigFile)((Object)object), null);
            } else {
                Display.getDefault().asyncExec(() -> {
                    ServerConfigView serverConfigView = ServerConfigView.openFile(this.a, true);
                });
            }
            return true;
        }
        catch (PropException | IOException throwable) {
            Activator.openError(this.getShell(), "Server Configuration", "Failed " + string + " the Server configuration file '" + file.getAbsolutePath() + "'.", throwable);
            return false;
        }
    }

    public String getFileName() {
        return this.a;
    }

    public static void createDefault(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            EditorServerSettings editorServerSettings = new EditorServerSettings(Atom.SETTINGS);
            editorServerSettings.assignConfigFile(file);
            EditorWebServerPortConfig editorWebServerPortConfig = new EditorWebServerPortConfig(Atom.get((String)"1"));
            editorWebServerPortConfig.setInt("port", 8080);
            editorWebServerPortConfig.setInt("protocol", 0);
            editorServerSettings.addProp2((IGProp)editorWebServerPortConfig);
            EditorServerConfigEnvProps editorServerConfigEnvProps = new EditorServerConfigEnvProps(Atom.get((String)editorServerSettings.getDefaultServerConfigurationEnvironmentName()));
            editorServerSettings.addProp2((IGProp)editorServerConfigEnvProps);
            try {
                fileOutputStream.write(Activator.createInputData((PropCnr)editorServerSettings));
            }
            catch (TransformerException transformerException) {
                throw new IOException("Failed transforming properties to XML in file " + file.getPath(), transformerException);
            }
            fileOutputStream.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

