/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.urn;

import com.iizix.Utilities;
import com.iizix.urn.URNLocation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public enum URNResourceType {
    COMMON_DATABASE_PERSISTENT("Common server files stored in database (cached on the server even for starts/stops)", "common-db", false, "common/database", "cd", "IZS.FILES", null, null, 0x80000000L),
    COMMON_PERSISTENT("Common server files (persists when server starts/stops)", "common-persist", false, "common/persist", "cp", false),
    COMMON_VOLATILE("Common server files (volatile when server starts/stops)", "common-volatile", false, "common/volatile", "cv", true),
    EXTERNAL_FILES("External files (typically accessible using the 'file:' protocol)", "external", false, null, null, "IZS.EXT_FILES", "eid", Long.class, 0L),
    APPLICATION_DATABASE_PERSISTENT("Application files in database", "app-db", true, "app/database", "ad", "IZS.APP_FILES", "aid", Long.class, 0x80000000L),
    APPLICATION_PERSISTENT("Application files", "app-persist", true, "app/persist", "ap", false),
    APPLICATION_VOLATILE("Application files", "app-volatile", true, "app/volatile", "av", true),
    GROUP_DATABASE_FILES("Private user group files stored in database (cached on server)", "group-db", true, "groupdb", "gd", "IZS.GROUP_FILES", "gid", Long.class, 0x80000000L),
    USER_FILES("Private user files", "user", true, "users", "u", false),
    USER_DATABASE_FILES("Private user files stored in database (cached on server)", "user-db", true, "usersdb", "ud", "IZS.USER_FILES", "uid", Long.class, 0x80000000L),
    APP_SESSION("Application session files", "app-session", true, "app/session", "as", true),
    CLIENT_SESSION("Client session files", "client-session", true, "clientSessions", "cs", true);

    public final String descr;
    public final String nss;
    public final boolean isSubjectBased;
    public final String internalSubDirectory;
    public final String externalStartPath;
    public final boolean doDeleteFiles;
    public final URNLocation storageLocation;
    public final String tableName;
    public final String idColumn;
    public final Class<?> idClass;
    public final long maxSize;
    private Set<Integer> a;
    public static final int COUNT;
    public static final List<URNResourceType> ALL;
    public static final List<URNResourceType> NON_SUBJECT_BASED;
    public static final List<URNResourceType> SUBJECT_BASED;
    public static final Map<String, URNResourceType> EXTERNAL_START_PATH_TO_TYPE;

    static {
        COUNT = URNResourceType.values().length;
        ALL = Arrays.asList(URNResourceType.values());
        NON_SUBJECT_BASED = List.of(COMMON_DATABASE_PERSISTENT, COMMON_PERSISTENT, COMMON_VOLATILE);
        SUBJECT_BASED = List.of(APPLICATION_DATABASE_PERSISTENT, APPLICATION_PERSISTENT, APPLICATION_VOLATILE, APP_SESSION, CLIENT_SESSION, GROUP_DATABASE_FILES, USER_DATABASE_FILES, USER_FILES);
        URNResourceType[] uRNResourceTypeArray = URNResourceType.values();
        HashMap<String, URNResourceType> hashMap = new HashMap<String, URNResourceType>(uRNResourceTypeArray.length);
        URNResourceType[] uRNResourceTypeArray2 = uRNResourceTypeArray;
        int n2 = uRNResourceTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            URNResourceType uRNResourceType = uRNResourceTypeArray2[n3];
            hashMap.put(uRNResourceType.externalStartPath, uRNResourceType);
            ++n3;
        }
        EXTERNAL_START_PATH_TO_TYPE = Collections.unmodifiableMap(hashMap);
    }

    private URNResourceType(String string2, String string3, boolean bl, String string4, String string5, boolean bl2) {
        this.descr = string2;
        this.nss = string3;
        this.isSubjectBased = bl;
        this.internalSubDirectory = string4;
        this.externalStartPath = string5;
        this.doDeleteFiles = bl2;
        this.storageLocation = URNLocation.LOCAL_FILE;
        this.tableName = null;
        this.idColumn = null;
        this.idClass = null;
        this.maxSize = 0L;
    }

    private URNResourceType(String string2, String string3, boolean bl, String string4, String string5, String string6, String string7, Class<?> clazz, long l2) {
        this.descr = string2;
        this.nss = string3;
        this.isSubjectBased = bl;
        this.internalSubDirectory = string4;
        this.externalStartPath = string5;
        this.doDeleteFiles = false;
        this.storageLocation = URNLocation.DATABASE;
        this.tableName = string6;
        this.idColumn = string7;
        this.idClass = clazz;
        this.maxSize = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUniqueDirectory() {
        int n2;
        Object object;
        Set<Integer> set = this.a;
        if (set == null) {
            object = this;
            synchronized (object) {
                set = this.a;
                if (set == null) {
                    set = this.a = ConcurrentHashMap.newKeySet();
                }
            }
        }
        object = Utilities.getSecureRandom();
        while (!set.add(n2 = 1 + ((Random)object).nextInt(Integer.MAX_VALUE))) {
        }
        return Integer.toHexString(n2);
    }

    public static URNResourceType of(String string) {
        URNResourceType[] uRNResourceTypeArray = URNResourceType.values();
        int n2 = uRNResourceTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            URNResourceType uRNResourceType = uRNResourceTypeArray[n3];
            if (uRNResourceType.nss.equals(string)) {
                return uRNResourceType;
            }
            ++n3;
        }
        return null;
    }

    public static final URNResourceType ofExternalStartPath(String string) {
        if (string.startsWith("/$$")) {
            int n2 = string.indexOf(47, 3);
            string = n2 < 0 ? string.substring(3) : string.substring(3, n2);
        }
        return EXTERNAL_START_PATH_TO_TYPE.get(string);
    }
}

