/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs.actor;

import com.iizix.actionactor.IActionActor;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.Atom;
import com.iizix.prop.PropException;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.actor.AbstractPredefinedSettings;
import com.iizix.prop.vs.actor.AbstractVSActionActor;
import com.iizix.txp.impl.AbstractActionActorTXPNode;

public class HistoryBackward
extends AbstractVSActionActor<Settings> {
    public HistoryBackward(VSAction vSAction, Settings settings) {
        super(vSAction, settings);
    }

    @Override
    public Settings createSettings() {
        return new Settings(Atom.SETTINGS);
    }

    @Override
    public String getDefaultDescription() {
        return "History backward";
    }

    @Override
    public String getEnabledState(IAppSessionGyro iAppSessionGyro, VSAction vSAction) {
        IClientSessionGyro iClientSessionGyro = vSAction.getClientSessionGyro();
        if (iClientSessionGyro == null) {
            return "Client session gyro not found";
        }
        return iAppSessionGyro.getAppHistory().isBackwardEnabled(iClientSessionGyro);
    }

    @Override
    public boolean doesModifyVirtualSpace() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void a(AbstractActionActorTXPNode<Settings> abstractActionActorTXPNode, IAppSessionGyro iAppSessionGyro) throws PropException {
        IClientSessionGyro iClientSessionGyro = abstractActionActorTXPNode.getActionProcess().getClientSessionGyro();
        if (iClientSessionGyro == null) {
            throw new PropException(this.settings, "Client session is disposed of");
        }
        boolean[] blArray = new boolean[]{true};
        String string = iAppSessionGyro.getAppHistory().performBackward(iClientSessionGyro, throwable -> {
            boolean[] blArray2 = blArray;
            synchronized (blArray) {
                blArray[0] = false;
                blArray.notifyAll();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        });
        if (string != null) {
            throw new PropException(this.action, "History backward operation failed: " + string);
        }
        boolean[] blArray2 = blArray;
        synchronized (blArray) {
            if (blArray[0]) {
                try {
                    long l2 = abstractActionActorTXPNode.getTimeout();
                    if (l2 >= 0L) {
                        blArray.wait(l2);
                    } else {
                        blArray.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new PropException(this.action, "Timeout waiting for history backward operation to complete");
                }
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static class Settings
    extends AbstractPredefinedSettings {
        public Settings() {
        }

        public Settings(Atom atom) {
            super(atom);
        }

        protected IActionActor<Settings> createActor(VSAction vSAction) {
            return new HistoryBackward(vSAction, this);
        }

        @Override
        public boolean doesModifyVirtualSpace(VSAction vSAction) {
            return false;
        }
    }
}

