/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.LocaleInfo;
import com.iizix.Size;
import com.iizix.device.DeviceParameter;
import com.iizix.event.GEvent;
import com.iizix.event.RemoteEvent;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.gyro.IRemoteSessionControl;
import com.iizix.gyro.IRemoteSessionControlListener;
import com.iizix.gyro.IScreenOrientationListener;
import com.iizix.gyro.IScreenSizeListener;
import com.iizix.gyro.IStatusBarTapListener;
import com.iizix.gyro.IWindowCloseListener;
import com.iizix.gyro.ScreenOrientation;
import com.iizix.gyro.StatusBarConfig;
import com.iizix.gyro.WindowOptions;
import com.iizix.prop.Atom;
import com.iizix.prop.GDateTime;
import com.iizix.prop.GeoProps;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.SpeechRecognitionProp;
import com.iizix.prop.SpeechSynthesisProp;
import com.iizix.prop.StringMapProp;
import com.iizix.selector.DeviceMatch;
import com.iizix.text.LocaleString;
import io.github.mngsk.devicedetector.Detection;
import java.util.HashMap;
import ua_parser.Client;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EnvProps
extends PropCnr {
    private static DeviceParameter[] a = new DeviceParameter[0];
    protected StringMapProp clientEnv;
    protected GeoProps geoProps;
    protected StringMapProp serverEnv;
    private LocaleInfo a;
    private HashMap<String, Object> a;
    private double a;
    private String a;
    private IRemoteSessionControlListener a;
    private IClientSessionGyro a;
    private GenericListener<IStatusBarTapListener> a;
    private IWindowCloseListener a;
    private Size a;
    private GenericListener<IScreenSizeListener> b;
    private boolean a;
    private int a;
    private ScreenOrientation a = -1;
    private GenericListener<IScreenOrientationListener> c;
    private String b;

    protected EnvProps() {
    }

    public EnvProps(Atom atom) {
        super(atom);
    }

    @Override
    public IClientSessionGyro getClientSessionGyro() {
        return this.a;
    }

    @Override
    protected boolean shouldSerializeToXML(int n2) {
        return false;
    }

    @Override
    protected void addPredefinedProps() throws PropException {
        super.addPredefinedProps();
        this.geoProps = this.maybeAddProp(new GeoProps(Atom.GEO));
        this.clientEnv = this.maybeAddProp(new StringMapProp(Atom.CLIENT));
        this.serverEnv = this.maybeAddProp(new StringMapProp(Atom.SERVER));
        if (!this.containsProp(Atom.ZONES)) {
            this.addProp(GDateTime.createTimeZonesProp());
        }
    }

    @Override
    protected void getPredefinedProps() {
        super.getPredefinedProps();
        this.geoProps = this.getProp(Atom.GEO, GeoProps.class);
        this.clientEnv = this.getProp(Atom.CLIENT, StringMapProp.class);
        this.serverEnv = this.getProp(Atom.SERVER, StringMapProp.class);
    }

    @Override
    public EnvProps clone() {
        try {
            EnvProps envProps = (EnvProps)super.clone();
            envProps.a = null;
            envProps.a = null;
            envProps.a = null;
            return envProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public StringMapProp getServerEnv() {
        return this.serverEnv;
    }

    public StringMapProp getClientEnv() {
        return this.clientEnv;
    }

    public boolean iiziRunPresent() {
        StringMapProp stringMapProp = this.getClientEnv();
        return stringMapProp != null && stringMapProp.getValue("izr.cordova") != null;
    }

    public GeoProps getGeolocation() {
        return this.geoProps;
    }

    public SpeechSynthesisProp getSpeechSynthesis() {
        return this.getProp("SpeechSynth", SpeechSynthesisProp.class);
    }

    public SpeechRecognitionProp getSpeechRecognition() {
        return this.getProp("SpeechRecog", SpeechRecognitionProp.class);
    }

    public LocaleInfo getLocale() {
        LocaleInfo localeInfo = this.a;
        if (localeInfo == null && this.clientEnv.size() > 0) {
            Object object;
            boolean bl = false;
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = this.clientEnv.getValue("languageCode");
            if (string4 == null) {
                string4 = this.clientEnv.getValue("navigator.language");
                if (string4 == null && (string4 = this.clientEnv.getValue("navigator.userLanguage")) == null && (string4 = this.clientEnv.getValue("navigator.browserLanguage")) == null) {
                    string4 = this.clientEnv.getValue("navigator.systemLanguage");
                }
                boolean bl2 = bl = string4 != null;
            }
            if (!bl) {
                string = this.clientEnv.getValue("user.country");
                string2 = this.clientEnv.getValue("user.language");
                string3 = this.clientEnv.getValue("user.variant");
                boolean bl3 = bl = string != null;
                if (bl) {
                    object = string;
                    if (string2 != null && !string2.isEmpty()) {
                        object = (String)object + "_" + string2;
                    }
                    if (string3 != null && !string3.isEmpty()) {
                        object = (String)object + "_" + string3;
                    }
                    string4 = object;
                }
            }
            localeInfo = string != null ? LocaleInfo.getLocaleInfo(string, string2, string3) : (string4 != null ? LocaleInfo.getLocaleInfo(string4) : LocaleInfo.DEFAULT_LOCALEINFO);
            object = this.clientEnv.getValue("time.zone.offset");
            if (object != null) {
                try {
                    localeInfo.initializeTimeZone(Integer.parseInt((String)object), this.clientEnv.getValue("time.zone.name"));
                }
                catch (NumberFormatException numberFormatException) {
                    ILog.FINEST(this.getClass(), "Locale information for timezone is not provided in the client environment");
                }
            }
            if (bl) {
                this.a = localeInfo;
                this.a = string4;
                this.setString("languageCode", string4);
            }
        }
        return localeInfo != null ? localeInfo : LocaleInfo.DEFAULT_LOCALEINFO;
    }

    public LocaleInfo setLocale(LocaleInfo localeInfo) throws PropTypeException {
        String string;
        if (localeInfo == null) {
            throw new NullPointerException("locale is null");
        }
        LocaleInfo localeInfo2 = this.a;
        this.a = localeInfo;
        this.a = string = localeInfo.getLanguageCode();
        this.setString("languageCode", string);
        return localeInfo2;
    }

    public double getDPR() {
        double d2 = this.a;
        if (this.a == 0.0) {
            String string;
            d2 = 1.0;
            if (this.clientEnv.size() > 0 && (string = this.clientEnv.getValue("DPR")) != null && !string.isEmpty()) {
                try {
                    double d3 = Double.parseDouble(string);
                    if (d3 > 0.0 && d3 < 4.0) {
                        d2 = this.a = d3;
                        ILog.FINE(this.getClass(), "Client device pixel ratio = " + d2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return d2;
    }

    public String getLanguageCode() {
        if (this.a == null && this.clientEnv.size() > 0) {
            String string = this.clientEnv.getValue("languageCode");
            if (string != null) {
                this.a = string;
                ILog.FINE(this.getClass(), "Client language code = " + string);
            } else {
                this.a = this.getLocale().getLanguageCode();
            }
            this.setString("languageCode", this.a);
        }
        return this.a;
    }

    public synchronized void setCachedValue(String string, Object object) {
        if (this.a == null) {
            this.a = new HashMap();
        }
        this.a.put(string, object);
    }

    public synchronized <TYPE> TYPE getCachedValue(String string, Class<TYPE> clazz) {
        Object v;
        if (this.a != null && clazz.isInstance(v = this.a.get(string))) {
            return (TYPE)v;
        }
        return null;
    }

    public boolean hasClientCapabilities(ClientCapability clientCapability) {
        return clientCapability.isSupported(this);
    }

    public Client getParsedUserAgent() throws Exception {
        return DeviceMatch.getParsedUserAgent(this);
    }

    public Detection getDeviceDetectionFromUserAgent() throws Exception {
        return DeviceMatch.getDeviceDetectionFromUserAgent(this);
    }

    public IRemoteSessionControl registerSession(IClientSessionGyro iClientSessionGyro, IRemoteSessionControlListener iRemoteSessionControlListener) {
        if (this.a != null || iRemoteSessionControlListener == null) {
            throw new IllegalStateException("Only for the framework");
        }
        this.a = iRemoteSessionControlListener;
        this.a = iClientSessionGyro;
        return new com.iizix.prop.a(this, iClientSessionGyro);
    }

    private void a(int n2) {
        PropCnr propCnr = new PropCnr();
        propCnr.setInt(Atom.SYSTEM, n2);
        this.triggerRemoteEvent(1, propCnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String string, String string2, WindowOptions windowOptions, IWindowCloseListener iWindowCloseListener) {
        if (this.isDisposed()) {
            return false;
        }
        PropCnr propCnr = this;
        synchronized (propCnr) {
            if (windowOptions == null || !windowOptions.spawn) {
                this.a = iWindowCloseListener;
            }
        }
        propCnr = new PropCnr();
        propCnr.setString(Atom.SYSTEM, string);
        if (string2 != null) {
            propCnr.setString("t", string2);
        }
        if (windowOptions != null) {
            propCnr.setString("o", windowOptions.getOptions());
        }
        this.triggerRemoteEvent(2, propCnr);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(boolean bl, boolean bl2, boolean bl3) {
        IWindowCloseListener iWindowCloseListener;
        if (this.isDisposed()) {
            return false;
        }
        EnvProps envProps = this;
        synchronized (envProps) {
            iWindowCloseListener = bl ? null : this.a;
            this.a = null;
        }
        if (bl2) {
            this.triggerRemoteEvent(3);
        }
        if (iWindowCloseListener != null) {
            try {
                iWindowCloseListener.onWindowClosed(bl3);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), "Failed invoking close window listener", throwable);
            }
        }
        return true;
    }

    private void a(String string, String string2) {
        PropCnr propCnr = new PropCnr();
        propCnr.setString("u", string);
        propCnr.setString("p", string2);
        this.triggerRemoteEvent(4, propCnr);
    }

    @Override
    public void onRemoteEvent(RemoteEvent remoteEvent) {
        switch (remoteEvent.getLocalID()) {
            case 3: {
                IRemoteSessionControlListener iRemoteSessionControlListener = this.a;
                if (iRemoteSessionControlListener != null) {
                    iRemoteSessionControlListener.onRemoteBrowserWindowClosed();
                }
                this.a(false, false, remoteEvent.getParameters() != null);
                break;
            }
            case 6: {
                this.f();
            }
        }
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        if (gEvent.isRemoteInduced()) {
            if (gEvent.isPropertyChange((PropCnr)this, "W") || gEvent.isPropertyChange((PropCnr)this, "H")) {
                this.d();
            } else if (gEvent.isPropertyChange((PropCnr)this, "SO")) {
                this.e();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        GenericListener<IScreenSizeListener> genericListener = this.b;
        if (genericListener != null && this.a != null) {
            EnvProps envProps = this;
            synchronized (envProps) {
                if (this.a) {
                    return;
                }
                this.a = true;
            }
            this.a.getClientWorker().post(() -> {
                Size size = this.getScreenSize();
                EnvProps envProps = this;
                synchronized (envProps) {
                    this.a = false;
                }
                if (!size.equals(this.a)) {
                    this.a = size;
                    genericListener.forEach(iScreenSizeListener -> iScreenSizeListener.onScreenSizeChanged(this.a, size));
                }
            });
        }
    }

    public synchronized boolean addScreenSizeListener(IScreenSizeListener iScreenSizeListener) {
        if (this.b == null) {
            this.b = new GenericListener<IScreenSizeListener>(IScreenSizeListener.class);
        }
        return this.b.addListener(iScreenSizeListener);
    }

    public synchronized boolean removeScreenSizeListener(IScreenSizeListener iScreenSizeListener) {
        return this.b != null ? this.b.removeListener(iScreenSizeListener) : false;
    }

    public int getScreenWidth() {
        return this.getInt("W");
    }

    public int getScreenHeight() {
        return this.getInt("H");
    }

    public Size getScreenSize() {
        return new Size(this.getInt("W"), this.getInt("H"));
    }

    private void e() {
        ScreenOrientation screenOrientation;
        GenericListener<IScreenOrientationListener> genericListener = this.c;
        if (genericListener != null && this.a != null && !(screenOrientation = this.getScreenOrientation()).equals((Object)this.a)) {
            this.a = screenOrientation;
            genericListener.forEach(iScreenOrientationListener -> iScreenOrientationListener.onScreenOrientationChanged(this.a, screenOrientation));
        }
    }

    public synchronized boolean addScreenOrientationListener(IScreenOrientationListener iScreenOrientationListener) {
        if (this.c == null) {
            this.c = new GenericListener<IScreenOrientationListener>(IScreenOrientationListener.class);
        }
        return this.c.addListener(iScreenOrientationListener);
    }

    public synchronized boolean removeScreenOrientationListener(IScreenOrientationListener iScreenOrientationListener) {
        return this.c != null ? this.c.removeListener(iScreenOrientationListener) : false;
    }

    public boolean isScreenOrientationLockSupported() {
        if (this.a < 0) {
            int n2 = this.a = this.getString("SO") != null ? 1 : 0;
        }
        return this.a == 1;
    }

    public ScreenOrientation getScreenOrientation() {
        String string;
        if (this.isScreenOrientationLockSupported() && (string = this.getString("SO")) != null) {
            ScreenOrientation[] screenOrientationArray = ScreenOrientation.values();
            int n2 = screenOrientationArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ScreenOrientation screenOrientation = screenOrientationArray[n3];
                if (string.equals(screenOrientation.clientOrientation)) {
                    return screenOrientation;
                }
                ++n3;
            }
        }
        return ScreenOrientation.unknown;
    }

    public boolean setScreenOrientation(ScreenOrientation screenOrientation) {
        if (screenOrientation == ScreenOrientation.unknown) {
            throw new IllegalArgumentException("unknown orientation cannot be set");
        }
        if (this.isScreenOrientationLockSupported()) {
            PropCnr propCnr = new PropCnr();
            propCnr.setBool(Atom.SYSTEM, screenOrientation.isPortrait);
            this.triggerRemoteEvent(5, propCnr);
            return true;
        }
        return false;
    }

    public boolean unlockScreenOrientation() {
        if (this.isScreenOrientationLockSupported()) {
            this.triggerRemoteEvent(5);
            return true;
        }
        return false;
    }

    public String getDeviceUUID() {
        return this.getDeviceUUID(false);
    }

    public String getDeviceUUID(boolean bl) {
        if (this.b != null) {
            return this.b;
        }
        StringMapProp stringMapProp = this.getClientEnv();
        String string = stringMapProp.getValue("izr.uuid");
        if (string != null) {
            this.b = string;
        } else if (!bl) {
            string = stringMapProp.getValue("izr.device") != null ? "browser" : "unknown";
        }
        return string;
    }

    public boolean configureStatusBar(StatusBarConfig statusBarConfig) {
        StatusBarConfig.Style style = statusBarConfig.getStyle();
        int n2 = statusBarConfig.getBackgroundColor();
        int n3 = statusBarConfig.getOverlaysWebView();
        int n4 = statusBarConfig.getVisibility();
        if (style == null && n2 < 0 && n3 < 0 && n4 < 0) {
            return false;
        }
        PropCnr propCnr = new PropCnr(Atom.SYSTEM);
        if (style != null) {
            propCnr.setInt("s", style.ordinal());
        }
        if (n2 >= 0) {
            propCnr.setInt("b", n2);
        }
        if (n3 >= 0) {
            propCnr.setInt("o", n3);
        }
        if (n4 >= 0) {
            propCnr.setInt("v", n4);
        }
        this.triggerRemoteEvent(6, propCnr);
        return true;
    }

    public synchronized boolean addStatusBarTapListener(IStatusBarTapListener iStatusBarTapListener) {
        if (this.a == null) {
            this.a = new GenericListener<IStatusBarTapListener>(IStatusBarTapListener.class);
        }
        return this.a.addListener(iStatusBarTapListener);
    }

    public synchronized boolean removeStatusBarTapListener(IStatusBarTapListener iStatusBarTapListener) {
        return this.a != null ? this.a.removeListener(iStatusBarTapListener) : false;
    }

    private void f() {
        IClientSessionGyro iClientSessionGyro = this.getClientSessionGyro();
        DeviceParameter[] deviceParameterArray = this.a;
        if (iClientSessionGyro != null && deviceParameterArray != null) {
            deviceParameterArray.forEach(iStatusBarTapListener -> iStatusBarTapListener.onStatusBarTapped(iClientSessionGyro));
        }
    }

    @FunctionalInterface
    private static interface a {
        public boolean isSupported(EnvProps var1) throws Exception;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static enum ClientCapability {
        Phone("Phone capabilities (smart or feature phone)", envProps -> {
            Detection detection = envProps.getDeviceDetectionFromUserAgent();
            return detection.isSmartphone() || detection.isFeaturePhone();
        }),
        Battery("Battery status capabilities", envProps -> false),
        Contacts("Contacts database capabilities", envProps -> false),
        Compass("Compass capabilities", envProps -> false),
        Camera("Camera capabilities", envProps -> false),
        Geolocation("Geolocation capabilities", envProps -> {
            GeoProps geoProps = envProps.getGeolocation();
            return geoProps != null && geoProps.isSupported();
        }),
        GPS("GPS capabilities", envProps -> {
            GeoProps geoProps = envProps.getGeolocation();
            return geoProps != null && geoProps.isSupported();
        }),
        Touch("Touch capabilities", envProps -> {
            Detection detection = envProps.getDeviceDetectionFromUserAgent();
            return detection.isSmartphone() || detection.isFeaturePhone();
        }),
        Mouse("Mouse capabilities (Desktop device)", envProps -> {
            Detection detection = envProps.getDeviceDetectionFromUserAgent();
            return detection.isDesktop();
        }),
        Pen("Pen capabilities", envProps -> false),
        Motion("Motion capabilities (accelerometer)", envProps -> false),
        Microphone("Microphone (sound capture) capabilities", envProps -> false),
        VideoCapture("Video capture capabilities", envProps -> false),
        Sound("Play music or basic sounds capabilities", envProps -> false),
        SpeechSynthesis("Speech synthesis (speech output)", envProps -> envProps.getSpeechSynthesis() != null),
        SpeechRecognition("Speech recognition (for commands and text input)", envProps -> envProps.getSpeechRecognition() != null),
        Vibration("Vibration capabilities", envProps -> false);

        public final String textID = "devcap." + this.name();
        public final String description;
        private final a a;

        private ClientCapability(String string2, a a2) {
            this.description = string2;
            this.a = a2;
        }

        public final String getEnglishDescription() {
            return this.description;
        }

        public final String getLocalizedDescription() {
            return LocaleString.asString(this.textID, this.description);
        }

        public final boolean isSupported(EnvProps envProps) {
            try {
                return this.a.isSupported(envProps);
            }
            catch (Throwable throwable) {
                ILog.WARNING(((Object)((Object)this)).getClass(), "Failed capability detection for " + this.name(), this.description, throwable);
                return false;
            }
        }
    }
}

