/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.comm.session;

import com.iizix.GConstants;
import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.SessionInfo;
import com.iizix.Utilities;
import com.iizix.comm.GCloseCodes;
import com.iizix.comm.GManagementConstants;
import com.iizix.comm.IClientTransactionProcessor;
import com.iizix.comm.ITransactionCreator;
import com.iizix.comm.ITransactionProcessor;
import com.iizix.comm.TransactionComm;
import com.iizix.comm.TransactionCommListener;
import com.iizix.comm.session.ISessionTransMgr;
import com.iizix.comm.session.SessionID;
import com.iizix.comm.session.SessionMgr;
import com.iizix.comm.statistics.SessionConnectionStatistics;
import com.iizix.comm.statistics.SessionStatistics;
import com.iizix.user.SessionUserIdentifier;
import com.iizix.virtual.VirtualThreads;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SessionTransMgr
implements GConstants,
GCloseCodes,
GManagementConstants,
ITransactionCreator,
TransactionCommListener,
ISessionTransMgr {
    private int a;
    private ITransactionProcessor a;
    private boolean a;
    private SessionID a;
    private SessionStatistics a;
    private final SendTransaction[] a;
    private int b;
    private int c = 1;
    private int d = 1;
    private TransactionComm a;
    private a a;
    private long a = new SessionStatistics();
    private boolean b;
    private static volatile /* synthetic */ int[] a;

    private static boolean a(Throwable throwable) {
        return throwable.getClass().getName().startsWith("org.eclipse.jetty.websocket.core.exception.");
    }

    public SessionTransMgr(ITransactionProcessor iTransactionProcessor) {
        this(iTransactionProcessor, null, 0);
    }

    public static boolean isReconnectionInstance(String string, String string2) {
        SessionID sessionID = SessionID.a(string);
        if (sessionID == null) {
            ILog.INFO(SessionID.class, "Attempt from " + string2 + " to reconnect to session ID " + string + " failed, it has been disposed of");
            return false;
        }
        return true;
    }

    public static SessionTransMgr createReconnectionInstance(SocketAddress socketAddress, String string, int n2) {
        SessionID sessionID = SessionID.a(string);
        if (sessionID == null) {
            return new SessionTransMgr(null, string, 0);
        }
        return new SessionTransMgr(((SessionTransMgr)sessionID.getTransactionManager()).a, string, n2);
    }

    private SessionTransMgr(ITransactionProcessor iTransactionProcessor, String string, int n2) {
        this.a = iTransactionProcessor;
        this.a = new SendTransaction[SessionMgr.getInstance().getMaxTransactionQueue()];
        if (string == null) {
            this.a = new SessionID(this, false);
        } else {
            this.a = new SessionID(this, true);
            this.a = new a();
            this.a.a = string;
            this.a.a = n2;
        }
    }

    public void assignTransactionComm(TransactionComm transactionComm) {
        this.a = transactionComm;
    }

    public ITransactionProcessor getProcessor() {
        return this.a;
    }

    @Override
    public SessionStatistics getSessionStatistics() {
        return this.a;
    }

    void a(long l2, long l3, long l4, long l5) {
        long l6 = this.a.getDormantStartTime();
        if (l6 != 0L) {
            var11_6 = l2 - l6;
            if (var11_6 >= l4) {
                ILog.INFO(this.getClass(), "Session dormant time-out reached: " + this.a.getLogString() + ", duration " + Utilities.formatDurationMillis(var11_6));
                this.dispose(false);
                return;
            }
        } else if (l5 >= 0L) {
            l6 = this.a.getLastActivityTime();
            var11_6 = l2 - l6;
            if (this.a != null && var11_6 >= Math.min(60000L, l5)) {
                ILog.INFO(this.getClass(), "Reconnect completion idle time-out reached: " + this.a.getLogString() + ", duration " + Utilities.formatDurationMillis(var11_6));
                this.dispose(false);
                return;
            }
            if (var11_6 >= l5) {
                ILog.INFO(this.getClass(), "Session idle time-out reached: " + this.a.getLogString() + ", duration " + Utilities.formatDurationMillis(var11_6));
                this.dispose(false);
                return;
            }
        }
        if (l2 - this.a >= l3) {
            try {
                TransactionComm transactionComm = this.a;
                if (transactionComm != null && transactionComm.isConnected()) {
                    this.a = System.currentTimeMillis();
                    transactionComm.sendHeartBeat();
                }
            }
            catch (IOException iOException) {
                ILog.INFO(this.getClass(), "Failed sending heart-beat to session " + this.a.getLogString() + ": " + iOException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                if (SessionTransMgr.a(runtimeException)) {
                    ILog.INFO(this.getClass(), "Failed sending heart-beat to session " + this.a.getLogString() + ": " + runtimeException.getMessage());
                }
                throw runtimeException;
            }
        }
    }

    public void dispose(boolean bl) {
        this.a.a(bl);
    }

    public synchronized SessionStatistics getStatisticsSnapshot() {
        return this.a.getStatisticsSnapshot();
    }

    public SessionID getSession() {
        return this.a;
    }

    public String getSessionID() {
        return this.a.getSessionID();
    }

    @Override
    public void doDispose(boolean bl) {
        ITransactionProcessor iTransactionProcessor;
        if (bl) {
            this.a = null;
        }
        ILog.INFO(this.getClass(), "Connection disposed: " + this.a.getLogString());
        this.a.setClosed(bl ? SessionConnectionStatistics.State.DISPOSED_ABORT : SessionConnectionStatistics.State.DISPOSED);
        if (bl) {
            this.b();
        } else {
            this.a(1000);
        }
        if (this.a && (iTransactionProcessor = this.a) != null) {
            iTransactionProcessor.onDisposed(this);
        }
    }

    private void b() {
        TransactionComm transactionComm = this.a;
        this.a = null;
        if (transactionComm != null) {
            transactionComm.close();
        }
    }

    public SessionConnectionStatistics.State getCurrentState() {
        return this.a.getCurrentState();
    }

    public boolean isConnected() {
        return this.a.getCurrentState() == SessionConnectionStatistics.State.CONNECTED;
    }

    public boolean isDisconnected() {
        SessionConnectionStatistics.State state = this.a.getCurrentState();
        return state == SessionConnectionStatistics.State.DISPOSED || state == SessionConnectionStatistics.State.DISPOSED_ABORT;
    }

    public boolean isPaused() {
        SessionConnectionStatistics.State state = this.a.getCurrentState();
        return state == SessionConnectionStatistics.State.PAUSED || state == SessionConnectionStatistics.State.BROKEN;
    }

    void a() {
        ILog.INFO(this.getClass(), "Connection paused: " + this.a.getLogString());
        this.a.setClosed(SessionConnectionStatistics.State.PAUSED);
        ITransactionProcessor iTransactionProcessor = this.a;
        if (iTransactionProcessor != null) {
            iTransactionProcessor.onPause(this);
        }
        this.b();
    }

    public boolean doPause() {
        TransactionComm transactionComm = this.a;
        if (transactionComm != null && transactionComm.isConnected()) {
            ILog.INFO(this.getClass(), "Connection paused: " + this.a.getLogString());
            this.a.setClosed(SessionConnectionStatistics.State.PAUSED);
            ITransactionProcessor iTransactionProcessor = this.a;
            if (iTransactionProcessor != null) {
                iTransactionProcessor.onPause(this);
            }
            this.a(4000);
            return true;
        }
        return false;
    }

    @Override
    public SendTransaction createTransaction() {
        TransactionComm transactionComm = this.a;
        return transactionComm != null ? transactionComm.createTransaction() : null;
    }

    @Override
    public synchronized void onCommConnected(TransactionComm transactionComm) {
        this.setProperty("original.remote.addr", transactionComm.getRemoteAddr());
        if (this.a == null && this.a != null) {
            transactionComm.close(4001, "iz!4001");
            this.dispose(true);
            return;
        }
        this.a = transactionComm;
        if (this.a != null) {
            String string = this.a.a;
            if (string == null) {
                ILog.SEVERE(this.getClass(), "Reconnection state present, but no ReconnectID is set");
                this.dispose(true);
                return;
            }
            this.a(string);
        } else {
            this.a.setConnected();
            SendTransaction sendTransaction = this.a(10);
            sendTransaction.appendString(this.a.getSessionID());
            sendTransaction.appendUnsigned((int)(SessionMgr.getInstance().getDormantTimeout() / 1000L));
            ITransactionProcessor iTransactionProcessor = this.a;
            if (iTransactionProcessor instanceof IClientTransactionProcessor) {
                IClientTransactionProcessor iClientTransactionProcessor = (IClientTransactionProcessor)iTransactionProcessor;
                iClientTransactionProcessor.appendPublicKey(sendTransaction);
            }
            this.a(sendTransaction, 0, true);
            this.a = true;
            this.a.onConnection(this);
        }
    }

    @Override
    public void onCommData(TransactionComm transactionComm, ReadTransaction readTransaction, int n2) {
        this.a.onReceived(readTransaction);
        this.b = false;
        try {
            this.a(readTransaction);
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), "Fatal error processing incoming transaction", "Reconnecting session = " + this.a.getFullLogInfo(), throwable);
            this.dispose(true);
        }
    }

    @Override
    public void onCommHeartBeat(TransactionComm transactionComm, long l2) {
        this.a.setHeartBeatDuration(l2);
    }

    @Override
    public void onCommTimeout(TransactionComm transactionComm, boolean bl) {
        if (bl) {
            this.requestPingPong();
        }
    }

    @Override
    public void onCommError(TransactionComm transactionComm, Throwable throwable) {
        if (this.b) {
            ILog.INFO("Session is disposed due to communication error upon remote request, error: error " + throwable.getMessage() + ", session " + this.a.getLogString());
            this.dispose(false);
            return;
        }
        String string = throwable.getMessage();
        if (string == null) {
            string = "<unknown>";
        }
        if (throwable instanceof IOException || SessionTransMgr.a(throwable)) {
            ILog.INFO(this.getClass(), "Session entering broken state due to communication error", string, "session " + this.a.getLogString());
        } else {
            ILog.SEVERE(this.getClass(), "Session entering broken state due to internal program error", string, "session " + this.a.getLogString(), throwable);
        }
        this.setProperty("comm.error", string);
        this.a.setClosed(SessionConnectionStatistics.State.BROKEN);
        ITransactionProcessor iTransactionProcessor = this.a;
        if (iTransactionProcessor != null) {
            iTransactionProcessor.onPause(this);
        }
        this.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommClosing(TransactionComm transactionComm) {
        SessionTransMgr sessionTransMgr = this;
        synchronized (sessionTransMgr) {
            SessionConnectionStatistics.State state = this.a.getCurrentState();
            ILog.INFO(this.getClass(), "Closing " + state.toString().toLowerCase() + " connection: session " + this.a.getLogString());
            if (state == SessionConnectionStatistics.State.BROKEN || state == SessionConnectionStatistics.State.PAUSED) {
                return;
            }
        }
        this.a.setClosed(SessionConnectionStatistics.State.CLOSING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCommClosed(TransactionComm transactionComm, int n2, String string) {
        String string2 = GCloseCodes.getCloseCodeDescription(n2);
        if (this.b) {
            ILog.INFO("Session is disposed due to connection closure upon remote request, session " + this.a.getLogString() + ", close code  [" + n2 + "] " + string2);
            this.dispose(false);
            return;
        }
        Object object = this;
        synchronized (object) {
            SessionConnectionStatistics.State state = this.a.getCurrentState();
            if (state == SessionConnectionStatistics.State.BROKEN || state == SessionConnectionStatistics.State.PAUSED) {
                ILog.INFO(this.getClass(), "Connection closed: " + state.toString().toLowerCase() + " session " + this.a.getLogString());
                return;
            }
        }
        if (string2 == null) {
            string2 = "";
        }
        if (n2 == 4000 || n2 > 1003 && n2 < 4000) {
            ILog.INFO(this.getClass(), "Connection paused due to connection closure [" + n2 + "] " + string2 + ", " + this.a.getLogString());
            this.a.setClosed(SessionConnectionStatistics.State.BROKEN);
            this.b();
            object = this.a;
            if (object != null) {
                object.onPause(this);
            }
        } else {
            ILog.INFO(this.getClass(), "Connection closed [" + n2 + "] " + string2 + ", " + this.a.getLogString());
            this.dispose(false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void a(ReadTransaction var1_1) {
        var2_2 = this.a.getSessionInfo().assignThread();
        try {
            block13: {
                var3_3 = var1_1.readUShort();
                if (var3_3 != 0) break block13;
                this.c(var1_1);
                ** GOTO lbl21
            }
            if (var3_3 != this.d) {
                ILog.SEVERE(this.getClass(), "Invalid serial received, expected " + this.d + " but got " + var3_3 + ", session " + this.a.getLogString());
                this.a.a(true);
                return;
            }
            if (++this.d > 65535) {
                this.d = 1;
            }
            if (this.a != null) {
                ILog.SEVERE(this.getClass(), "Invalid normal transaction code " + var1_1.getByte() + " received during reconnection phase, aborting session", new Object[]{this.a.getFullLogInfo(), "Serial = " + var3_3});
                this.doDispose(true);
                return;
            }
            try {
                this.b(var1_1);
lbl21:
                // 2 sources

                var4_5 = var1_1.getRemainingReadSize();
                if (var4_5 > 0) {
                    ILog.WARNING(this.getClass(), "Remaining data after transaction processing: size = " + var4_5, (Object)this.a.getFullLogInfo());
                }
            }
            catch (Throwable var3_4) {
                ILog.SEVERE(this.getClass(), "Failed transaction processing", new Object[]{this.a.getFullLogInfo(), var3_4});
                this.doDispose(true);
            }
        }
        finally {
            if (var2_2) {
                SessionInfo.unassignThread();
            }
        }
    }

    private void b(ReadTransaction readTransaction) {
        ReadTransaction readTransaction2;
        while ((readTransaction2 = readTransaction.readTransaction()) != null) {
            int n2 = readTransaction2.getByte();
            this.a.processTransaction(this, readTransaction2);
            int n3 = readTransaction2.getRemainingReadSize();
            if (n3 <= 0 || this.isDisconnected()) continue;
            ILog.WARNING(this.getClass(), "Remaining data after sub-transaction processing: code = " + n2 + ", size = " + n3, (Object)this.a.getFullLogInfo());
        }
    }

    private void c(ReadTransaction readTransaction) {
        ReadTransaction readTransaction2;
        while ((readTransaction2 = readTransaction.readTransaction()) != null) {
            int n2 = this.a(readTransaction2, readTransaction);
            int n3 = readTransaction2.getRemainingReadSize();
            if (n3 <= 0) continue;
            ILog.WARNING(this.getClass(), "Remaining data after management sub-transaction processing, code = " + n2 + ", size = " + n3, (Object)this.a.getFullLogInfo());
        }
    }

    private int a(ReadTransaction readTransaction, ReadTransaction readTransaction2) {
        int n2 = readTransaction.readByte();
        if (n2 != 127) {
            ILog.SEVERE(this.getClass(), "Unknown management sub-transaction received, code = " + n2, (Object)this.a.getFullLogInfo());
            this.dispose(true);
            return -1;
        }
        int n3 = readTransaction.readByte();
        switch (n3) {
            case 1: {
                int n4 = readTransaction.readByte();
                String string = readTransaction.readString();
                ILog.log(ILog.mapJSLogLevelToJava(n4), this.a.getLogString() + ": " + string);
                break;
            }
            case 11: {
                if (this.a == null) {
                    ILog.SEVERE(this.getClass(), "Reconnect instance is missing");
                    break;
                }
                if (this.a == null) {
                    ILog.SEVERE(this.getClass(), "Reconnect processor instance is missing");
                    break;
                }
                SessionTransMgr sessionTransMgr = (SessionTransMgr)this.a.getTransactionManager();
                this.a.a(this, this.a.a);
                ILog.INFO(SessionID.class, "Successful reconnection of session " + this.a.getLogString());
                this.a.setReconnected(sessionTransMgr.a);
                this.a = null;
                this.a.onReconnected(this);
                break;
            }
            case 12: {
                throw new InternalError("MT_RESEND_TRANS not implemented yet");
            }
            case 13: {
                this.b = true;
                break;
            }
            case 250: {
                this.a(readTransaction.readLong64());
                break;
            }
            case 251: {
                long l2 = System.nanoTime() - readTransaction.readLong64();
                this.a.onPong(l2);
                break;
            }
            case 252: {
                int n5 = readTransaction.readUShort();
                this.a(n5, null);
                break;
            }
            case 14: {
                SessionUserIdentifier sessionUserIdentifier = this.a.getSessionInfo().user;
                Object object = null;
                if (sessionUserIdentifier == null) {
                    object = "SessionUserIdentifier is not assigned";
                } else {
                    ITransactionProcessor iTransactionProcessor = this.a;
                    if (iTransactionProcessor instanceof IClientTransactionProcessor) {
                        IClientTransactionProcessor iClientTransactionProcessor = (IClientTransactionProcessor)iTransactionProcessor;
                        try {
                            iClientTransactionProcessor.updateAuthentication(readTransaction);
                        }
                        catch (Exception exception) {
                            ILog.SEVERE(this.getClass(), "Failed decrypting password:\n\n   >>>> PLEASE VERIFY JAVA INSTALLATION: JCE Jars must be installed in JDK's \"lib/security\" directory,\n\n        i.e. Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files\n\n", this.a.getFullLogInfo(), exception);
                            this.a.a(true);
                        }
                    } else {
                        object = "Transaction processor " + String.valueOf(this.a) + " does not implement " + IClientTransactionProcessor.class.getName();
                    }
                }
                if (object == null) break;
                ILog.SEVERE(this.getClass(), (String)object, (Object)this.a.getFullLogInfo());
                this.a.a(true);
                break;
            }
            default: {
                ILog.SEVERE(this.getClass(), "Unknown management transaction received, sub-code = " + n3, (Object)this.a.getFullLogInfo());
                this.a.a(true);
            }
        }
        return n3;
    }

    private void a(int n2) {
        TransactionComm transactionComm = this.a;
        if (transactionComm != null) {
            transactionComm.close(n2, "iz!" + n2);
            transactionComm = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void a(String string) {
        int n2;
        SessionID sessionID = SessionID.a(string);
        if (sessionID == null) {
            if (!SessionID.a(string)) {
                ILog.WARNING(SessionID.class, "Attempt from " + this.a.getLogString() + " to reconnect to session ID " + string + " failed: possible attack?", (Object)("Reconnection session = " + this.a.getFullLogInfo()));
                this.dispose(true);
                return;
            }
            ILog.INFO(SessionID.class, "Attempt from " + this.a.getLogString() + " to reconnect to session ID " + string + " failed: it has been disposed of");
            n2 = 4001;
        } else {
            SessionTransMgr sessionTransMgr;
            ILog.INFO(SessionID.class, "Reconnection to session ID " + string + " from " + this.a.getLogString());
            SessionTransMgr sessionTransMgr2 = sessionTransMgr = (SessionTransMgr)sessionID.getTransactionManager();
            synchronized (sessionTransMgr2) {
                System.err.println("\n\n*** Reconnect session, occupied = " + (sessionTransMgr.a != null) + " ***\n\n");
                if (sessionTransMgr.a != null) {
                    n2 = 4002;
                    ILog.WARNING(SessionID.class, "Cannot reconnect to already reconnecting session ID " + string + " from " + this.a.getLogString());
                } else {
                    sessionTransMgr.a = new a();
                    try {
                        SessionConnectionStatistics.State state = sessionTransMgr.getCurrentState();
                        switch (SessionTransMgr.a()[state.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 5: {
                                if (this.a++ < 5) {
                                    sessionTransMgr.a = null;
                                    VirtualThreads.getVirtualThreads().startThread(() -> {
                                        ILog.WARNING(SessionID.class, "Reconnect to " + String.valueOf((Object)state) + " session ID " + string + " from " + this.a.getLogString() + " --> pausing other session and attempting a retry.");
                                        if (!sessionTransMgr.doPause()) {
                                            sessionTransMgr.a();
                                        }
                                        try {
                                            Thread.sleep(300L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        ILog.WARNING(SessionID.class, "Retry of reconnection to session ID " + string + " from " + this.a.getLogString() + " again");
                                        this.a(string);
                                    });
                                    return;
                                }
                                n2 = 4002;
                                ILog.WARNING(SessionID.class, "Cannot reconnect to " + String.valueOf((Object)state) + " session ID " + string + " from " + this.a.getLogString() + ", retried connection " + this.a + " times with a waiting period of 300 milliseconds");
                                break;
                            }
                            case 3: 
                            case 4: {
                                SessionTransMgr sessionTransMgr3 = this;
                                synchronized (sessionTransMgr3) {
                                    Object object;
                                    SendTransaction[] sendTransactionArray = sessionTransMgr.a(this.a.a);
                                    if (sendTransactionArray == null) {
                                        n2 = 4003;
                                        break;
                                    }
                                    SendTransaction sendTransaction = this.a(11);
                                    this.d = sessionTransMgr.d;
                                    this.c = sessionTransMgr.c;
                                    sendTransaction.appendUShort(this.d);
                                    sendTransaction.appendUnsigned(sendTransactionArray.length);
                                    this.a(sendTransaction, 0, true);
                                    if (sendTransactionArray.length > 0) {
                                        SendTransaction[] sendTransactionArray2 = sendTransactionArray;
                                        int n3 = sendTransactionArray.length;
                                        int n4 = 0;
                                        while (n4 < n3) {
                                            object = sendTransactionArray2[n4];
                                            SendTransaction sendTransaction2 = this.a(12);
                                            sendTransaction2.append((SendTransaction)object);
                                            this.a(sendTransaction2, 0, true);
                                            ++n4;
                                        }
                                    }
                                    object = sessionTransMgr.a;
                                    this.a.a = this.a;
                                    this.a = object;
                                    this.a = sessionTransMgr.a;
                                }
                                ILog.INFO(SessionID.class, "Waiting for Client acknowledge of successful reconnection of session " + this.a.getLogString());
                                return;
                            }
                            case 6: 
                            case 7: {
                                n2 = 4001;
                                break;
                            }
                            default: {
                                ILog.SEVERE(this.getClass(), "Unknown current connection state = " + String.valueOf((Object)state), (Object)("Reconnection session = " + this.a.getFullLogInfo()));
                                this.dispose(true);
                                return;
                            }
                        }
                    }
                    finally {
                        sessionTransMgr.a = null;
                    }
                }
            }
        }
        this.a = null;
        this.a(n2);
        this.dispose(false);
    }

    private SendTransaction a(int n2) {
        SendTransaction sendTransaction = new SendTransaction();
        sendTransaction.appendByte(127);
        sendTransaction.appendByte(n2);
        return sendTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPingPong() {
        SendTransaction sendTransaction = this.a(250);
        sendTransaction.appendLong64(System.nanoTime());
        SessionTransMgr sessionTransMgr = this;
        synchronized (sessionTransMgr) {
            this.a(sendTransaction, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(long l2) {
        SendTransaction sendTransaction = this.a(251);
        sendTransaction.appendLong64(l2);
        SessionTransMgr sessionTransMgr = this;
        synchronized (sessionTransMgr) {
            this.a(sendTransaction, 0, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendTransaction(SendTransaction sendTransaction) {
        SendTransaction sendTransaction2 = this.a(252);
        SessionTransMgr sessionTransMgr = this;
        synchronized (sessionTransMgr) {
            sendTransaction2.appendUShort(this.d);
            sendTransaction.append(sendTransaction2);
            int n2 = this.c++;
            if (this.c > 65535) {
                this.c = 1;
            }
            this.a[this.b] = sendTransaction;
            this.b = (this.b + 1) % this.a.length;
            this.a.onSent(sendTransaction);
            return this.a(sendTransaction, n2, false);
        }
    }

    public void closeClientAuthenticationInfo(String string) {
        TransactionComm transactionComm = this.a;
        if (transactionComm != null) {
            transactionComm.close(4005, "iz!4005!" + string);
        }
        this.dispose(true);
    }

    public void closeClient(String string) {
        TransactionComm transactionComm = this.a;
        if (transactionComm != null) {
            transactionComm.close(4004, "iz!4004!" + string);
        }
        this.dispose(true);
    }

    private boolean a(SendTransaction sendTransaction, int n2, boolean bl) {
        TransactionComm transactionComm;
        if (bl) {
            this.a.onSent(sendTransaction.getTotalSendSize());
        }
        if ((transactionComm = this.a) == null || transactionComm.isClosed()) {
            ILog.WARNING(this.getClass(), "Communication to client closed, failed sending transaction, session " + this.a.getLogString());
            return false;
        }
        try {
            transactionComm.send(sendTransaction, n2, false);
            return true;
        }
        catch (EOFException eOFException) {
            ILog.WARNING(this.getClass(), "Failed sending transaction, EOF: " + eOFException.getMessage());
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), "Failed sending transaction", iOException);
        }
        catch (RuntimeException runtimeException) {
            if (SessionTransMgr.a(runtimeException)) {
                ILog.WARNING(this.getClass(), "Failed sending transaction", runtimeException);
            }
            throw runtimeException;
        }
        return false;
    }

    private boolean a(int n2, int[] nArray) {
        boolean bl = false;
        int n3 = 0;
        int n4 = -1;
        if (n2 == this.c) {
            bl = true;
        } else {
            n3 = this.c > n2 ? this.c - n2 : this.c + 65535 - n2;
            int n5 = this.a.length;
            if (n3 <= 0) {
                ILog.SEVERE(this.getClass(), "Failed getBacklogSendTransactions: count is invalid = " + n3, (Object)("Session = " + this.a.getFullLogInfo()));
            } else if (n3 > n5) {
                ILog.WARNING(this.getClass(), "Reconnection to session " + String.valueOf(this.a) + " impossible, transaction back-log is too deep", "Requested size = " + n3, "Maximum available = " + n5, "Session = " + this.a.getFullLogInfo());
            } else {
                n4 = (this.b - n3 + n5) % n5;
                if (n4 != this.b) {
                    int n6 = n4;
                    while ((n6 = (n6 - 1 + n5) % n5) != this.b) {
                        this.a[n6] = null;
                    }
                }
                bl = true;
            }
        }
        if (nArray != null) {
            nArray[0] = 0;
            nArray[1] = n4;
        }
        return bl;
    }

    private SendTransaction[] a(int n2) {
        int[] nArray = new int[2];
        if (!this.a(n2, nArray)) {
            return null;
        }
        int n3 = this.a.length;
        int n4 = nArray[0];
        SendTransaction[] sendTransactionArray = new SendTransaction[n4];
        int n5 = nArray[1];
        int n6 = 0;
        while (n6 < n4) {
            SendTransaction sendTransaction = this.a[n5];
            if (sendTransaction == null) {
                ILog.SEVERE(this.getClass(), "Failed getBacklogSendTransactions: backlog transaction has already been cleared", "Index = " + n5, "Session = " + this.a.getFullLogInfo());
                return null;
            }
            sendTransactionArray[n6] = sendTransaction;
            ++n6;
            n5 = (n5 + 1) % n3;
        }
        return sendTransactionArray;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[SessionConnectionStatistics.State.values().length];
        try {
            nArray[SessionConnectionStatistics.State.BROKEN.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.CLOSING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.CONNECTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.DISPOSED.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.DISPOSED_ABORT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.INITIALIZING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SessionConnectionStatistics.State.PAUSED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static class a {
        private String a;
        private int a;
        private SessionID a;

        private a() {
        }
    }
}

