/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.app.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import java.io.File;
import java.util.Locale;

public class ServerAppDistributionProps
extends PropCnr {
    public static final String DESTINATION_JAR = "destJar";
    public static final String OTHER_MODULES = "modules";
    public static final String INCLUDE_EXTERNALS = "includeExternals";
    public static final String JAR_SIGN = "jarSign";
    public static final String JAR_SEAL = "jarSeal";
    public static final String JAR_COMPRESSION = "jarCompression";
    public static final String JAR_OBFUSCATION = "jarObfuscation";
    public static final String INCLUDE_APP_SOURCE = "includeAppSource";
    public static final String GROUP_ID = "groupID";
    public static final String DEVELOPER_ID = "developerID";
    public static final String REGISTER_APP = "registerApp";
    public static final String REGISTERED_APP_ID = "registeredAppID";
    protected File projectDir;

    public ServerAppDistributionProps() {
    }

    public ServerAppDistributionProps(Atom atom) {
        super(atom);
    }

    public void setLoadedFile(File file) {
        this.projectDir = file.getParentFile();
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public ServerAppDistributionProps clone() {
        try {
            ServerAppDistributionProps serverAppDistributionProps = (ServerAppDistributionProps)super.clone();
            return serverAppDistributionProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public void setName(String string) {
        this.setString(Atom.NAME, string != null ? "" : string);
    }

    public String getName() {
        String string = this.getString(Atom.NAME);
        return string != null ? string : "";
    }

    public void setDescription(String string) {
        if (string == null) {
            this.removeProp2(Atom.DESCR);
        } else {
            this.setString(Atom.DESCR, string);
        }
    }

    public String getDescription() {
        return this.getString(Atom.DESCR);
    }

    public void setDestinationJar(String string) {
        this.setString(DESTINATION_JAR, string);
    }

    public String getDestinationJar() {
        return this.getString(DESTINATION_JAR);
    }

    public boolean doJarSign() {
        return this.getBool(JAR_SIGN, true);
    }

    public void setJarSign(boolean bl) {
        this.setBool(JAR_SIGN, bl);
    }

    public boolean doJarSeal() {
        return this.getBool(JAR_SEAL, true);
    }

    public void setJarSeal(boolean bl) {
        this.setBool(JAR_SEAL, bl);
    }

    public boolean doJarCompression() {
        return this.getBool(JAR_COMPRESSION, true);
    }

    public void setJarCompression(boolean bl) {
        this.setBool(JAR_COMPRESSION, bl);
    }

    public boolean doJarObfuscation() {
        return this.getBool(JAR_OBFUSCATION, false);
    }

    public void setJarObfuscation(boolean bl) {
        this.setBool(JAR_OBFUSCATION, bl);
    }

    public boolean doIncludeExternals() {
        return this.getBool(INCLUDE_EXTERNALS, true);
    }

    public void setIncludeExternals(boolean bl) {
        this.setBool(INCLUDE_EXTERNALS, bl);
    }

    public boolean doIncludeAppSource() {
        return this.getBool(INCLUDE_APP_SOURCE, false);
    }

    public void setIncludeAppSource(boolean bl) {
        this.setBool(INCLUDE_APP_SOURCE, bl);
    }

    public void setOtherModules(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            this.removeProp2(OTHER_MODULES);
        } else {
            this.setString(OTHER_MODULES, String.join((CharSequence)",", stringArray));
        }
    }

    public String[] getOtherModules() {
        String string = this.getString(OTHER_MODULES);
        return string != null ? string.split(",") : new String[]{};
    }

    public String getGroupID() {
        return this.getString(GROUP_ID, "").toLowerCase(Locale.ENGLISH);
    }

    public String getDeveloperID() {
        return this.getString(DEVELOPER_ID, "").toLowerCase(Locale.ENGLISH);
    }

    public boolean doRegisterApp() {
        return this.getBool(REGISTER_APP, false);
    }

    public String getAppID() {
        return this.getString(REGISTERED_APP_ID, "").toLowerCase(Locale.ENGLISH);
    }
}

