/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license;

import com.iizix.ILog;
import com.iizix.SystemConfig;
import com.iizix.Utilities;
import com.iizix.license.IAppBuilderLicenseSystem;
import com.iizix.license.IDesignerLicenseSystem;
import com.iizix.license.ILicenseLogger;
import com.iizix.license.IServerLicenseSystem;
import com.iizix.license.a;
import com.iizix.nio.DataPacket;
import com.iizix.security.CertificateHelper;
import com.iizix.util.JarClassLoader;
import com.iizix.util.MemoryJarFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LicenseSystem {
    private static final boolean a = SystemConfig.isDevelopmentMode;
    private static LicenseSystem a;
    public static final String[] PRODUCTS;
    private static URL a;
    private ClassLoader a;
    private Object a;
    private File a;
    private File b;
    private final boolean b;
    private ILicenseLogger a = new a(this);

    static {
        PRODUCTS = new String[]{"<other>", "iiziGo", "iiziServer - Development", "iiziServer - Standard", "iiziServer - Container", "iiziCluster"};
    }

    public static String formatProduct(int n2) {
        return n2 >= 0 && n2 < PRODUCTS.length ? PRODUCTS[n2] : "<unknown [+product+]>";
    }

    public static LicenseSystem getInstance() {
        return LicenseSystem.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LicenseSystem getInstance(Object object) {
        LicenseSystem licenseSystem = a;
        if (licenseSystem != null) return licenseSystem;
        Class<LicenseSystem> clazz = LicenseSystem.class;
        synchronized (LicenseSystem.class) {
            licenseSystem = a;
            if (licenseSystem != null) return licenseSystem;
            a = new LicenseSystem(new String(Utilities.decodeBase64("YnVpbGQuQnVpbGRNYW5nbGVkTGljZW5zZUphcg=="), Utilities.UTF8).equals(object));
            return a;
        }
    }

    public static void assignWebServerRoot(File file) {
        if (a == null && SystemConfig.isDevelopmentMode) {
            try {
                File file2 = new File(file.getParentFile().getParentFile(), new String(Utilities.decodeBase64("Y3VycmVudENlcnQuY2Vy"), StandardCharsets.UTF_8));
                if (file2.isFile()) {
                    a = file2.toURI().toURL();
                } else {
                    ILog.SEVERE(LicenseSystem.class, "Failed looking up the Code Signing certificate for the Web Server root");
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    private LicenseSystem(boolean bl) {
        if (SystemConfig.WEB_COMPRESS && CertificateHelper.getCodeSigningCertificates(LicenseSystem.class) == null && !bl) {
            throw new RuntimeException("LicenseSystem internal configuration error: version = " + SystemConfig.VERSION_BUILD + ", code is not signed, isTestMode = " + bl + ", SystemConfig.WEB_COMPRESS = " + SystemConfig.WEB_COMPRESS + ", SystemConfig.PROGUARD_PROCESSED = " + SystemConfig.PROGUARD_PROCESSED + ", isDevelopmentMode = " + SystemConfig.isDevelopmentMode);
        }
        this.b = bl;
    }

    public boolean prepare(Object object) throws IOException {
        return this.prepare(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepare(Object object, Class<?> clazz) throws IOException {
        if (this.a == null) {
            ClassLoader classLoader;
            Serializable serializable;
            Object object2;
            if (a && SystemConfig.isDevelopmentMode && clazz == null) {
                object2 = "/iizi/com.iizix.license/bin";
                if (!SystemConfig.isWindows) {
                    object2 = System.getProperty("user.home") + (String)object2;
                }
                if (!((File)(serializable = new File((String)object2).getCanonicalFile())).isDirectory()) {
                    throw new IOException("Cannot find IIZI Debug Source directory " + String.valueOf(serializable));
                }
                classLoader = new URLClassLoader(new URL[]{((File)serializable).toURI().toURL()}, object.getClass().getClassLoader());
                try {
                    classLoader.loadClass("com.iizix.license.impl.DesignerLicenseSystem");
                    this.a = classLoader;
                    this.a = object;
                    System.err.println("\n\n**** USING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                    System.err.println("\n\n**** USING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                    System.err.println("\n\n**** USING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("\n\n**** FAILED LOADING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                    System.err.println("\n\n**** FAILED LOADING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                    System.err.println("\n\n**** FAILED LOADING DEBUG CODE OF LICENSE SYSTEM ***\n\n");
                }
            }
            object2 = object;
            synchronized (object2) {
                if (this.a == null) {
                    Cipher cipher;
                    Object object3;
                    int n2;
                    Object object4;
                    Object object5;
                    URL uRL;
                    Object object6;
                    if (!SystemConfig.HAS_UNLIMITED_CRYPTO) {
                        throw new IOException("Unlimited cryptography strength is not enabled for the JRE/JDK");
                    }
                    serializable = clazz != null ? clazz : object.getClass();
                    classLoader = ((Class)serializable).getClassLoader();
                    this.a = object;
                    if (this.b) {
                        object6 = (Object[])object;
                        uRL = (URL)object6[0];
                        object5 = (X509Certificate)object6[1];
                    } else {
                        int n3;
                        object6 = ((Class)(clazz != null ? clazz : serializable)).getName().replace('.', '/');
                        uRL = classLoader.getResource(((String)object6).substring(0, n3 = ((String)object6).lastIndexOf(47)) + "/" + ((String)object6).substring(n3 + 1) + ".dat");
                        if (uRL == null) {
                            throw new IOException((String)(a ? "License URL in resource '" + ((String)object6).substring(0, n3) + "/" + ((String)object6).substring(n3 + 1) + ".dat' is not found" : "License URL is not found"));
                        }
                        if (SystemConfig.WEB_COMPRESS) {
                            int n4;
                            var10_12 = CertificateHelper.getCodeSigningCertificates(object.getClass());
                            if (var10_12 == null) {
                                throw new IOException("com.iizi*-[version].jar file is not signed!");
                            }
                            object4 = CertificateHelper.getCodeSigningCertificates(LicenseSystem.class);
                            if (object4 == null) {
                                throw new IOException("com.iizix.-[version].jar file is not signed!");
                            }
                            if (!Arrays.equals(var10_12, (Object[])object4)) {
                                throw new IOException("com.iizi*-[version].jar has non-matching signatures!");
                            }
                            object5 = var10_12[0];
                            n2 = n4 = var10_12.length;
                            while (--n2 > 0) {
                                object3 = ((X509Certificate)var10_12[n2]).getSubjectX500Principal().getName();
                                if (((String)object3).indexOf("CN=GlobalSign") >= 0 || (((String)object3).indexOf("CN=Sectigo ") >= 0 || n2 >= n4 - 1) && (((String)object3).indexOf("CN=AAA ") >= 0 || n2 != n4 - 1)) continue;
                                throw new IOException("Invalid signing certificate [index=" + n2 + "]: " + (String)object3);
                            }
                        } else {
                            var10_12 = a;
                            if (var10_12 == null) {
                                throw new IOException("Code Signing certificate URL not found");
                            }
                            try {
                                object4 = null;
                                Object var12_19 = null;
                                try (InputStream inputStream = var10_12.openStream();){
                                    object5 = CertificateHelper.loadCertificate(inputStream);
                                }
                                catch (Throwable throwable) {
                                    if (object4 == null) {
                                        object4 = throwable;
                                    } else if (object4 != throwable) {
                                        ((Throwable)object4).addSuppressed(throwable);
                                    }
                                    throw object4;
                                }
                            }
                            catch (IOException iOException) {
                                throw iOException;
                            }
                            catch (Exception exception) {
                                throw new IOException("Failed loading " + String.valueOf(var10_12), exception);
                            }
                        }
                    }
                    object6 = ((X509Certificate)object5).getSubjectX500Principal().getName();
                    if (((String)object6).indexOf("CN=Mindus SARL") < 0) {
                        throw new IOException("Invalid signing certificate: " + (String)object6);
                    }
                    object6 = ((X509Certificate)object5).getIssuerX500Principal().getName();
                    Date date = ((X509Certificate)object5).getNotBefore();
                    int n5 = date.getYear();
                    if (n5 == 125) {
                        if (((String)object6).indexOf("CN=Sectigo ") < 0) {
                            throw new IOException("Invalid signing certificate issuer: " + (String)object6);
                        }
                    } else {
                        throw new IOException("Invalid signing certificate issued date: " + String.valueOf(date) + ", to " + (String)object6);
                    }
                    try {
                        object4 = MessageDigest.getInstance("SHA-256");
                    }
                    catch (Exception exception) {
                        throw new IOException("Failed creating SHA-256 MessageDigest: Unlimited cryptography strength is not enabled for the JRE/JDK: " + exception.getMessage());
                    }
                    byte[] byArray = Utilities.readAllBytes(uRL);
                    n2 = byArray.length;
                    byArray = new DataPacket().decrypt(byArray, 0, n2);
                    object3 = new byte[16];
                    System.arraycopy(byArray, 0, object3, 0, 16);
                    ((MessageDigest)object4).update((byte[])object3);
                    try {
                        ((MessageDigest)object4).update(((Certificate)object5).getEncoded());
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IOException("Certificate error", certificateEncodingException);
                    }
                    byte[] byArray2 = ((MessageDigest)object4).digest();
                    if (byArray2.length != 32) {
                        throw new IOException("Illegal key length of SHA-256 fingerprint = " + byArray2.length);
                    }
                    ((MessageDigest)object4).update((byte[])object3);
                    ((MessageDigest)object4).update(byArray, 48, n2 -= 48);
                    byte[] byArray3 = ((MessageDigest)object4).digest();
                    int n6 = 32;
                    while (--n6 >= 0) {
                        if (byArray3[n6] == byArray[n6 + 16]) continue;
                        throw new IOException("License System code package tampering");
                    }
                    try {
                        cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                        cipher.init(2, (Key)new SecretKeySpec(byArray2, "AES"), new IvParameterSpec((byte[])object3));
                        byArray = cipher.doFinal(byArray, 48, n2);
                    }
                    catch (Throwable throwable) {
                        throw new IOException("Failed creating Cipher: Unlimited cryptography strength is not enabled for the JRE/JDK", throwable);
                    }
                    DataPacket dataPacket = new DataPacket();
                    Throwable throwable = null;
                    Object var20_35 = null;
                    try (MemoryJarFile memoryJarFile = MemoryJarFile.createJarFile(new ByteArrayInputStream(byArray, 0, byArray.length), true, false, null, (arg_0, arg_1) -> LicenseSystem.a(dataPacket, (MessageDigest)object4, cipher, arg_0, arg_1), -1L);){
                        JarClassLoader jarClassLoader = new JarClassLoader(memoryJarFile, classLoader);
                        jarClassLoader.initialize();
                        this.a = jarClassLoader;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        }
        return this.a != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getInstanceImplementation(Object object, Class<T> clazz) throws Throwable {
        if (clazz.equals(ILicenseLogger.class)) {
            return clazz.cast(this.a);
        }
        if (this.a == null) {
            throw new IOException("Failed loading license system: call to prepare() not done");
        }
        if (this.a == null) {
            throw new IOException("Failed loading license system: call to prepare() not done [lockObject missing]");
        }
        T t = null;
        Object object2 = this.a;
        synchronized (object2) {
            if (clazz.equals(IServerLicenseSystem.class)) {
                t = clazz.cast(this.a.loadClass("com.iizix.license.impl.ServerLicenseSystem").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            } else if (clazz.equals(IDesignerLicenseSystem.class)) {
                t = clazz.cast(this.a.loadClass("com.iizix.license.impl.DesignerLicenseSystem").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            } else if (clazz.equals(IAppBuilderLicenseSystem.class)) {
                t = clazz.cast(this.a.loadClass("com.iizix.license.impl.AppBuilderLicenseSystem").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        LicenseSystem licenseSystem = this;
        synchronized (licenseSystem) {
            if (this.a != null && this.a.isDirectory()) {
                try {
                    Utilities.deleteDirectoryRecursive(this.a.toPath(), new HashMap<File, IOException>());
                }
                catch (IOException | InvalidPathException exception) {
                    // empty catch block
                }
                if (!this.a.isDirectory()) {
                    this.a = null;
                }
                if (this.b != null && !this.b.isFile()) {
                    this.b = null;
                }
            }
        }
    }

    public static String getProfilePictureAsString(File file) throws IOException {
        if (!(file = Utilities.getCanonicalFile(file)).isFile()) {
            throw new FileNotFoundException("File \"" + file.getPath() + "\" is not found");
        }
        String string = file.getName();
        String string2 = string.toLowerCase();
        if (!(string2.endsWith(".jpg") || string2.endsWith(".jpeg") || string2.endsWith(".png"))) {
            throw new IOException("File extension for \"" + file.getPath() + "\" must be either .png, .jpg or .jpeg");
        }
        long l2 = file.length();
        if (l2 > 0x100000L) {
            throw new IOException("File \"" + file.getPath() + "\" is larger than 1 MB");
        }
        if (l2 <= 0L) {
            throw new IOException("File \"" + file.getPath() + "\": length is invalid");
        }
        try {
            byte[] byArray = Files.readAllBytes(file.toPath());
            byte[] byArray2 = string.getBytes(Utilities.UTF8);
            int n2 = byArray2.length;
            byte[] byArray3 = new byte[n2 + 1 + byArray.length];
            System.arraycopy(byArray2, 0, byArray3, 0, n2);
            System.arraycopy(byArray, 0, byArray3, n2 + 1, byArray.length);
            return Utilities.encodeBase64(byArray3);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("Invalid path: " + file.getAbsolutePath(), invalidPathException);
        }
    }

    public static byte[] getProfilePictureFromString(String string, StringBuilder stringBuilder) throws IOException {
        try {
            byte[] byArray = Utilities.decodeBase64(string);
            int n2 = byArray.length;
            int n3 = 0;
            while (true) {
                if (n3 == n2) {
                    throw new IOException("File name cannot be determined from the Base64 encoded data");
                }
                if (byArray[n3] == 0) break;
                ++n3;
            }
            String string2 = new String(byArray, 0, n3++, Utilities.UTF8);
            if (stringBuilder != null) {
                stringBuilder.setLength(0);
                stringBuilder.append(string2);
            }
            byte[] byArray2 = new byte[n2 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, n2 - n3);
            return byArray2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    private static /* synthetic */ byte[] a(DataPacket dataPacket, MessageDigest messageDigest, Cipher cipher, String string, byte[] byArray) throws IOException {
        byte[] byArray2;
        int n2 = byArray.length;
        byte[] byArray3 = dataPacket.decrypt(byArray, 0, n2);
        messageDigest.update(byArray3, 32, n2 -= 32);
        byte[] byArray4 = messageDigest.digest();
        try {
            byArray2 = cipher.doFinal(byArray3, 32, n2);
        }
        catch (BadPaddingException | IllegalBlockSizeException generalSecurityException) {
            throw new IOException("Failed deciphering Jar entry: " + generalSecurityException.getMessage());
        }
        int n3 = 32;
        while (--n3 >= 0) {
            if (byArray4[n3] == byArray3[n3]) continue;
            throw new IOException("Jar Entry \"" + string + "\" tampered");
        }
        return byArray2;
    }
}

