/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.run;

import com.iizigo.Activator;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizigo.run.EditorRuntimeBuilderJob;
import com.iizigo.run.EditorRuntimeBuilderPropertyPage;
import com.iizigo.run.IRuntimeBuilder;
import com.iizigo.run.prop.EditorRuntimeBuilderProps;
import com.iizix.app.CancelException;
import com.iizix.prop.GProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.RuntimeBuilderProps;
import com.iizix.run.BuilderError;
import com.iizix.run.RuntimeBuilderSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RuntimeBuilderLauncher
implements IEditorLauncher {
    public void open(IPath iPath) {
        Object object;
        iPath = iPath.makeAbsolute();
        Shell shell = Activator.getSomeShell();
        try {
            object = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            if (ProjectManager.getInstance().getModuleModel((IResource)object) != null) {
                RuntimeBuilderLauncher.launchBuild(shell, (IFile)object);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = iPath.toFile();
        try {
            PropCnr propCnr = Activator.loadPropertiesFile((File)object);
            if (!(propCnr instanceof EditorRuntimeBuilderProps)) {
                throw new PropException((GProp)propCnr, "iiziRun Builder property not found in file " + ((File)object).getAbsolutePath());
            }
            String string = ((File)object).getName().equals(".iiziRun") ? "" : " and the file name is not \".iiziRun\"";
            EditorRuntimeBuilderProps editorRuntimeBuilderProps = (EditorRuntimeBuilderProps)propCnr;
            List list = editorRuntimeBuilderProps.verifyTree(Activator.getInstance().getKStringInfoProvider());
            if (editorRuntimeBuilderProps.getPropTreeErrorSeverity(true) > 0 || list != null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (list != null) {
                    stringBuilder.append("\n\nProblems:");
                    for (String string2 : list) {
                        stringBuilder.append("\n - " + string2);
                    }
                }
                MessageDialog.openError((Shell)shell, (String)"iiziRun Builder", (String)("The iiziRun Builder file contains errors and can therefore not be used. As the file is not inside an open IIZI Module project" + string + ", it cannot be opened for editing." + String.valueOf(stringBuilder)));
                return;
            }
            MessageDialog.openInformation((Shell)shell, (String)"iiziRun Builder", (String)("The iiziRun Builder file is not inside an open IIZI Module project" + string + ", it can therefore not run inside the workbench. It can however run using the iiziRun Builder Command Line utility. This is however not yet supported, but can be done manually with a normal Java JRE without Eclipse."));
        }
        catch (PropException | IOException throwable) {
            Activator.openError(shell, "Open iiziRun Builder", "Failed to load the iiziRun Builder file.", throwable);
        }
    }

    public static boolean launchBuild(Shell shell, IFile iFile) throws CancelException {
        Object object2;
        RuntimeBuilderSettings runtimeBuilderSettings;
        IRuntimeBuilder iRuntimeBuilder;
        block16: {
            if (!iFile.getName().equals(".iiziRun")) {
                throw new CancelException("File name is not \".iiziRun\"");
            }
            ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(iFile.getProject());
            if (moduleModel == null) {
                throw new CancelException("File is not inside an open Module project");
            }
            if (!iFile.isAccessible()) {
                if (MessageDialog.openQuestion((Shell)shell, (String)"iiziRun Builder", (String)"Project is not enabled for iiziRun Builder.\n\nDo you wish to open the configuration for editing?")) {
                    PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)iFile, (String)EditorRuntimeBuilderPropertyPage.ID, null, null).open();
                }
                return false;
            }
            try {
                PropCnr propCnr = Activator.loadPropertiesFile(iFile);
                if (!(propCnr instanceof EditorRuntimeBuilderProps)) {
                    throw new CoreException((IStatus)Activator.createErrorStatus("iiziRun Builder property not found in Runtime Builder file " + String.valueOf(iFile.getFullPath())));
                }
                iRuntimeBuilder = Activator.getRuntimeCreation();
                if (iRuntimeBuilder == null) {
                    throw new CoreException((IStatus)Activator.createErrorStatus("iiziRun Builder plugin is not loaded or installed"));
                }
                EditorRuntimeBuilderProps editorRuntimeBuilderProps = (EditorRuntimeBuilderProps)propCnr;
                editorRuntimeBuilderProps.setup(moduleModel, iRuntimeBuilder);
                runtimeBuilderSettings = new RuntimeBuilderSettings((RuntimeBuilderProps)editorRuntimeBuilderProps);
                StringBuilder stringBuilder = null;
                List list = editorRuntimeBuilderProps.verifyTree(Activator.getInstance().getKStringInfoProvider());
                if (editorRuntimeBuilderProps.getPropTreeErrorSeverity(true) > 0 || list != null) {
                    stringBuilder = new StringBuilder();
                    if (list != null) {
                        stringBuilder.append("\n\nProblems:");
                        for (Object object2 : list) {
                            stringBuilder.append("\n - " + object2);
                        }
                    }
                } else {
                    object2 = iRuntimeBuilder.getRequiredTextIDs(runtimeBuilderSettings);
                    ArrayList arrayList = new ArrayList();
                    runtimeBuilderSettings.verify(true, true, iFile.getProject().getLocation().toFile(), object2, arrayList);
                    if (!arrayList.isEmpty()) {
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("\n\nProblems:");
                        for (BuilderError builderError : arrayList) {
                            stringBuilder.append("\n - ").append(builderError.isError ? "Error: " : "Warning: ").append(builderError.location).append(" - ").append(builderError.error);
                        }
                    }
                }
                if (stringBuilder == null) break block16;
                if (MessageDialog.openQuestion((Shell)shell, (String)"iiziRun Builder", (String)("The iiziRun Builder file contains errors and can therefore not run.\n\nDo you wish to open the configuration for editing?" + String.valueOf(stringBuilder)))) {
                    PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)iFile, (String)EditorRuntimeBuilderPropertyPage.ID, null, null).open();
                }
                return false;
            }
            catch (CoreException coreException) {
                Activator.openError(shell, "Open iiziRun Builder", coreException);
                return false;
            }
        }
        object2 = new EditorRuntimeBuilderJob(iFile.getProject(), runtimeBuilderSettings, iRuntimeBuilder);
        object2.schedule();
        return true;
    }
}

