@echo off

echo.
echo Starting iiziServer...
echo.

setlocal

:: Check for param 1 "debug" 
set DEBUG=
if /I "%1"=="-debug" shift & set DEBUG=-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=8888,server=y,suspend=n
if /I "%1"=="/debug" shift & set DEBUG=-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=8888,server=y,suspend=n

:: Change to root directory.
cd %~dp0..

:: Use the Java from the installation, if it contains a "jdk" directory.
set JAVA=java
if exist jdk\bin\java.exe set JAVA=%CD%\jdk\bin\java.exe

:: Launch standard iiziServer with ServerAdmin app only using standard Derby database server port.
set CMD=%JAVA% ^
 -Xmx512m -Xms256m %DEBUG% ^
 -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true ^
 -XX:+IgnoreUnrecognizedVMOptions --enable-preview -XX:+UseG1GC -XX:+UseStringDeduplication --add-modules=ALL-SYSTEM --enable-native-access=ALL-UNNAMED ^
 -cp .;lib;lib\*;lib\asm\*;lib\bc\*;commons\*;lib\compress\*;lib\image\*;lib\jackson\*;lib\jakarta\*;lib\jna\*;lib\json\*;lib\netty\*;lib\push\*;lib\web*;lib\conscrypt\*;lib\jetty\*;lib\jetty\compress\*;lib\jetty\http2\*;lib\jetty\http3\*;lib\jetty\quic\*;lib\jetty\ee11\*;lib\jetty\websocket\*;lib\jetty\ee11-websocket\*;lib\selenium\*;lib\selenium\deps\* ^
   com.iizix.server.StandardServer ^
    -config  conf\config-apps-only.iiziServer ^
    -dbport  1527 ^
    -dbdir   db ^
    -root    root ^
    -app     com.iizix.server.admin -appjar apps\iiziServerAdmin.jar ^ 
    %*

:: Show command and execute it.
echo %CMD%
%CMD%

endlocal
