/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs;

import com.iizix.prop.Atom;
import com.iizix.prop.FixedVirtualizedAbstractReference;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropReference;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.vs.IVSParticipant;
import com.iizix.prop.vs.VirtualSpace;

public class VSParticipantReference
extends FixedVirtualizedAbstractReference<IVSParticipant> {
    public VSParticipantReference() {
    }

    public VSParticipantReference(Atom atom) {
        super(atom);
    }

    public VSParticipantReference(Atom atom, String string) {
        super(atom, string);
    }

    public IVSParticipant getParticipant() {
        return (IVSParticipant)this.getTargetReference();
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.VirtualSpaceParticipant;
    }

    @Override
    public Class<IVSParticipant> getPropertyClass() {
        return IVSParticipant.class;
    }

    @Override
    protected boolean doPostResolve() {
        return true;
    }

    @Override
    public boolean isReferenceValid(GProp<?> gProp) {
        return gProp instanceof IVSParticipant;
    }

    public VirtualSpace getVirtualSpace() {
        PropCnr propCnr = this.getParent();
        if (propCnr != null && (propCnr = propCnr.getParent()) instanceof VirtualSpace) {
            return (VirtualSpace)propCnr;
        }
        return null;
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        if (!super.verify(propVerification)) {
            return false;
        }
        String string = this.getReference();
        if (string != null && !string.isEmpty()) {
            IVSParticipant iVSParticipant = this.getParticipant();
            if (iVSParticipant == null) {
                propVerification.add(new PropVerificationError("ns", PropVerificationError.Severity.WARNING, "VirtualSpace Participant", this, "VirtualSpace Participant '" + string + "' is not resolved", "DeleteProperty"));
            } else {
                PropCnr propCnr = this.getParent().getParent();
                if (!(propCnr instanceof VirtualSpace)) {
                    propVerification.add(new PropVerificationError("wild", PropVerificationError.Severity.ERROR, "VirtualSpace Participant", this, "This VirtualSpace Participant reference property '" + this.getReferencePropName() + "' is wild: not located in a VirtualSpace: " + String.valueOf(propCnr), "DeleteProperty"));
                } else {
                    VirtualSpace virtualSpace = (VirtualSpace)propCnr;
                    VirtualSpace virtualSpace2 = iVSParticipant.getVirtualSpace();
                    if (virtualSpace != virtualSpace2) {
                        String string2 = virtualSpace2 != null ? virtualSpace2.getReferencePropName() : "(none)";
                        propVerification.add(new PropVerificationError("back", PropVerificationError.Severity.ERROR, "VirtualSpace Participant", this, "VirtualSpace Participant '" + string + "' is not referenced correctly: it does not have a back-reference to this VirtualSpace but to '" + string2 + "'", "DeleteProperty"));
                    }
                }
            }
        }
        return true;
    }
}

