/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.chart.series;

import com.iizix.Value;
import com.iizix.event.IPostEventProcessing;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropCnrBooleanSettings;
import com.iizix.prop.IPropCnrColorSettings;
import com.iizix.prop.IPropCnrFillSettings;
import com.iizix.prop.IPropCnrFontSettings;
import com.iizix.prop.IPropCnrStrokeSettings;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.StringProp;
import com.iizix.prop.ui.chart.IChartContainer;
import com.iizix.prop.ui.chart.UIChart;
import com.iizix.prop.ui.chart.series.GSeriesValue;
import com.iizix.prop.ui.chart.series.ICreateValueFromVS;
import com.iizix.prop.ui.chart.series.NoValue;
import com.iizix.prop.ui.chart.series.SeriesColor;
import com.iizix.prop.ui.chart.series.SeriesFill;
import com.iizix.prop.ui.chart.series.SeriesFont;
import com.iizix.prop.ui.chart.series.SeriesOption;
import com.iizix.prop.ui.chart.series.SeriesStroke;
import com.iizix.prop.ui.chart.series.SeriesType;
import com.iizix.prop.ui.chart.series.SeriesValue;
import com.iizix.prop.ui.chart.series.Simple;
import com.iizix.prop.vs.IVSColumnListener;
import com.iizix.prop.vs.IVSComponent;
import com.iizix.prop.vs.IVSComponentState;
import com.iizix.prop.vs.VSColumnHeader;
import com.iizix.prop.vs.VSField;
import com.iizix.prop.vs.VSRelativeReference;
import com.iizix.prop.vs.VSRow;
import com.iizix.prop.vs.VSTable;
import java.util.ArrayList;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Series
extends PropCnr
implements IPropCnrBooleanSettings<SeriesOption>,
IPropCnrColorSettings<SeriesColor>,
IPropCnrFillSettings<SeriesFill>,
IPropCnrFontSettings<SeriesFont>,
IPropCnrStrokeSettings<SeriesStroke>,
IChartContainer,
IVSColumnListener {
    public static final String PLOT = "$plot";
    private static final String[] a = new String[]{"$vsc_v", "$vsc_x", "$vsc_y", "$vsc_s", "$vsc_o", "$vsc_h", "$vsc_m", "$vsc_l", "$vsc_c"};
    private VSTable a;
    private ICreateValueFromVS a;

    public Series(String string) {
        this(Atom.get(string));
        if (string.startsWith("$")) {
            throw new IllegalArgumentException("Name cannot start with '$'");
        }
    }

    public Series(Atom atom) {
        super(atom);
    }

    public Series() {
    }

    @Override
    public final boolean usesPropIndex() {
        return true;
    }

    public SeriesType getSeriesType() {
        GProp<?>[] gPropArray = this.getProps();
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            SeriesType seriesType;
            GProp<?> gProp = gPropArray[n3];
            if (gProp instanceof SeriesValue && (seriesType = ((SeriesValue)gProp).getSeriesType()) != null && seriesType != SeriesType.NO_VALUE) {
                return seriesType;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public final IChartContainer.Type getContainerType() {
        return IChartContainer.Type.SERIES;
    }

    @Override
    public Series clone() {
        try {
            Series series = (Series)super.clone();
            series.a = null;
            return series;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public List<GSeriesValue> getValuesList() {
        ArrayList<GSeriesValue> arrayList = new ArrayList<GSeriesValue>();
        GProp<?>[] gPropArray = this.getProps();
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GProp<?> gProp = gPropArray[n3];
            if (gProp instanceof SeriesValue) {
                arrayList.add(((SeriesValue)gProp).getValue());
            }
            ++n3;
        }
        return arrayList;
    }

    public GSeriesValue[] getValues() {
        List<GSeriesValue> list = this.getValuesList();
        return list.toArray(new GSeriesValue[list.size()]);
    }

    public SeriesValue getValuesProp(int n2) {
        if (n2 >= 0) {
            GProp<?>[] gPropArray = this.getProps();
            int n3 = gPropArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GProp<?> gProp = gPropArray[n4];
                if (gProp instanceof SeriesValue && n2-- == 0) {
                    return (SeriesValue)gProp;
                }
                ++n4;
            }
        }
        return null;
    }

    public GSeriesValue getValue(int n2) {
        SeriesValue seriesValue = this.getValuesProp(n2);
        return seriesValue != null ? seriesValue.getValue() : null;
    }

    public Series addValue(GSeriesValue gSeriesValue) {
        this.addProp2(new SeriesValue(this.createUniqueAtom(""), gSeriesValue));
        return this;
    }

    public Series addValues(GSeriesValue ... gSeriesValueArray) {
        GSeriesValue[] gSeriesValueArray2 = gSeriesValueArray;
        int n2 = gSeriesValueArray.length;
        int n3 = 0;
        while (n3 < n2) {
            GSeriesValue gSeriesValue = gSeriesValueArray2[n3];
            this.addProp2(new SeriesValue(this.createUniqueAtom(""), gSeriesValue));
            ++n3;
        }
        return this;
    }

    public Series addValue(double d2) {
        this.addProp2(new SeriesValue(this.createUniqueAtom(""), new Simple(d2)));
        return this;
    }

    public Series addValues(double ... dArray) {
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double d2 = dArray2[n3];
            this.addProp2(new SeriesValue(this.createUniqueAtom(""), new Simple(d2)));
            ++n3;
        }
        return this;
    }

    public Series addNoValue() {
        return this.addValue(NoValue.NO_VALUE);
    }

    public boolean removeValue(int n2) {
        if (n2 >= 0) {
            GProp<?>[] gPropArray = this.getProps();
            int n3 = gPropArray.length;
            int n4 = 0;
            while (n4 < n3) {
                GProp<?> gProp = gPropArray[n4];
                if (gProp instanceof SeriesValue && n2-- == 0) {
                    return this.removeProp2(gProp);
                }
                ++n4;
            }
        }
        return false;
    }

    public int getValueCount() {
        int n2 = 0;
        GProp<?>[] gPropArray = this.getProps();
        int n3 = gPropArray.length;
        int n4 = 0;
        while (n4 < n3) {
            GProp<?> gProp = gPropArray[n4];
            if (gProp instanceof SeriesValue) {
                ++n2;
            }
            ++n4;
        }
        return n2;
    }

    public boolean removeAllValues() {
        boolean bl = false;
        GProp<?>[] gPropArray = this.getProps();
        int n2 = gPropArray.length;
        while (--n2 >= 0) {
            if (!(gPropArray[n2] instanceof SeriesValue)) continue;
            bl |= this.removeProp2(gPropArray[n2]);
        }
        return bl;
    }

    public Series setPlot(String string) {
        if (string == null) {
            this.removeProp2(PLOT);
        } else {
            String string2 = Atom.validateName(string, false);
            if (string2 != null) {
                throw new IllegalArgumentException("Plot name " + string2);
            }
            this.setString(PLOT, string);
        }
        return this;
    }

    public String getPlot() {
        return this.getString(PLOT);
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        String string;
        if (!super.verify(propVerification)) {
            return false;
        }
        UIChart uIChart = this.getChart();
        StringProp stringProp = this.getProp(PLOT, StringProp.class);
        if (stringProp != null && uIChart != null && (string = stringProp.getString()) != null && uIChart.getPlot(string) == null) {
            propVerification.add(new PropVerificationError("plot", PropVerificationError.Severity.ERROR, "Plot", stringProp, "The plot name '" + string + "' is not found", new String[0]));
        }
        return true;
    }

    public boolean hasConnection(int n2) {
        if (n2 < 0) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        return false;
    }

    public VSTable getVSTable() {
        return this.a;
    }

    private void d() {
        UIChart uIChart = this.getChart();
        if (uIChart != null) {
            uIChart.refresh();
        }
    }

    @Override
    public void onResolved(VSRelativeReference<?> vSRelativeReference, VSColumnHeader vSColumnHeader) {
        this.d();
    }

    @Override
    public void onBroken(VSRelativeReference<?> vSRelativeReference, VSColumnHeader vSColumnHeader) {
        this.d();
    }

    @Override
    public Value.Type getBestVSColumnHeaderValueType(VSRelativeReference<?> vSRelativeReference) {
        return null;
    }

    @Override
    public void onStateChanged(VSColumnHeader vSColumnHeader, IVSComponentState.State state, boolean bl) {
        this.d();
    }

    @Override
    public void onSingleSelectionChanged(VSColumnHeader vSColumnHeader, int n2) {
        this.d();
    }

    @Override
    public void onSelectionChanged(VSColumnHeader vSColumnHeader, VSRow vSRow, int n2, boolean bl) {
        this.d();
    }

    @Override
    public void onRowAdded(VSColumnHeader vSColumnHeader, VSRow vSRow, int n2) {
        this.d();
    }

    @Override
    public void onRowRemoved(VSColumnHeader vSColumnHeader, VSRow vSRow, int n2) {
        this.d();
    }

    @Override
    public void onStateChanged(VSColumnHeader vSColumnHeader, VSField vSField, IVSComponentState.State state, boolean bl) {
        this.d();
    }

    @Override
    public void onCellValueChanged(VSColumnHeader vSColumnHeader, VSField vSField, Value value, GProp<?> gProp, IPostEventProcessing iPostEventProcessing) {
        this.d();
    }

    @Override
    public void onParentStateChanged(IVSComponent iVSComponent, IVSComponentState.State state, boolean bl) {
        this.d();
    }

    public void updateContents() {
        VSTable vSTable = this.a;
        if (vSTable == null) {
            return;
        }
    }
}

