/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.java.classpath;

import com.iizigo.Activator;
import com.iizigo.java.classpath.IzClasspathContainer;
import com.iizix.ILog;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class IzClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath iPath, IJavaProject iJavaProject) throws CoreException {
        IzClasspathContainer.Type type = IzClasspathContainer.Type.fromPath(iPath);
        if (type == null) {
            throw new CoreException((IStatus)Activator.createErrorStatus("Unknown container path: " + String.valueOf(iPath)));
        }
        IzClasspathContainer izClasspathContainer = new IzClasspathContainer(type, iJavaProject.getProject());
        JavaCore.setClasspathContainer((IPath)iPath, (IJavaProject[])new IJavaProject[]{iJavaProject}, (IClasspathContainer[])new IClasspathContainer[]{izClasspathContainer}, null);
    }

    public String getDescription(IPath iPath, IJavaProject iJavaProject) {
        IzClasspathContainer.Type type = IzClasspathContainer.Type.fromPath(iPath);
        return type != null ? type.getDescription() : "Unknown container path: " + String.valueOf(iPath);
    }

    public static boolean addContainer(IzClasspathContainer.Type type, IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.getRawClasspath()));
        IClasspathEntry iClasspathEntry = arrayList.iterator();
        while (iClasspathEntry.hasNext()) {
            object = iClasspathEntry.next();
            if (object == null) {
                iClasspathEntry.remove();
                bl = true;
                continue;
            }
            IzClasspathContainer.Type type2 = IzClasspathContainer.Type.fromPath(object.getPath());
            if (type.equals((Object)type2)) {
                bl2 = true;
                continue;
            }
            if (type2 == null) continue;
            bl = true;
            iClasspathEntry.remove();
        }
        if (bl2 && !bl) {
            if (IzClasspathContainer.a) {
                ILog.INFO(IzClasspathContainerInitializer.class, (String)"IzClasspathContainerInitializer.addContainer - classpath (type found, no changes)");
            }
            return false;
        }
        iClasspathEntry = null;
        if (!bl2) {
            iClasspathEntry = JavaCore.newContainerEntry((IPath)type.getPath());
            arrayList.add(iClasspathEntry);
        }
        if (IzClasspathContainer.a) {
            object = new StringBuilder("IzClasspathContainerInitializer.addContainer - classpath (type found = ").append(bl2).append(", changed = ").append(bl).append(", added = ").append(iClasspathEntry).append("):");
            for (IClasspathEntry iClasspathEntry2 : arrayList) {
                ((StringBuilder)object).append("\n - ").append(iClasspathEntry2.toString());
            }
            ILog.INFO(IzClasspathContainerInitializer.class, (String)((StringBuilder)object).toString());
        }
        iJavaProject.setRawClasspath(arrayList.toArray(new IClasspathEntry[arrayList.size()]), iProgressMonitor);
        return true;
    }

    public static boolean removeContainers(IJavaProject iJavaProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IClasspathEntry iClasspathEntry;
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iJavaProject.readRawClasspath()));
        boolean bl = false;
        StringBuilder stringBuilder = null;
        if (IzClasspathContainer.a) {
            stringBuilder = new StringBuilder("\n\n-------------\nIzClasspathContainerInitializer.removeContainers, project = ").append(iJavaProject.getProject().getName()).append(':');
        }
        IClasspathEntry[] iClasspathEntryArray = arrayList.iterator();
        while (iClasspathEntryArray.hasNext()) {
            iClasspathEntry = iClasspathEntryArray.next();
            IzClasspathContainer.Type type = IzClasspathContainer.Type.fromClasspathEntry(iClasspathEntry);
            if (type == null) continue;
            if (stringBuilder != null) {
                if (!bl) {
                    stringBuilder.append("n - Removing containers:");
                }
                stringBuilder.append("\n   * ").append(iClasspathEntry);
            }
            iClasspathEntryArray.remove();
            bl = true;
        }
        if (!bl) {
            if (stringBuilder != null) {
                ILog.INFO(IzClasspathContainerInitializer.class, (String)stringBuilder.toString());
            }
            return false;
        }
        iClasspathEntryArray = arrayList.toArray(new IClasspathEntry[arrayList.size()]);
        if (stringBuilder != null) {
            stringBuilder.append("\n - Remaining entries:");
            IClasspathEntry[] iClasspathEntryArray2 = iClasspathEntryArray;
            int n2 = iClasspathEntryArray.length;
            int n3 = 0;
            while (n3 < n2) {
                iClasspathEntry = iClasspathEntryArray2[n3];
                stringBuilder.append("\n   + ").append(iClasspathEntry.toString());
                ++n3;
            }
            ILog.INFO(IzClasspathContainerInitializer.class, (String)stringBuilder.toString());
        }
        iJavaProject.setRawClasspath(iClasspathEntryArray, iProgressMonitor);
        return true;
    }
}

