/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.chat.WorkspaceSymbol;
import com.tabnine.eclipse.shared.api.chat.WorkspaceSymbolKind;
import com.tabnine.eclipse.shared.api.chat.WorkspaceSymbolRange;
import com.tabnine.eclipse.shared.api.services.SymbolResult;
import com.tabnine.eclipse.shared.api.services.SymbolsService$1;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SymbolsService {
    private static SymbolsService instance;

    public static SymbolsService getInstance() {
        if (instance == null) {
            instance = new SymbolsService();
        }
        return instance;
    }

    public static SymbolResult getWorkspaceSymbols(String string, String string2, int n2) {
        int n3;
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        LinkedList<WorkspaceSymbol> linkedList = new LinkedList<WorkspaceSymbol>();
        LinkedList<WorkspaceSymbol> linkedList2 = new LinkedList<WorkspaceSymbol>();
        IProject[] iProjectArray = iWorkspace.getRoot().getProjects();
        int n4 = iProjectArray.length;
        int n5 = 0;
        while (n5 < n4) {
            iWorkspace = iProjectArray[n5];
            if (SymbolsService.isJavaProject((IProject)iWorkspace)) {
                if (atomicInteger.get() >= n2) break;
                SymbolsService.populateWorkspaceSymbolsFromProject(JavaCore.create((IProject)iWorkspace), string, n2, atomicInteger, string2, linkedList, linkedList2);
            }
            ++n5;
        }
        if ((n3 = n2 - (linkedList.size() + linkedList2.size())) > 0) {
            linkedList2.addAll(SymbolsService.getFilesSymbols(string, n3));
        }
        return new SymbolResult(linkedList, linkedList2);
    }

    private static boolean isJavaProject(IProject iProject) {
        try {
            return iProject.isNatureEnabled("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static List<WorkspaceSymbol> getFilesSymbols(String object, int n2) {
        object = SymbolsService.getSourceFilesInProject((String)object, n2);
        LinkedList<WorkspaceSymbol> linkedList = new LinkedList<WorkspaceSymbol>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (IFile)iterator.next();
            linkedList.add(new WorkspaceSymbol(object.getName(), WorkspaceSymbolKind.File, object.getFullPath().toString(), object.getProjectRelativePath().toString(), new WorkspaceSymbolRange()));
        }
        return linkedList;
    }

    public static Optional<IProject> getCurrentProject() {
        return Optional.ofNullable(PlatformUI.getWorkbench().getActiveWorkbenchWindow()).map(IWorkbenchWindow::getActivePage).map(IWorkbenchPage::getActiveEditor).filter(iEditorPart -> iEditorPart.getEditorInput() instanceof IFileEditorInput).map(iEditorPart -> ((IFileEditorInput)iEditorPart.getEditorInput()).getFile()).map(IResource::getProject);
    }

    private static List<IFile> getSourceFilesInProject(String string, int n2) {
        String string2 = "\\.settings|\\.git|\\.DS_Store|\\.log$|\\.tmp$|\\.class$|/node_modules/|/dist/|/out/|/build/|/__pycache__/";
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        SymbolsService.getCurrentProject().ifPresent(iProject -> {
            try {
                iProject.accept(arg_0 -> SymbolsService.lambda$6((List)arrayList, n2, string, string2, arg_0));
                return;
            }
            catch (CoreException coreException) {
                arrayList = coreException;
                coreException.printStackTrace();
                return;
            }
        });
        return arrayList;
    }

    private static void populateWorkspaceSymbolsFromProject(IJavaProject object, String string, int n2, AtomicInteger atomicInteger, String string2, List<WorkspaceSymbol> list, List<WorkspaceSymbol> list2) {
        block11: {
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = object.getPackageFragmentRoots();
                int n3 = iPackageFragmentRootArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = iPackageFragmentRootArray[n4];
                    if (atomicInteger.get() < n2) {
                        if (SymbolsService.isSourceRoot((IPackageFragmentRoot)object)) {
                            IJavaElement[] iJavaElementArray = object.getChildren();
                            int n5 = iJavaElementArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                object = iJavaElementArray[n6];
                                if (atomicInteger.get() >= n2) break;
                                if (object instanceof IPackageFragment) {
                                    object = (IPackageFragment)object;
                                    ICompilationUnit[] iCompilationUnitArray = object.getCompilationUnits();
                                    int n7 = iCompilationUnitArray.length;
                                    int n8 = 0;
                                    while (n8 < n7) {
                                        object = iCompilationUnitArray[n8];
                                        if (atomicInteger.get() >= n2) break;
                                        Object object2 = SymbolsService.getWorkspaceSymbolsFromCompilationUnit((ICompilationUnit)object, string, n2 - atomicInteger.get(), atomicInteger).collect(Collectors.toList());
                                        if ((object = object.getResource()) != null && object.getLocation() != null) {
                                            object = object.getLocation().toOSString();
                                            Iterator iterator = object2.iterator();
                                            while (iterator.hasNext()) {
                                                object2 = (WorkspaceSymbol)iterator.next();
                                                if (((String)object).equalsIgnoreCase(string2)) {
                                                    list.add((WorkspaceSymbol)object2);
                                                    continue;
                                                }
                                                list2.add((WorkspaceSymbol)object2);
                                            }
                                        }
                                        ++n8;
                                    }
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                        continue;
                    }
                    break block11;
                }
                return;
            }
            catch (JavaModelException javaModelException) {
                object = javaModelException;
                javaModelException.printStackTrace();
            }
        }
    }

    private static boolean isSourceRoot(IPackageFragmentRoot iPackageFragmentRoot) {
        try {
            IResource iResource = iPackageFragmentRoot.getResource();
            return iPackageFragmentRoot.getKind() == 1 && iResource != null && iResource.getLocation() != null && iResource.isAccessible();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private static Stream<WorkspaceSymbol> getWorkspaceSymbolsFromCompilationUnit(ICompilationUnit object, String string, int n2, AtomicInteger atomicInteger) {
        ArrayList arrayList = new ArrayList();
        ASTParser aSTParser = ASTParser.newParser((int)15);
        aSTParser.setSource(object);
        aSTParser.setResolveBindings(false);
        aSTParser.setKind(8);
        aSTParser = (CompilationUnit)aSTParser.createAST(null);
        object = object.getResource();
        if (object == null || object.getLocation() == null || object.getProjectRelativePath() == null) {
            return arrayList.stream();
        }
        String string2 = object.getLocation().toOSString();
        object = object.getProjectRelativePath().toString();
        aSTParser.accept((ASTVisitor)new SymbolsService$1(arrayList, n2, string, string2, (String)object, (CompilationUnit)aSTParser, atomicInteger));
        return arrayList.stream();
    }

    private static WorkspaceSymbolRange getWorkspaceSymbolRange(CompilationUnit compilationUnit, ASTNode aSTNode) {
        int n2 = compilationUnit.getLineNumber(aSTNode.getStartPosition());
        int n3 = compilationUnit.getColumnNumber(aSTNode.getStartPosition());
        int n4 = aSTNode.getStartPosition() + aSTNode.getLength();
        int n5 = compilationUnit.getLineNumber(n4);
        int n6 = compilationUnit.getColumnNumber(n4);
        return new WorkspaceSymbolRange(n2, n3, n5, n6);
    }

    public static String getFileContent(String object) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            try {
                object = new BufferedReader(new FileReader((String)object));
                try {
                    String string;
                    while ((string = ((BufferedReader)object).readLine()) != null) {
                        stringBuilder.append(string).append(System.lineSeparator());
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return "";
        }
        return stringBuilder.toString();
    }

    public static String getFileContent(String object, WorkspaceSymbolRange workspaceSymbolRange) {
        int n2 = workspaceSymbolRange.getStartLine();
        int n3 = workspaceSymbolRange.getStartCharacter();
        int n4 = workspaceSymbolRange.getEndLine();
        int n5 = workspaceSymbolRange.getEndCharacter();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Throwable throwable = null;
            try {
                object = new LineNumberReader(new FileReader((String)object));
                try {
                    int n6 = 1;
                    while (n6 < n2) {
                        ((LineNumberReader)object).readLine();
                        ++n6;
                    }
                    if (n2 == n4) {
                        stringBuilder.append(SymbolsService.extractSingleLineContent((LineNumberReader)object, n3, n5));
                    } else {
                        stringBuilder.append(SymbolsService.extractStartLineContent((LineNumberReader)object, n3));
                        n6 = n2 + 1;
                        while (n6 < n4) {
                            String string = ((LineNumberReader)object).readLine();
                            if (string != null) {
                                stringBuilder.append(string).append(System.lineSeparator());
                            }
                            ++n6;
                        }
                        stringBuilder.append(SymbolsService.extractEndLineContent((LineNumberReader)object, n5));
                    }
                }
                finally {
                    ((BufferedReader)object).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return "";
        }
        return stringBuilder.toString();
    }

    private static String extractSingleLineContent(LineNumberReader object, int n2, int n3) {
        if ((object = ((LineNumberReader)object).readLine()) == null || ((String)object).isEmpty()) {
            return "";
        }
        return ((String)object).substring(n2, Math.min(n3, ((String)object).length()));
    }

    private static String extractStartLineContent(LineNumberReader object, int n2) {
        if ((object = ((LineNumberReader)object).readLine()) == null) {
            return "";
        }
        return String.valueOf(((String)object).substring(n2)) + System.lineSeparator();
    }

    private static String extractEndLineContent(LineNumberReader object, int n2) {
        if ((object = ((LineNumberReader)object).readLine()) == null) {
            return "";
        }
        return ((String)object).substring(0, Math.min(n2, ((String)object).length()));
    }

    private static /* synthetic */ boolean lambda$6(List list, int n2, String string, String string2, IResource iResource) {
        if (iResource.getType() != 1) {
            return true;
        }
        if (list.size() < n2 && iResource.getName().toLowerCase().startsWith(string.toLowerCase()) && !iResource.getFullPath().toString().matches(string2)) {
            list.add((IFile)iResource);
        }
        return false;
    }
}

