/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineDeadException;
import com.tabnine.eclipse.shared.api.services.ConfigService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.ui.PlatformUI;

public class BinaryProcessGateway {
    private Process process = null;
    private BufferedReader reader = null;

    public void init(List<String> object) {
        object = new ProcessBuilder((List<String>)object);
        this.setProxyEnvironmentVariables(((ProcessBuilder)object).environment());
        this.process = ((ProcessBuilder)object).start();
        this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream(), StandardCharsets.UTF_8));
    }

    private void setProxyEnvironmentVariables(Map<String, String> map) {
        Object object = PlatformUI.getWorkbench();
        object = (IProxyService)object.getService(IProxyService.class);
        List<String> list = Arrays.asList("HTTP_PROXY", "http_proxy");
        List<String> list2 = Arrays.asList("HTTPS_PROXY", "https_proxy");
        List<String> list3 = Arrays.asList("NO_PROXY", "no_proxy");
        if (object.isProxiesEnabled()) {
            this.setProxyEnvVariables(map, object.getProxyData("HTTP"), "http", list);
            this.setProxyEnvVariables(map, object.getProxyData("HTTPS"), "http", list2);
            if (object.getNonProxiedHosts().length > 0) {
                this.setNoProxyEnvVariables(map, list3, String.join((CharSequence)",", object.getNonProxiedHosts()));
                return;
            }
        } else {
            this.unSetProxyEnvVariables(map, list);
            this.unSetProxyEnvVariables(map, list2);
            object = ConfigService.CONFIG.getCloudUrl();
            if (object != null && !((String)object).isBlank()) {
                this.setNoProxyEnvVariables(map, list3, (String)object);
            }
        }
    }

    private void setProxyEnvVariables(Map<String, String> map, IProxyData object, String string, List<String> list) {
        if (object.getHost() != null) {
            String string2 = "";
            if (object.isRequiresAuthentication()) {
                string2 = String.format("%s:%s@", object.getUserId(), object.getPassword());
            }
            object = String.format("%s%s:%s", string2, object.getHost(), object.getPort());
            object = String.format("%s://%s", string, object);
            list.stream().forEach(arg_0 -> BinaryProcessGateway.lambda$0(map, (String)object, arg_0));
        }
    }

    private void unSetProxyEnvVariables(Map<String, String> map, List<String> list) {
        list.stream().forEach(string -> map.remove(string));
    }

    private void setNoProxyEnvVariables(Map<String, String> map, List<String> list, String string) {
        list.stream().forEach(string2 -> map.put((String)string2, string));
    }

    public String readRawResponse() {
        try {
            return this.reader.readLine();
        }
        catch (Exception exception) {
            throw new TabNineDeadException("End of stream reached");
        }
    }

    public void writeRequest(String string) {
        this.process.getOutputStream().write(string.getBytes(StandardCharsets.UTF_8));
        this.process.getOutputStream().flush();
    }

    public boolean isDead() {
        if (this.process == null) {
            return true;
        }
        return !this.process.isAlive();
    }

    public void destroy() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public long pid() {
        return this.process.pid();
    }

    private static /* synthetic */ void lambda$0(Map map, String string, String string2) {
        map.put(string2, string);
    }
}

