/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.jetty;

import com.iizix.util.IJarFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.resource.Resource;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class WSJarResourceFile {
    private final IJarFile a;
    private final JarEntry a;
    private final byte[] a;
    private final URI a;
    private final Instant a;

    public WSJarResourceFile(IJarFile iJarFile, JarEntry jarEntry, long l, URL uRL) {
        if (jarEntry.isDirectory()) {
            throw new IllegalArgumentException("The jarEntry refers to a directory");
        }
        this.a = iJarFile.getEntryData((ZipEntry)jarEntry);
        if (this.a == null) {
            throw new RuntimeException("JarEntry " + String.valueOf(jarEntry) + " in Jar file " + iJarFile.getName() + " has no data");
        }
        this.a = iJarFile;
        this.a = jarEntry;
        this.a = Instant.ofEpochMilli(l);
        try {
            this.a = uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("Failed conversion of URL to URI: " + String.valueOf(uRL), uRISyntaxException);
        }
    }

    public byte[] getData() {
        return (byte[])this.a.clone();
    }

    public URI getURI() {
        return this.a;
    }

    public String toString() {
        return this.getClass().getName() + "[jar=" + this.a.getName() + ",entry=" + this.a.getName() + ",uri=" + String.valueOf(this.a) + ",lastModified=" + String.valueOf(this.a) + ",size=" + this.a.length + "]";
    }

    public Resource newResource() {
        return new a();
    }

    private class a
    extends Resource {
        private a() {
        }

        public Path getPath() {
            return null;
        }

        public boolean isDirectory() {
            return false;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isContainedIn(Resource resource) {
            return false;
        }

        public URI getURI() {
            return WSJarResourceFile.this.a;
        }

        public String getName() {
            return WSJarResourceFile.this.a.toASCIIString();
        }

        public String getFileName() {
            return FileID.getFileName((URI)WSJarResourceFile.this.a);
        }

        public Instant lastModified() {
            return WSJarResourceFile.this.a;
        }

        public long length() {
            return WSJarResourceFile.this.a.length;
        }

        public Resource resolve(String string) {
            return null;
        }

        public InputStream newInputStream() throws IOException {
            return new ByteArrayInputStream(WSJarResourceFile.this.a);
        }

        @Deprecated(forRemoval=true)
        public ReadableByteChannel newReadableByteChannel() throws IOException {
            return Channels.newChannel(this.newInputStream());
        }

        public boolean exists() {
            return true;
        }

        public List<Resource> list() {
            return Collections.emptyList();
        }

        public Collection<Resource> getAllResources() {
            return Collections.emptyList();
        }

        public String toString() {
            return super.toString() + " [lastMod=" + String.valueOf(WSJarResourceFile.this.a) + ",length=" + WSJarResourceFile.this.a.length + "]";
        }
    }
}

