/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth;

import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.iizix.Utilities;
import java.util.Objects;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AccessToken {
    private final long a;
    private int a;
    final OAuth2AccessToken a;
    final OAuth1AccessToken a = System.currentTimeMillis();

    public AccessToken(OAuth2AccessToken oAuth2AccessToken) {
        this.a = Objects.requireNonNull(oAuth2AccessToken);
        this.a = null;
        Integer n = oAuth2AccessToken.getExpiresIn();
        if (n != null) {
            this.a = n;
        } else {
            String string = oAuth2AccessToken.getParameter("expires_in");
            if (string != null) {
                try {
                    this.a = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public AccessToken(OAuth1AccessToken oAuth1AccessToken, OAuth1RequestToken oAuth1RequestToken) {
        this.a = Objects.requireNonNull(oAuth1AccessToken);
        this.a = null;
        System.err.println("OAuth 1.0a request token = " + oAuth1RequestToken.getRawResponse());
        System.err.println("OAuth 1.0a access  token = " + oAuth1AccessToken.getRawResponse());
    }

    public boolean isValid(long l) {
        if (this.a < 0) {
            return false;
        }
        return System.currentTimeMillis() + l < this.a + (long)this.a;
    }

    public long getExpiresTime() {
        return this.a < 0 ? 0L : this.a + (long)this.a;
    }

    public String getAccessToken() {
        return this.a != null ? this.a.getAccessToken() : this.a.getToken();
    }

    public int hashCode() {
        return Long.hashCode(this.a) + this.a * 31 + (this.a != null ? this.a.hashCode() * 47 : this.a.hashCode() * 71);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof AccessToken) {
            AccessToken accessToken = (AccessToken)object;
            return this.a == accessToken.a && this.a == accessToken.a && Objects.equals(this.a, accessToken.a) && Objects.equals(this.a, accessToken.a);
        }
        return false;
    }

    public String toString() {
        String string = this.getClass().getName() + "created=" + Utilities.formatDate((long)this.a);
        string = string + (this.a != null ? string + ",OAuth2=" + String.valueOf(this.a) : string + ",OAuth1=" + String.valueOf(this.a));
        if (this.a >= 0) {
            string = string + ",expiresIn=" + this.a + ",expires=created=" + Utilities.formatDate((long)(this.a + (long)this.a));
        }
        return string + "]";
    }
}

