/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.monitor;

import com.iizix.LocaleInfo;
import com.iizix.SessionInfo;
import com.iizix.comm.session.SessionID;
import com.iizix.prop.Atom;
import com.iizix.prop.IGProp;
import com.iizix.prop.PropCnr;
import com.iizix.server.IEndPoint;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.monitor.ClientSessionProp;
import com.iizix.server.monitor.a;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.TimerTask;

public class EndPointPropCnr
extends PropCnr {
    static Atom a(IEndPoint iEndPoint) {
        return Atom.get((String)Long.toString(iEndPoint.getSessionInfo().getConnectionID()));
    }

    public EndPointPropCnr() {
    }

    public EndPointPropCnr(IEndPoint iEndPoint) {
        super(EndPointPropCnr.a(iEndPoint));
        SessionInfo sessionInfo = iEndPoint.getSessionInfo();
        IEndPoint.Type type = iEndPoint.getEndPointType();
        this.setInt("type", type.ordinal());
        this.setString("name", iEndPoint.getEndPointName());
        SessionID sessionID = sessionInfo.getSessionID();
        this.setString("id", sessionID != null ? sessionID.getSessionID() : "n/a");
        this.setLong("crt", sessionInfo.creationTime);
        String string = sessionInfo.getHostName();
        this.setString("host", string != null ? string : "n/a");
        SocketAddress socketAddress = sessionInfo.getRemoteAddress();
        this.setString("addr", socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress().getHostAddress() : "n/a");
        if (type == IEndPoint.Type.JAVASCRIPT_CLIENT) {
            this.a(sessionInfo);
        }
    }

    private void a(SessionInfo sessionInfo) {
        if (this.isDisposed()) {
            return;
        }
        AppSessionGyro appSessionGyro = AppSessionGyro.getSessionInstance(sessionInfo);
        if (appSessionGyro != null) {
            this.setLong("start", appSessionGyro.getCreationTime());
            this.setString("app", appSessionGyro.getAppID());
            this.setString("user", appSessionGyro.getSessionUserIdentifier().getUserID());
            this.setInt("count", appSessionGyro.getClientSessionsCount());
            LocaleInfo localeInfo = appSessionGyro.getEnvironment().getLocale();
            if (localeInfo == LocaleInfo.DEFAULT_LOCALEINFO) {
                this.setBool("def", true);
            }
            this.setString("locale", localeInfo.getLocale().toString());
            this.setString("lang", localeInfo.getLanguageCode());
            this.setString("zone", localeInfo.getZoneId().toString());
            this.setString("offset", localeInfo.getZoneOffset().toString());
            appSessionGyro.getServerConfigurationEnvironment().onAppSessionEndPoint(this, appSessionGyro);
            int n = 0;
            ClientSessionGyro[] clientSessionGyroArray = appSessionGyro.getClientSessionGyros();
            int n2 = clientSessionGyroArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ClientSessionGyro clientSessionGyro = clientSessionGyroArray[n3];
                this.addProp2((IGProp)new ClientSessionProp(Atom.get((String)Integer.toString(n++)), clientSessionGyro));
                ++n3;
            }
        } else {
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)new a(this, sessionInfo), 2000L);
        }
    }

    public EndPointPropCnr clone() {
        try {
            return (EndPointPropCnr)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }
}

