/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.client;

import com.iizix.ILog;
import com.iizix.comm.ITransactionProcessor;
import com.iizix.comm.session.SessionTransMgr;
import com.iizix.nio.IWebSocketComm;
import com.iizix.server.IEndPoint;
import com.iizix.server.IEndPointConstructor;
import com.iizix.server.ServerShell;
import com.iizix.server.client.ClientEndPoint;
import com.iizix.server.client.ClientParams;
import com.iizix.server.client.ClientTransactionProcessor;
import com.iizix.server.client.FailedReconnectClientEndPoint;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public class ClientEndPointConstructor
implements IEndPointConstructor<Object> {
    private static final String[] a = new String[]{"/iizi/app.ws"};

    @Override
    public String[] getHandledContextPaths() {
        return a;
    }

    @Override
    public Object isHandled(ServerShell serverShell, IWebSocketComm iWebSocketComm, String string, String string2, Map<String, List<String>> map) {
        if (string2 == null || !string.equals("/iizi/app.ws")) {
            return null;
        }
        SessionTransMgr sessionTransMgr = null;
        if (string2.startsWith("reconnect=")) {
            int n = string2.indexOf("&serial=");
            try {
                String string3 = string2.substring(10, n);
                int n2 = Integer.parseInt(string2.substring(n + 8));
                if (n2 > 0 && n2 <= 65535) {
                    if (map == null) {
                        if (SessionTransMgr.isReconnectionInstance((String)string3, (String)iWebSocketComm.getRemoteAddr())) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                    sessionTransMgr = SessionTransMgr.createReconnectionInstance((SocketAddress)iWebSocketComm.getSocketAddress(), (String)string3, (int)n2);
                }
            }
            catch (Exception exception) {}
        } else {
            ClientParams clientParams = new ClientParams(serverShell, string2);
            if (clientParams.error != null) {
                ILog.WARNING(this.getClass(), (String)clientParams.error);
                return null;
            }
            if (map == null) {
                return Boolean.TRUE;
            }
            sessionTransMgr = new SessionTransMgr((ITransactionProcessor)new ClientTransactionProcessor(clientParams));
        }
        return sessionTransMgr;
    }

    @Override
    public IEndPoint createInstance(ServerShell serverShell, long l, IWebSocketComm iWebSocketComm, String string, String string2, Map<String, List<String>> map, Object object) throws IOException {
        SessionTransMgr sessionTransMgr = (SessionTransMgr)object;
        ClientTransactionProcessor clientTransactionProcessor = (ClientTransactionProcessor)sessionTransMgr.getProcessor();
        if (clientTransactionProcessor == null) {
            return new FailedReconnectClientEndPoint(serverShell, l, iWebSocketComm, sessionTransMgr);
        }
        return new ClientEndPoint(serverShell, l, iWebSocketComm, sessionTransMgr, clientTransactionProcessor);
    }
}

