/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class YearValue
extends TermporalAccessorValue<Year> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.Year;
    }

    @Override
    public Class<Year> getValueClass() {
        return Year.class;
    }

    @Override
    public String getDescription() {
        return "Year in the ISO-8601 calendar system, such as 2007 (allowing mapping to other calendars)";
    }

    @Override
    public Year createDefault() {
        return Year.of(1970);
    }

    private Year a(String string) {
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= -999999999 && n2 <= 999999999) {
                return Year.of(n2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Year parse(String string) throws ParseException, Exception {
        try {
            return Year.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            Year year = this.a(string);
            if (year != null) {
                return year;
            }
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public Year parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return Year.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            Year year = this.a(string);
            if (year != null) {
                return year;
            }
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public Year convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof Year) {
            return (Year)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            if (l3 >= -9999L && l3 <= 9999L) {
                return Year.of((int)l3);
            }
            Date date = new Date(l3);
            return Year.of(date.getYear() + 1900);
        }
        if (object instanceof LocalDate || object instanceof LocalDateTime || object instanceof OffsetDateTime || object instanceof ZonedDateTime) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return Year.from(temporalAccessor);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return Year.of(date.getYear() + 1900);
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            return Year.of(((GregorianCalendar)object).get(1));
        }
        if (object instanceof YearMonth) {
            return Year.of(((YearMonth)object).getYear());
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return Year.of((int)(l2 / 86400000L) + 1970);
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return this.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(Year year, LocaleInfo localeInfo) {
        return LocalDate.of(year.getValue(), 1, 1).toEpochDay() * 86400000L;
    }
}

