/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.value.TermporalAccessorValue;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;

public class MonthDayValue
extends TermporalAccessorValue<MonthDay> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.MonthDay;
    }

    @Override
    public Class<MonthDay> getValueClass() {
        return MonthDay.class;
    }

    @Override
    public String getDescription() {
        return "Month-day in the ISO-8601 calendar system, such as --12-03";
    }

    @Override
    public MonthDay createDefault() {
        return MonthDay.of(1, 1);
    }

    @Override
    public MonthDay parse(String string) throws ParseException, Exception {
        try {
            return MonthDay.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public MonthDay parse(String string, DateTimeFormatter dateTimeFormatter) throws ParseException, Exception {
        try {
            return MonthDay.parse(string, dateTimeFormatter);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public MonthDay convert(Object object, Value.Type type, LocaleInfo localeInfo) throws Exception {
        long l2;
        if (object instanceof MonthDay) {
            return (MonthDay)object;
        }
        if (object instanceof Number) {
            long l3 = ((Number)object).longValue();
            int n2 = (int)(l3 % 100L);
            long l4 = l3 / 100L;
            if (l4 >= 1L && l4 <= 12L && n2 >= 1 && n2 <= 31) {
                return MonthDay.of((int)l4, n2);
            }
            Date date = new Date(l3);
            return MonthDay.of(date.getMonth() + 1, date.getDate());
        }
        if (object instanceof LocalDate || object instanceof LocalDateTime || object instanceof OffsetDateTime || object instanceof ZonedDateTime) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)object;
            return MonthDay.from(temporalAccessor);
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return MonthDay.of(date.getMonth() + 1, date.getDate());
        }
        if (object instanceof XMLGregorianCalendar) {
            object = ((XMLGregorianCalendar)object).toGregorianCalendar();
        }
        if (object instanceof GregorianCalendar) {
            GregorianCalendar gregorianCalendar = (GregorianCalendar)object;
            int n3 = gregorianCalendar.get(5);
            int n4 = gregorianCalendar.get(2);
            return MonthDay.of(n4, n3);
        }
        if (type != null && (l2 = type.valueObject.asLongCast(object, localeInfo)) != Long.MIN_VALUE) {
            return MonthDay.from(Instant.ofEpochMilli(l2));
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        try {
            return MonthDay.parse(string);
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new ParseException(dateTimeParseException.getMessage(), dateTimeParseException.getErrorIndex());
        }
    }

    @Override
    public long asLong(MonthDay monthDay, LocaleInfo localeInfo) {
        return LocalDate.of(1970, monthDay.getMonthValue(), monthDay.getDayOfMonth()).toEpochDay() * 86400000L;
    }
}

